/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository;

import java.util.HashMap;
import java.util.Map;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.jcr.JCRAmetysObjectFactory;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;

public class AmetysObjectFactoryExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<AmetysObjectFactory> {
    public static final String ROLE = AmetysObjectFactoryExtensionPoint.class.getName();
    private Map<String, AmetysObjectFactory> _schemes = new HashMap<String, AmetysObjectFactory>();
    private Map<String, AmetysObjectFactory> _nodetypes = new HashMap<String, AmetysObjectFactory>();

    public void initializeExtensions() throws Exception {
        super.initializeExtensions();
        for (String id : this.getExtensionsIds()) {
            AmetysObjectFactory factory = (AmetysObjectFactory)this.getExtension(id);
            this._schemes.put(factory.getScheme(), factory);
            if (!(factory instanceof JCRAmetysObjectFactory)) continue;
            JCRAmetysObjectFactory jcrFactory = (JCRAmetysObjectFactory)factory;
            for (String nodetype : jcrFactory.getNodetypes()) {
                if (this._nodetypes.containsKey(nodetype)) {
                    throw new IllegalArgumentException("Nodetype '" + nodetype + "' cannot be managed by more than one factory.");
                }
                this._nodetypes.put(nodetype, factory);
            }
        }
    }

    public AmetysObjectFactory getFactoryForScheme(String scheme) {
        return this._schemes.get(scheme);
    }

    public AmetysObjectFactory getFactoryForNodetype(String nodetype) {
        return this._nodetypes.get(nodetype);
    }
}

