/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;

public interface AmetysObjectIterator<A extends AmetysObject>
extends Iterator<A> {
    public long getPosition();

    public long getSize();

    default public void skip(long skipNum) {
        if (skipNum == 0L) {
            return;
        }
        if (skipNum < 0L) {
            throw new AmetysRepositoryException("Cannot skip with a negative number");
        }
        long size = this.getSize();
        if (size != -1L && skipNum > size - this.getPosition()) {
            throw new NoSuchElementException();
        }
        for (long i = skipNum; i > 0L; --i) {
            this.next();
        }
    }
}

