/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysObjectFactoryExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ChainedAmetysObjectIterable;
import org.ametys.plugins.repository.NamespacesExtensionPoint;
import org.ametys.plugins.repository.NodeIteratorIterable;
import org.ametys.plugins.repository.NodeTypeDefinitionsExtensionPoint;
import org.ametys.plugins.repository.RepositoryIntegrityViolationException;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObjectFactory;
import org.ametys.plugins.repository.jcr.NodeTypeHelper;
import org.ametys.plugins.repository.provider.JackrabbitRepository;
import org.ametys.plugins.repository.virtual.VirtualAmetysObjectFactory;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDefStore;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;

public class AmetysObjectResolver
extends AbstractLogEnabled
implements Serviceable,
Initializable,
Component {
    public static final String ROLE = AmetysObjectResolver.class.getName();
    public static final String ROOT_REPO = "ametys:root";
    public static final String ROOT_TYPE = "ametys:root";
    public static final String OBJECT_TYPE = "ametys:object";
    public static final String VIRTUAL_PROPERTY = "ametys-internal:virtual";
    private AmetysObjectFactoryExtensionPoint _ametysFactoryExtensionPoint;
    private NamespacesExtensionPoint _namespacesExtensionPoint;
    private NodeTypeDefinitionsExtensionPoint _nodetypeDefsExtensionPoint;
    private Repository _repository;
    private SourceResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._repository = (Repository)manager.lookup("javax.jcr.Repository");
        this._ametysFactoryExtensionPoint = (AmetysObjectFactoryExtensionPoint)((Object)manager.lookup(AmetysObjectFactoryExtensionPoint.ROLE));
        this._namespacesExtensionPoint = (NamespacesExtensionPoint)((Object)manager.lookup(NamespacesExtensionPoint.ROLE));
        this._nodetypeDefsExtensionPoint = (NodeTypeDefinitionsExtensionPoint)((Object)manager.lookup(NodeTypeDefinitionsExtensionPoint.ROLE));
    }

    public void initialize() throws Exception {
        Session session = this._repository.login();
        this._initNamespaces(session);
        this._initNodetypes(session);
        if (!session.getRootNode().hasNode("ametys:root")) {
            this.getLogger().info("Creating ametys root Node");
            session.getRootNode().addNode("ametys:root", "ametys:root");
            AmetysObjectResolver.initRepoNodes(session, this.getLogger());
        }
        if (session.hasPendingChanges()) {
            session.save();
        }
        session.logout();
        if (this._repository instanceof JackrabbitRepository) {
            ((JackrabbitRepository)this._repository).compareCustomNodetypes();
        }
    }

    public static boolean initRepoNodes(Session session, Logger logger) throws RepositoryException {
        logger.info("Creating ametys migration versions root Node");
        session.getRootNode().getNode("ametys:root").addNode("ametys:versions", "ametys:versions");
        return session.hasPendingChanges();
    }

    private void _initNamespaces(Session session) throws RepositoryException {
        NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
        List<String> prefixes = Arrays.asList(registry.getPrefixes());
        this._namespacesExtensionPoint.getExtensionsIds().stream().filter(prefix -> !prefixes.contains(prefix)).forEach(LambdaUtils.wrapConsumer(prefix -> {
            String namespace = this._namespacesExtensionPoint.getNamespace((String)prefix);
            this.getLogger().debug("Adding {} namespace", prefix);
            registry.registerNamespace(prefix, namespace);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initNodetypes(Session session) throws RepositoryException, InvalidNodeTypeDefException, IOException {
        NodeTypeDefStore store = new NodeTypeDefStore();
        Source fsource = this._resolver.resolveURI("plugin:repository://nodetypes/ametys_nodetypes.xml");
        try (InputStream is = fsource.getInputStream();){
            store.load(is);
        }
        finally {
            this._resolver.release(fsource);
        }
        for (String nodetypeDef : this._nodetypeDefsExtensionPoint.getNodeTypeDefinitions()) {
            Name[] source = this._resolver.resolveURI(nodetypeDef);
            try {
                InputStream is = source.getInputStream();
                try {
                    store.load(is);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            finally {
                this._resolver.release((Source)source);
            }
        }
        NodeTypeManagerImpl ntManager = (NodeTypeManagerImpl)session.getWorkspace().getNodeTypeManager();
        NodeTypeRegistry registry = ntManager.getNodeTypeRegistry();
        for (Name name : registry.getRegisteredNodeTypes()) {
            store.remove(name);
        }
        Collection ntDefs = store.all();
        if (!ntDefs.isEmpty()) {
            registry.registerNodeTypes(ntDefs);
        }
    }

    @Deprecated
    public <A extends AmetysObject> A resolve(String absolutePath) throws AmetysRepositoryException, UnknownAmetysObjectException {
        return this.resolveByPath(absolutePath);
    }

    public <A extends AmetysObject> A resolveByPath(String absolutePath) throws AmetysRepositoryException, UnknownAmetysObjectException {
        return this.resolveByPath(absolutePath, null);
    }

    public <A extends AmetysObject> A resolveByPath(String absolutePath, Session session) throws AmetysRepositoryException, UnknownAmetysObjectException {
        Node rootNode;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Resolving " + absolutePath);
        }
        if (absolutePath == null) {
            throw new AmetysRepositoryException("Absolute path cannot be null");
        }
        Session jcrSession = null;
        try {
            jcrSession = session != null ? session : this._repository.login();
            rootNode = jcrSession.getRootNode().getNode("ametys:root");
        }
        catch (PathNotFoundException e) {
            if (session == null && jcrSession != null) {
                jcrSession.logout();
            }
            throw new AmetysRepositoryException("Unable to get ametys:root Node", e);
        }
        catch (RepositoryException e) {
            if (session == null && jcrSession != null) {
                jcrSession.logout();
            }
            throw new AmetysRepositoryException("An error occured while getting ametys:root node", e);
        }
        try {
            return (A)this._resolve(null, rootNode, absolutePath, false);
        }
        catch (RepositoryException e) {
            if (session == null) {
                jcrSession.logout();
            }
            throw new AmetysRepositoryException("An error occured while resolving " + absolutePath, e);
        }
    }

    public <A extends AmetysObject> A resolveById(String id) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Resolving " + id);
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new AmetysRepositoryException("An object id must conform to the <protocol>://<protocol-specific-part> syntax but id is blank or null");
        }
        int index = id.indexOf("://");
        if (index == -1) {
            throw new AmetysRepositoryException("An object id must conform to the <protocol>://<protocol-specific-part> syntax: " + id);
        }
        String scheme = id.substring(0, index);
        AmetysObjectFactory factory = this._ametysFactoryExtensionPoint.getFactoryForScheme(scheme);
        if (factory == null) {
            throw new UnknownAmetysObjectException("There's no object for id " + id);
        }
        return factory.getAmetysObjectById(id);
    }

    public <A extends AmetysObject> A resolveById(String id, Session session) throws AmetysRepositoryException, UnknownAmetysObjectException, RepositoryException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Resolving " + id);
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new AmetysRepositoryException("An object id must conform to the <protocol>://<protocol-specific-part> syntax but id is blank or null");
        }
        int index = id.indexOf("://");
        if (index == -1) {
            throw new AmetysRepositoryException("An object id must conform to the <protocol>://<protocol-specific-part> syntax: " + id);
        }
        String scheme = id.substring(0, index);
        AmetysObjectFactory factory = this._ametysFactoryExtensionPoint.getFactoryForScheme(scheme);
        if (factory == null) {
            throw new UnknownAmetysObjectException("There's no object for id " + id);
        }
        if (!(factory instanceof JCRAmetysObjectFactory)) {
            throw new IllegalArgumentException("The expert method resolveById(String, Session) should only be called for id corresponding to a JCRAmetysObjectFactory");
        }
        return ((JCRAmetysObjectFactory)factory).getAmetysObjectById(id, session);
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        int index = id.indexOf("://");
        if (index == -1) {
            throw new AmetysRepositoryException("An object id must conform to the <protocol>://<protocol-specific-part> syntax: " + id);
        }
        String scheme = id.substring(0, index);
        AmetysObjectFactory factory = this._ametysFactoryExtensionPoint.getFactoryForScheme(scheme);
        if (factory == null) {
            return false;
        }
        return factory.hasAmetysObjectForId(id);
    }

    public <A extends AmetysObject> A resolve(Node node, boolean allowUnknownNode) throws AmetysRepositoryException, RepositoryException {
        return (A)this._resolve(null, node, null, allowUnknownNode);
    }

    public <A extends AmetysObject> A resolve(String parentPath, Node node, String childPath, boolean allowUnknownNode) throws AmetysRepositoryException, UnknownAmetysObjectException, RepositoryException {
        return (A)this._resolve(parentPath, node, childPath, allowUnknownNode);
    }

    private <T extends AmetysObject> T _resolve(String parentPath, Node node, String childPath, boolean allowUnknownNode) throws AmetysRepositoryException, UnknownAmetysObjectException, RepositoryException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Entering _resolve with parentPath=" + parentPath + ", node=" + node.getPath() + ", childPath=" + childPath + ", ignoreUnknownNodes=" + allowUnknownNode);
        }
        String path = childPath == null ? "" : childPath;
        String string = path = path.length() == 0 || path.charAt(0) != '/' ? path : path.substring(1);
        if (path.length() != 0 && (Character.isSpaceChar(path.charAt(0)) || Character.isSpaceChar(path.charAt(path.length() - 1)))) {
            throw new AmetysRepositoryException("Path cannot begin or end with a space character");
        }
        String nodeType = NodeTypeHelper.getNodeTypeName(node);
        JCRAmetysObjectFactory jcrFactory = this._getJCRFactory(nodeType, allowUnknownNode, parentPath, childPath);
        if (jcrFactory == null) {
            return null;
        }
        Object rootObject = jcrFactory.getAmetysObject(node, parentPath);
        if (path.length() != 0) {
            if (!(rootObject instanceof TraversableAmetysObject)) {
                throw new AmetysRepositoryException("The node of type '" + nodeType + "' at path '" + node.getPath() + "' does not corresponds to a TraversableAmetysObject");
            }
            return (T)((TraversableAmetysObject)rootObject).getChild(path);
        }
        return (T)rootObject;
    }

    private JCRAmetysObjectFactory _getJCRFactory(String nodeType, boolean allowUnknownNode, String parentPath, String childPath) {
        AmetysObjectFactory factory;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Nodetype is " + nodeType);
        }
        if ((factory = this._ametysFactoryExtensionPoint.getFactoryForNodetype(nodeType)) == null) {
            if (allowUnknownNode) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("No factory for nodetype " + nodeType + ". Unknown node is allowed, returning null.");
                }
                return null;
            }
            throw new UnknownAmetysObjectException("Cannot get factory for node '" + childPath + "' under '" + parentPath + "': There's no factory for nodetype: " + nodeType);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Factory is " + factory.getClass().getName());
        }
        if (!(factory instanceof JCRAmetysObjectFactory)) {
            throw new AmetysRepositoryException("A factory resolving JCR nodes must implements JCRAmetysObjectFactory");
        }
        JCRAmetysObjectFactory jcrFactory = (JCRAmetysObjectFactory)factory;
        return jcrFactory;
    }

    public <A extends AmetysObject> AmetysObjectIterable<A> resolveVirtualChildren(JCRAmetysObject parent) throws AmetysRepositoryException, RepositoryException {
        Node contextNode = parent.getNode();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Entering resolveVirtualChildren with parent=" + String.valueOf(parent));
        }
        if (!contextNode.hasProperty(VIRTUAL_PROPERTY)) {
            return null;
        }
        Value[] values = contextNode.getProperty(VIRTUAL_PROPERTY).getValues();
        ArrayList children = new ArrayList(values.length);
        for (Value value : values) {
            AmetysObjectFactory factory;
            String id = value.getString();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Found virtual factory id: " + id);
            }
            if ((factory = (AmetysObjectFactory)this._ametysFactoryExtensionPoint.getExtension(id)) == null) {
                throw new AmetysRepositoryException("There's no virtual factory for id " + id);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Found factory: " + factory.getClass().getName());
            }
            if (!(factory instanceof VirtualAmetysObjectFactory)) {
                throw new AmetysRepositoryException("A factory handling virtual objects must implement VirtualAmetysObjectFactory");
            }
            VirtualAmetysObjectFactory virtualFactory = (VirtualAmetysObjectFactory)factory;
            children.add(virtualFactory.getChildren(parent));
        }
        return new ChainedAmetysObjectIterable(children);
    }

    public AmetysObject resolveVirtualChild(JCRAmetysObject parent, String childPath) throws AmetysRepositoryException, RepositoryException, UnknownAmetysObjectException {
        String subPath;
        Node contextNode = parent.getNode();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Entering resolveVirtualChild with parent=" + String.valueOf(parent));
        }
        if (!contextNode.hasProperty(VIRTUAL_PROPERTY)) {
            throw new UnknownAmetysObjectException("There's no virtual child at Ametys path " + parent.getPath());
        }
        String path = childPath == null ? "" : childPath;
        path = path.length() == 0 || path.charAt(0) != '/' ? path : path.substring(1);
        int index = path.indexOf(47);
        String childName = index == -1 ? path : path.substring(0, index);
        String string = subPath = index == -1 ? null : path.substring(index + 1);
        if (childName.length() == 0) {
            throw new AmetysRepositoryException("A path element cannot be empty in " + childPath);
        }
        if (Character.isSpaceChar(path.charAt(0)) || Character.isSpaceChar(path.charAt(path.length() - 1))) {
            throw new AmetysRepositoryException("Path element cannot begin or end with a space character: " + childName);
        }
        Value[] values = contextNode.getProperty(VIRTUAL_PROPERTY).getValues();
        AmetysObject object = this._getVirtualChild(parent, childName, values);
        if (object == null) {
            throw new UnknownAmetysObjectException("There's no virtual object named " + childName + " at Ametys path " + parent.getPath());
        }
        if (subPath != null) {
            if (!(object instanceof TraversableAmetysObject)) {
                throw new AmetysRepositoryException("The virtual object " + childName + "at path '" + childPath + "' does not corresponds to a TraversableAmetysObject");
            }
            return ((TraversableAmetysObject)object).getChild(subPath);
        }
        return object;
    }

    public <A extends AmetysObject> AmetysObjectIterable<A> query(String jcrQuery) {
        Session session = null;
        try {
            session = this._repository.login();
            return this.query(jcrQuery, session);
        }
        catch (RepositoryException ex) {
            if (session != null) {
                session.logout();
            }
            throw new AmetysRepositoryException("An error occured executing the JCR query : " + jcrQuery, ex);
        }
    }

    public <A extends AmetysObject> AmetysObjectIterable<A> query(String jcrQuery, Session session) throws RepositoryException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing XPath query: '" + jcrQuery + "'");
        }
        Query query = session.getWorkspace().getQueryManager().createQuery(jcrQuery, "xpath");
        long t1 = System.currentTimeMillis();
        NodeIteratorIterable it = new NodeIteratorIterable(this, query.execute().getNodes(), null, session);
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("JCR query '" + jcrQuery + "' executed in " + (System.currentTimeMillis() - t1) + " ms");
        }
        return it;
    }

    private AmetysObject _getVirtualChild(JCRAmetysObject parent, String childName, Value[] values) throws RepositoryException {
        int i = 0;
        AmetysObject object = null;
        while (object == null && i < values.length) {
            AmetysObjectFactory factory;
            Value value = values[i];
            String id = value.getString();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Found virtual factory id: " + id);
            }
            if ((factory = (AmetysObjectFactory)this._ametysFactoryExtensionPoint.getExtension(id)) == null) {
                throw new AmetysRepositoryException("There's no virtual factory for id " + id);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Found factory: " + factory.getClass().getName());
            }
            if (!(factory instanceof VirtualAmetysObjectFactory)) {
                throw new AmetysRepositoryException("A factory handling virtual objects must implement VirtualAmetysObjectFactory: " + id);
            }
            VirtualAmetysObjectFactory virtualFactory = (VirtualAmetysObjectFactory)factory;
            try {
                object = (AmetysObject)virtualFactory.getChild(parent, childName);
            }
            catch (UnknownAmetysObjectException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("The factory: " + factory.getClass().getName() + " has no child named" + childName, (Throwable)e);
                }
                ++i;
            }
        }
        return object;
    }

    public <A extends AmetysObject> A createAndResolve(String parentPath, Node parentNode, String childName, String nodetype) throws AmetysRepositoryException, RepositoryIntegrityViolationException, RepositoryException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Entering createAndResolve with parentPath=" + parentPath + ", parentNode=" + parentNode.getPath() + ", childName=" + childName + ", nodetype=" + nodetype);
        }
        if (this._ametysFactoryExtensionPoint.getFactoryForNodetype(nodetype) == null) {
            throw new AmetysRepositoryException("Cannot create a node '" + childName + "' under '" + parentPath + "': There's no factory for nodetype: " + nodetype);
        }
        try {
            Node node = parentNode.addNode(childName, nodetype);
            NodeType[] mixinNodeTypes = node.getMixinNodeTypes();
            boolean foundMixin = false;
            for (int i = 0; !foundMixin && i < mixinNodeTypes.length; ++i) {
                if (!OBJECT_TYPE.equals(mixinNodeTypes[i].getName())) continue;
                foundMixin = true;
            }
            if (!foundMixin) {
                node.addMixin(OBJECT_TYPE);
            }
            return this.resolve(parentPath, node, null, false);
        }
        catch (ItemExistsException e) {
            throw new RepositoryIntegrityViolationException("The object " + childName + " already exist at path " + parentPath, e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to add child node for the underlying node for object at path " + parentPath, e);
        }
    }
}

