/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysRepositoryException;

public class ChainedAmetysObjectIterable<A extends AmetysObject>
implements AmetysObjectIterable<A> {
    long _size;
    private List<AmetysObjectIterable<A>> _iterables;
    private boolean _sizeComputed;

    public ChainedAmetysObjectIterable(List<AmetysObjectIterable<A>> iterables) {
        this._iterables = iterables;
    }

    @Override
    public long getSize() {
        if (!this._sizeComputed) {
            this._size = this._computeSize();
        }
        return this._size;
    }

    private long _computeSize() {
        this._sizeComputed = true;
        long size = 0L;
        for (AmetysObjectIterable<A> it : this._iterables) {
            long s = it.getSize();
            if (s == -1L) {
                return -1L;
            }
            size += s;
        }
        return size;
    }

    @Override
    public AmetysObjectIterator<A> iterator() {
        List its = this._iterables.stream().map(it -> it.iterator()).collect(Collectors.toList());
        return new ChainedIterator(its);
    }

    @Override
    public void close() {
        for (AmetysObjectIterable<A> it : this._iterables) {
            it.close();
        }
    }

    class ChainedIterator
    implements AmetysObjectIterator<A> {
        private long _position;
        private int _currentIterator;
        private List<AmetysObjectIterator<A>> _its;

        public ChainedIterator(List<AmetysObjectIterator<A>> its) {
            this._its = its;
        }

        @Override
        public long getPosition() {
            return this._position;
        }

        @Override
        public long getSize() {
            return ChainedAmetysObjectIterable.this.getSize();
        }

        @Override
        public void skip(long skipNum) {
            if (skipNum == 0L) {
                return;
            }
            if (skipNum < 0L) {
                throw new AmetysRepositoryException("Cannot skip with a negative number");
            }
            for (long i = skipNum; i > 0L; --i) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this._position;
                this._its.get(this._currentIterator).skip(1L);
            }
        }

        @Override
        public boolean hasNext() {
            while (this._currentIterator < this._its.size() && !this._its.get(this._currentIterator).hasNext()) {
                ++this._currentIterator;
            }
            return this._currentIterator < this._its.size() && this._its.get(this._currentIterator).hasNext();
        }

        @Override
        public A next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this._position;
            return (AmetysObject)this._its.get(this._currentIterator).next();
        }
    }
}

