/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;

public class CollatingUniqueAmetysObjectIterable<A extends AmetysObject>
implements AmetysObjectIterable<A> {
    Comparator<A> _comparator;
    private List<AmetysObjectIterable<A>> _iterables;

    public CollatingUniqueAmetysObjectIterable(List<AmetysObjectIterable<A>> iterables, Comparator<A> comparator) {
        this._iterables = iterables;
        this._comparator = comparator;
    }

    @Override
    public long getSize() {
        if (this._iterables.size() == 1) {
            return this._iterables.get(0).getSize();
        }
        return this._iterables.size() == 0 ? 0L : -1L;
    }

    @Override
    public AmetysObjectIterator<A> iterator() {
        List its = this._iterables.stream().map(it -> it.iterator()).collect(Collectors.toList());
        return new CollatingIterator(its, this.getSize());
    }

    @Override
    public void close() {
        for (AmetysObjectIterable<A> it : this._iterables) {
            it.close();
        }
    }

    class CollatingIterator
    implements AmetysObjectIterator<A> {
        private long _position;
        private ArrayList<A> _nextObjects;
        private BitSet _nextObjectSet;
        private Set<String> _identifiers = new HashSet<String>();
        private int _itCount;
        private List<AmetysObjectIterator<A>> _its;
        private long _size;

        public CollatingIterator(List<AmetysObjectIterator<A>> its, long size) {
            this._its = its;
            this._size = size;
        }

        @Override
        public long getPosition() {
            return this._position;
        }

        @Override
        public long getSize() {
            return this._size;
        }

        @Override
        public boolean hasNext() {
            this._initialize();
            boolean hasNext = false;
            for (int i = 0; i < this._itCount && !hasNext; ++i) {
                hasNext = this._nextObjectSet.get(i) ? true : this._setNextObject(i);
            }
            return hasNext;
        }

        @Override
        public A next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int leastIndex = this._least();
            if (leastIndex == -1) {
                throw new NoSuchElementException();
            }
            ++this._position;
            AmetysObject object = (AmetysObject)this._nextObjects.get(leastIndex);
            this._clear(leastIndex);
            return object;
        }

        private void _initialize() {
            if (this._nextObjects == null) {
                this._itCount = this._its.size();
                this._nextObjects = new ArrayList(this._itCount);
                this._nextObjectSet = new BitSet(this._itCount);
                for (int i = 0; i < this._itCount; ++i) {
                    this._nextObjects.add(null);
                    this._nextObjectSet.clear(i);
                }
            }
        }

        private boolean _setNextObject(int iterableIndex) {
            AmetysObjectIterator it = this._its.get(iterableIndex);
            while (it.hasNext()) {
                AmetysObject object = (AmetysObject)it.next();
                if (!this._identifiers.add(object.getId())) continue;
                this._nextObjects.set(iterableIndex, object);
                this._nextObjectSet.set(iterableIndex);
                return true;
            }
            this._nextObjects.set(iterableIndex, null);
            this._nextObjectSet.clear(iterableIndex);
            return false;
        }

        private void _clear(int iterableIndex) {
            this._nextObjects.set(iterableIndex, null);
            this._nextObjectSet.clear(iterableIndex);
        }

        private int _least() {
            int leastIndex = -1;
            AmetysObject leastObject = null;
            for (int i = 0; i < this._itCount; ++i) {
                if (!this._nextObjectSet.get(i)) {
                    this._setNextObject(i);
                }
                if (!this._nextObjectSet.get(i)) continue;
                if (leastIndex == -1) {
                    leastIndex = i;
                    leastObject = (AmetysObject)this._nextObjects.get(i);
                    continue;
                }
                AmetysObject curObject = (AmetysObject)this._nextObjects.get(i);
                if (CollatingUniqueAmetysObjectIterable.this._comparator.compare(curObject, leastObject) >= 0) continue;
                leastObject = curObject;
                leastIndex = i;
            }
            return leastIndex;
        }
    }
}

