/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository;

import java.util.Collection;
import java.util.Iterator;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysObjectResolver;

public class IdCollectionIterable<A extends AmetysObject>
implements AmetysObjectIterable<A> {
    AmetysObjectResolver _resolver;
    private Collection<String> _ids;

    public IdCollectionIterable(AmetysObjectResolver resolver, Collection<String> ids) {
        this._resolver = resolver;
        this._ids = ids;
    }

    @Override
    public long getSize() {
        return this._ids.size();
    }

    @Override
    public AmetysObjectIterator<A> iterator() {
        return new IdIterator(this._ids.iterator(), this._ids.size());
    }

    @Override
    public void close() {
    }

    class IdIterator
    implements AmetysObjectIterator<A> {
        private Iterator<String> _it;
        private int _pos;
        private long _size;

        public IdIterator(Iterator<String> it, long size) {
            this._it = it;
            this._size = size;
        }

        @Override
        public long getSize() {
            return this._size;
        }

        @Override
        public long getPosition() {
            return this._pos;
        }

        @Override
        public boolean hasNext() {
            return this._it.hasNext();
        }

        @Override
        public A next() {
            ++this._pos;
            return IdCollectionIterable.this._resolver.resolveById(this._it.next());
        }

        @Override
        public void remove() {
            this._it.remove();
        }
    }
}

