/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class NamespacesExtensionPoint
extends AbstractLogEnabled
implements ExtensionPoint<String>,
Component {
    public static final String ROLE = NamespacesExtensionPoint.class.getName();
    private Map<String, String> _namespaces = new HashMap<String, String>();

    public void addExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException {
        String namespace = configuration.getChild("namespace", true).getValue(null);
        if (namespace != null) {
            if (this._namespaces.containsKey(id)) {
                this.getLogger().error("The namespace for prefix " + id + " is already defined. It will be ignored");
            } else {
                this._namespaces.put(id, namespace);
            }
        }
    }

    public void initializeExtensions() throws Exception {
    }

    public boolean hasExtension(String id) {
        return this._namespaces.containsKey(id);
    }

    public String getExtension(String id) {
        if (this.hasExtension(id)) {
            return this._namespaces.get(id);
        }
        return null;
    }

    public Set<String> getExtensionsIds() {
        return this._namespaces.keySet();
    }

    public String getNamespace(String prefix) {
        return this._namespaces.get(prefix);
    }
}

