/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;

public class NodeIteratorIterable<A extends AmetysObject>
implements AmetysObjectIterable<A> {
    AmetysObjectResolver _resolver;
    String _parentPath;
    Session _session;
    List<A> _buffer = new ArrayList<A>();
    boolean _skipCalled;
    private NodeIterator _iterator;

    public NodeIteratorIterable(AmetysObjectResolver resolver, NodeIterator iterator, String parentPath, Session session) {
        this._resolver = resolver;
        this._iterator = iterator;
        this._parentPath = parentPath;
        this._session = session;
    }

    @Override
    public long getSize() {
        return this._iterator.getSize();
    }

    @Override
    public AmetysObjectIterator<A> iterator() {
        if (this._skipCalled) {
            throw new IllegalStateException("iterator() cannot be called on NodeIteratorIterable after skip() have been called. Results would be inconsistent.");
        }
        return new NodeIteratorIterator(this._iterator);
    }

    @Override
    public void close() {
        if (this._session != null && this._session.isLive()) {
            this._session.logout();
        }
    }

    class NodeIteratorIterator
    implements AmetysObjectIterator<A> {
        private NodeIterator _it;
        private int _position;

        public NodeIteratorIterator(NodeIterator it) {
            this._it = it;
        }

        @Override
        public long getPosition() {
            return this._position;
        }

        @Override
        public long getSize() {
            return this._it.getSize();
        }

        @Override
        public void skip(long skipNum) {
            if (skipNum > (long)(NodeIteratorIterable.this._buffer.size() - this._position)) {
                NodeIteratorIterable.this._skipCalled = true;
                this._it.skip(skipNum - (long)(NodeIteratorIterable.this._buffer.size() - this._position));
                int i = NodeIteratorIterable.this._buffer.size() - this._position;
                while ((long)i < skipNum) {
                    NodeIteratorIterable.this._buffer.add(null);
                    ++i;
                }
            }
            this._position = (int)((long)this._position + skipNum);
        }

        @Override
        public boolean hasNext() {
            return this._position < NodeIteratorIterable.this._buffer.size() || this._it.hasNext();
        }

        @Override
        public A next() {
            if (this._position < NodeIteratorIterable.this._buffer.size()) {
                return (AmetysObject)NodeIteratorIterable.this._buffer.get(this._position++);
            }
            Node node = this._it.nextNode();
            ++this._position;
            Object result = null;
            try {
                Object a = result = (Object)NodeIteratorIterable.this._resolver.resolve(NodeIteratorIterable.this._parentPath, node, null, false);
                return a;
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException("An error occured while resolving", e);
            }
            finally {
                NodeIteratorIterable.this._buffer.add(result);
            }
        }

        @Override
        public void remove() {
            this._it.remove();
        }
    }
}

