/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class NodeTypeDefinitionsExtensionPoint
extends AbstractLogEnabled
implements ExtensionPoint<String>,
Component {
    public static final String ROLE = NodeTypeDefinitionsExtensionPoint.class.getName();
    private Map<String, String> _nodetypeDefinitions = new HashMap<String, String>();

    public void addExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException {
        String nodetypeDef = configuration.getChild("nodetype-definition", true).getValue(null);
        if (nodetypeDef != null) {
            if (this._nodetypeDefinitions.containsKey(id)) {
                this.getLogger().error("The nodetype definition of id " + id + " is already defined. It will be ignored");
            } else {
                this._nodetypeDefinitions.put(id, "plugin:" + pluginName + "://" + nodetypeDef);
            }
        }
    }

    public void initializeExtensions() throws Exception {
    }

    public boolean hasExtension(String id) {
        return this._nodetypeDefinitions.containsKey(id);
    }

    public String getExtension(String id) {
        if (this.hasExtension(id)) {
            return this._nodetypeDefinitions.get(id);
        }
        return null;
    }

    public Set<String> getExtensionsIds() {
        return this._nodetypeDefinitions.keySet();
    }

    public Collection<String> getNodeTypeDefinitions() {
        return this._nodetypeDefinitions.values();
    }
}

