/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;

public interface TraversableAmetysObject
extends AmetysObject {
    public <A extends AmetysObject> AmetysObjectIterable<A> getChildren() throws AmetysRepositoryException;

    public boolean hasChild(String var1) throws AmetysRepositoryException;

    public <A extends AmetysObject> A getChild(String var1) throws AmetysRepositoryException, UnknownAmetysObjectException;

    default public <A extends AmetysObject> A getChildAt(long index) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (index < 0L) {
            throw new AmetysRepositoryException("Child index cannot be negative");
        }
        AmetysObjectIterable<A> children = this.getChildren();
        Iterator it = children.iterator();
        try {
            it.skip(index);
            return (A)((AmetysObject)it.next());
        }
        catch (NoSuchElementException e) {
            throw new UnknownAmetysObjectException("There's no child at index " + index + " for object " + this.getId());
        }
    }

    default public long getChildPosition(AmetysObject ao) throws AmetysRepositoryException {
        AmetysObjectIterable children = this.getChildren();
        long count = 0L;
        for (AmetysObject child : children) {
            if (child.getId().equals(ao.getId())) {
                return count;
            }
            ++count;
        }
        return -1L;
    }
}

