/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository;

import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;

public class UniqueChainedAmetysObjectIterable<A extends AmetysObject>
implements AmetysObjectIterable<A> {
    private List<AmetysObjectIterable<A>> _iterables;

    public UniqueChainedAmetysObjectIterable(List<AmetysObjectIterable<A>> iterables) {
        this._iterables = iterables;
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public AmetysObjectIterator<A> iterator() {
        List its = this._iterables.stream().map(it -> it.iterator()).collect(Collectors.toList());
        return new UniqueChainedIterator(this, its);
    }

    @Override
    public void close() {
        for (AmetysObjectIterable<A> it : this._iterables) {
            it.close();
        }
    }

    class UniqueChainedIterator
    implements AmetysObjectIterator<A> {
        private Set<String> _identifiers = new HashSet<String>();
        private A _nextObject;
        private boolean _nextObjectSet;
        private long _position;
        private int _currentIterator;
        private List<AmetysObjectIterator<A>> _its;

        public UniqueChainedIterator(UniqueChainedAmetysObjectIterable this$0, List<AmetysObjectIterator<A>> its) {
            this._its = its;
        }

        @Override
        public long getSize() {
            return -1L;
        }

        @Override
        public long getPosition() {
            return this._position;
        }

        @Override
        public boolean hasNext() {
            if (this._nextObjectSet) {
                return true;
            }
            return this._fetchNextObject();
        }

        @Override
        public A next() {
            if (!this._nextObjectSet && !this._fetchNextObject()) {
                throw new NoSuchElementException();
            }
            this._nextObjectSet = false;
            ++this._position;
            return this._nextObject;
        }

        private boolean _fetchNextObject() {
            while (this._internalHasNext()) {
                Object object = this._internalNext();
                if (!this._identifiers.add(object.getId())) continue;
                this._nextObject = object;
                this._nextObjectSet = true;
                return true;
            }
            return false;
        }

        private boolean _internalHasNext() {
            while (this._currentIterator < this._its.size() && !this._its.get(this._currentIterator).hasNext()) {
                ++this._currentIterator;
            }
            return this._currentIterator < this._its.size() && this._its.get(this._currentIterator).hasNext();
        }

        private A _internalNext() {
            return (AmetysObject)this._its.get(this._currentIterator).next();
        }
    }
}

