/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.activities;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.Event;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityHolder;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public abstract class AbstractActivityType
extends AbstractLogEnabled
implements Configurable,
ActivityType,
Serviceable,
PluginAware {
    private static final int __MAX_MERGE_ACTIVITY_RANGE = 300;
    protected CurrentUserProvider _currentUserProvider;
    protected UserHelper _userHelper;
    protected String _pluginName;
    private Map<String, I18nizableText> _supportedEventTypes;
    private String _id;

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._supportedEventTypes = new HashMap<String, I18nizableText>();
        this._id = configuration.getAttribute("id");
        Configuration[] supportedTypesConf = configuration.getChild("supported-types").getChildren("supported-type");
        if (supportedTypesConf.length == 0) {
            throw new ConfigurationException("Missing 'supported-types' configuration", configuration);
        }
        for (Configuration conf : supportedTypesConf) {
            String id = conf.getAttribute("id");
            I18nizableText label = I18nizableText.parseI18nizableText((Configuration)conf.getChild("label"), (String)("plugin." + this._pluginName), (String)id);
            this._supportedEventTypes.put(id, label);
        }
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._userHelper = (UserHelper)serviceManager.lookup(UserHelper.ROLE);
    }

    public boolean supports(Event element) {
        return true;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public Map<String, I18nizableText> getSupportedEventTypes() {
        return this._supportedEventTypes;
    }

    @Override
    public boolean isMergeable(Activity activity1, Activity activity2) {
        if (activity1 == null || activity2 == null) {
            return false;
        }
        String type1 = activity1.getEventType();
        UserIdentity author1 = activity1.getAuthor();
        ZonedDateTime date1 = activity1.getDate();
        if (type1 == null || author1 == null || date1 == null) {
            this.getLogger().error("Mandatory type, date or author is missing for activity '{}'. Consider it as no mergeable", (Object)activity1.getId());
            return false;
        }
        String type2 = activity2.getEventType();
        UserIdentity author2 = activity2.getAuthor();
        ZonedDateTime date2 = activity2.getDate();
        if (type2 == null || author2 == null || date2 == null) {
            this.getLogger().error("Mandatory type, date or author is missing for activity '{}'. Consider it as no mergeable", (Object)activity2.getId());
            return false;
        }
        return type1.equals(type2) && author1.equals((Object)author2) && Math.abs(ChronoUnit.SECONDS.between(date1, date2)) < 300L;
    }

    @Override
    public Map<String, Object> mergeActivities(List<Activity> activities) {
        Map<String, Object> mergedActivity = activities.get(0).toJSONForClient();
        mergedActivity.put("amount", activities.size());
        if (activities.size() > 1) {
            ZonedDateTime startDate = null;
            ZonedDateTime endDate = null;
            for (Activity activity : activities) {
                ZonedDateTime activityDate = activity.getDate();
                if (startDate == null || activityDate.isBefore(startDate)) {
                    startDate = activityDate;
                }
                if (endDate != null && !activityDate.isAfter(endDate)) continue;
                endDate = activityDate;
            }
            DataContext dataContext = DataContext.newInstance();
            ElementType dateElementType = (ElementType)activities.get(0).getType("date");
            mergedActivity.put("date", dateElementType.valueToJSONForClient((Object)startDate, dataContext));
            if (endDate != null && startDate != null && ChronoUnit.SECONDS.between(startDate, endDate) > 1L) {
                mergedActivity.put("endDate", dateElementType.valueToJSONForClient((Object)endDate, dataContext));
            }
        }
        return mergedActivity;
    }

    @Override
    public void handleEvent(Event event) throws RepositoryException {
        for (ActivityArguments activityArguments : this.getActivitiesArguments(event)) {
            ActivityHolder holder = activityArguments.holder();
            HashMap<String, Object> arguments = new HashMap<String, Object>(event.getArguments());
            arguments.putAll(activityArguments.parameters());
            holder.addActivity(this, arguments, event.getIssuer(), event.getId());
        }
    }

    public abstract List<ActivityArguments> getActivitiesArguments(Event var1);

    public record ActivityArguments(ActivityHolder holder, Map<String, Object> parameters) {
    }
}

