/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.activities;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.activities.ActivityFactory;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.repository.data.ametysobject.ModifiableModelLessDataAwareAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.runtime.model.type.DataContext;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Activity
extends SimpleAmetysObject<ActivityFactory>
implements ModifiableModelLessDataAwareAmetysObject {
    public static final String ACTIVITY_ID_KEY = "id";
    public static final String ACTIVITY_NAME_KEY = "name";

    public Activity(Node node, String parentPath, ActivityFactory factory) {
        super(node, parentPath, factory);
    }

    @Override
    public ModifiableModelLessDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelLessDataHolder(((ActivityFactory)this._getFactory()).getElementTypesExtensionPoint(), repositoryData);
    }

    public ActivityType getActivityType() {
        return ((ActivityFactory)this._getFactory()).getActivityType((String)this.getValue("activityTypeId"));
    }

    public String getEventType() {
        return (String)this.getValueOfType("type", "string");
    }

    public ZonedDateTime getDate() {
        return (ZonedDateTime)this.getValueOfType("date", "datetime");
    }

    public UserIdentity getAuthor() {
        return (UserIdentity)this.getValueOfType("author", "user");
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute(ACTIVITY_ID_KEY, this.getId());
        attrs.addCDATAAttribute(ACTIVITY_NAME_KEY, this.getName());
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"activity", (Attributes)attrs);
        this.dataToSAX(contentHandler);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"activity");
    }

    public Map<String, Object> toJSONForClient() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put(ACTIVITY_ID_KEY, this.getId());
        json.put(ACTIVITY_NAME_KEY, this.getName());
        Object dataContext = RepositoryDataContext.newInstance().withObject(this);
        json.putAll(this.dataToJSON((DataContext)dataContext));
        json.putAll(this.getActivityType().additionnalDataToJSONForClient(this));
        return json;
    }
}

