/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.activities;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.MetadataExpression;

public class ActivityTypeExpression
implements Expression {
    private static final String __METADATA_EXPRESSION = new MetadataExpression("type").build();
    private Expression.Operator _operator;
    private String[] _values;

    public ActivityTypeExpression(Expression.Operator operator, String value) {
        if (Expression.Operator.EQ != operator && Expression.Operator.NE != operator) {
            throw new AmetysRepositoryException("Test operator '' is unknown for test's expression.");
        }
        this._operator = operator;
        this._values = new String[]{value};
    }

    public ActivityTypeExpression(Expression.Operator operator, String ... values) {
        this._operator = operator;
        this._values = values;
    }

    @Override
    public String build() {
        StringBuilder xpath = new StringBuilder();
        if (this._values.length == 1) {
            xpath.append(__METADATA_EXPRESSION).append(' ').append((Object)this._operator).append(" '").append(this._values[0].replaceAll("'", "''")).append("'");
            return xpath.toString();
        }
        xpath.append(Expression.Operator.EQ.equals((Object)this._operator) ? Character.valueOf('(') : "not(");
        for (int i = 0; i < this._values.length; ++i) {
            if (i > 0) {
                xpath.append(Expression.LogicalOperator.OR.toString());
            }
            xpath.append(__METADATA_EXPRESSION).append(" = '").append(this._values[i].replaceAll("'", "''")).append("'");
        }
        xpath.append(')');
        return xpath.toString();
    }
}

