/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.activities;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentSupporterExtensionPoint;
import org.ametys.runtime.plugin.component.LazyInitializeExtensions;

@LazyInitializeExtensions
public class ActivityTypeExtensionPoint
extends AbstractThreadSafeComponentSupporterExtensionPoint<ActivityType, Event> {
    public static final String ROLE = ActivityTypeExtensionPoint.class.getName();

    public List<Map<String, Object>> mergeActivities(List<Activity> initialActivities) {
        ArrayList<Map<String, Object>> mergedActivities = new ArrayList<Map<String, Object>>();
        ArrayList<Activity> activitiesToMerge = new ArrayList<Activity>(initialActivities);
        LinkedHashMap<String, List> mergeableActivities = new LinkedHashMap<String, List>();
        for (Activity activity : initialActivities) {
            String activityId = activity.getId();
            ArrayList<Activity> clonedActivities = new ArrayList<Activity>(activitiesToMerge);
            for (Activity clonedActivity : clonedActivities) {
                String clonedActivityId = clonedActivity.getId();
                if (!activityId.equals(clonedActivityId)) {
                    ActivityType clonedActivityType;
                    ActivityType activityType = activity.getActivityType();
                    if (activityType != (clonedActivityType = activity.getActivityType()) || !activityType.isMergeable(activity, clonedActivity)) continue;
                    mergeableActivities.computeIfAbsent(activityId, str -> new ArrayList()).add(clonedActivity);
                    activitiesToMerge.remove(activity);
                    activitiesToMerge.remove(clonedActivity);
                    continue;
                }
                mergeableActivities.computeIfAbsent(activityId, str -> new ArrayList()).add(activity);
            }
        }
        for (List acts : mergeableActivities.values()) {
            ActivityType eventType = ((Activity)acts.get(0)).getActivityType();
            try {
                mergedActivities.add(eventType.mergeActivities(acts));
            }
            catch (Exception e) {
                this.getLogger().error("An error occurred while trying to merge activities. The original activities are kept", (Throwable)e);
                for (Activity act : acts) {
                    try {
                        mergedActivities.add(act.toJSONForClient());
                    }
                    catch (Exception e2) {
                        this.getLogger().error("An error occured while trying to serialize activity '{}'. The activity will be ignored.", (Object)act.getId(), (Object)e2);
                    }
                }
            }
        }
        return mergedActivities;
    }

    public List<ActivityType> getActivityTypes(String eventId) {
        ArrayList<ActivityType> activities = new ArrayList<ActivityType>();
        for (String extensionId : this.getExtensionsIds()) {
            ActivityType eventType = (ActivityType)this.getExtension(extensionId);
            if (!eventType.getSupportedEventTypes().keySet().contains(eventId)) continue;
            activities.add(eventType);
        }
        return activities;
    }
}

