/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.activities;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.Event;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityHolder;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.repository.activities.DefaultActivityHolderFactory;

public class DefaultActivityHolder
implements ActivityHolder {
    private ModifiableTraversableAmetysObject _rootCollection;
    private DefaultActivityHolderFactory _activityHolderFactory;

    public DefaultActivityHolder(ModifiableTraversableAmetysObject rootCollection, DefaultActivityHolderFactory factory) {
        this._rootCollection = rootCollection;
        this._activityHolderFactory = factory;
    }

    @Override
    public AmetysObjectIterable<Activity> getActivities() throws RepositoryException {
        return this._rootCollection.getChildren();
    }

    @Override
    public Activity addActivity(ActivityType type, Map<String, Object> parameters, String eventId) throws RepositoryException {
        return this.addActivity(ZonedDateTime.now(), type, parameters, this._activityHolderFactory.getCurrentUser(), eventId);
    }

    @Override
    public Activity addActivity(ZonedDateTime date, ActivityType type, Map<String, Object> parameters, UserIdentity author, String eventId) throws RepositoryException {
        String activityName = "ametys-activity_" + date.format(JCR_UTC_FORMAT);
        Activity activity = (Activity)this._rootCollection.createChild(activityName, "ametys:activity");
        activity.setValue("activityTypeId", type.getId(), "string");
        activity.setValue("date", date, "datetime");
        activity.setValue("type", eventId, "string");
        activity.setValue("author", author, "user");
        type.setAdditionalActivityData(activity, parameters);
        this._rootCollection.saveChanges();
        this._notifyObserver(activity);
        return activity;
    }

    private void _notifyObserver(Activity activity) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("activity", activity);
        params.put("activityId", activity.getId());
        Event event = new Event("activity.created", activity.getAuthor(), params);
        this._activityHolderFactory.getObservationManager().notify(event);
    }
}

