/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ChainedAmetysObjectIterable;
import org.ametys.plugins.repository.NodeIteratorIterable;
import org.ametys.plugins.repository.collection.AmetysObjectCollection;
import org.ametys.plugins.repository.jcr.SimpleAmetysObjectFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class AmetysObjectCollectionFactory
extends SimpleAmetysObjectFactory {
    public static final String COLLECTION_NODETYPE = "ametys:collection";
    public static final String COLLECTION_ELEMENT_NODETYPE = "ametys:collectionElement";

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
    }

    @Override
    public String getScheme() {
        return "collection";
    }

    @Override
    public Collection<String> getNodetypes() {
        ArrayList<String> nodetypes = new ArrayList<String>();
        nodetypes.add(COLLECTION_NODETYPE);
        nodetypes.add(COLLECTION_ELEMENT_NODETYPE);
        return Collections.unmodifiableCollection(nodetypes);
    }

    @Override
    public AmetysObjectCollection getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException, RepositoryException {
        String nodeType = node.getPrimaryNodeType().getName();
        if (nodeType.equals(COLLECTION_NODETYPE)) {
            return new AmetysObjectCollection(node, parentPath, this);
        }
        Node contextNode = node;
        while (!COLLECTION_NODETYPE.equals(contextNode.getPrimaryNodeType().getName())) {
            contextNode = contextNode.getParent();
        }
        return new AmetysObjectCollection(contextNode, parentPath, this);
    }

    public AmetysObject getParent(AmetysObjectCollection object) throws AmetysRepositoryException {
        Node node = object.getNode();
        try {
            Node parentNode = node.getParent();
            return this._resolver.resolve(parentNode, false);
        }
        catch (RepositoryException ex) {
            throw new AmetysRepositoryException("An error occured during resolving parent object of object " + object.getName(), ex);
        }
    }

    public <A extends AmetysObject> A getObject(String parentPath, Node node, String subPath) throws AmetysRepositoryException {
        try {
            return this._resolver.resolve(parentPath, node, subPath, false);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("An error occured while resolving Node", e);
        }
    }

    public <A extends AmetysObject> A createChild(String parentPath, Node parentNode, String name, String type) throws AmetysRepositoryException {
        try {
            return this._resolver.createAndResolve(parentPath, parentNode, name, type);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("An error occured while creating Node", e);
        }
    }

    public AmetysObjectIterable getChildren(String parentPath, Node collectionNode) {
        ArrayList iterators = new ArrayList();
        try {
            NodeIterator it = collectionNode.getNodes();
            this._addFirstLevelChildren(parentPath, iterators, it, collectionNode.getSession());
        }
        catch (RepositoryException ex) {
            throw new AmetysRepositoryException("An error occured while iterating inside the collection", ex);
        }
        return new ChainedAmetysObjectIterable(iterators);
    }

    private void _addFirstLevelChildren(String parentPath, List<AmetysObjectIterable> iterators, NodeIterator it, Session session) throws RepositoryException {
        while (it.hasNext()) {
            Node nextChild = it.nextNode();
            if (!nextChild.getPrimaryNodeType().getName().equals(COLLECTION_ELEMENT_NODETYPE)) continue;
            this._addNextLevelChildren(parentPath, iterators, nextChild.getNodes(), session);
        }
    }

    private void _addNextLevelChildren(String parentPath, List<AmetysObjectIterable> iterators, NodeIterator it, Session session) throws RepositoryException {
        if (it.hasNext()) {
            Node firstNode = it.nextNode();
            if (firstNode.getPrimaryNodeType().getName().equals(COLLECTION_ELEMENT_NODETYPE)) {
                NodeIterator firstChildIt = firstNode.getNodes();
                this._addNextLevelChildren(parentPath, iterators, firstChildIt, session);
                while (it.hasNext()) {
                    NodeIterator childIt = it.nextNode().getNodes();
                    this._addNextLevelChildren(parentPath, iterators, childIt, session);
                }
            } else {
                iterators.add(new NodeIteratorIterable(this._resolver, new WrapperNodeIterator(this, firstNode, it), parentPath, session));
            }
        }
    }

    private class WrapperNodeIterator
    implements NodeIterator {
        private Node _firstElement;
        private NodeIterator _it;
        private boolean _firstElementUsed;

        public WrapperNodeIterator(AmetysObjectCollectionFactory ametysObjectCollectionFactory, Node firstElement, NodeIterator it) {
            this._firstElement = firstElement;
            this._it = it;
            this._firstElementUsed = false;
        }

        public Node nextNode() {
            if (!this._firstElementUsed) {
                this._firstElementUsed = true;
                return this._firstElement;
            }
            return this._it.nextNode();
        }

        public long getPosition() {
            if (!this._firstElementUsed) {
                return 0L;
            }
            return this._it.getPosition();
        }

        public long getSize() {
            return this._it.getSize();
        }

        public void skip(long skipNum) {
            if (skipNum < 0L) {
                throw new IllegalArgumentException("skipNum must not be negative");
            }
            if (skipNum == 0L) {
                return;
            }
            if (!this._firstElementUsed) {
                this._firstElementUsed = true;
                if (skipNum > 1L) {
                    this._it.skip(skipNum - 1L);
                }
            } else {
                this._it.skip(skipNum);
            }
        }

        public boolean hasNext() {
            if (!this._firstElementUsed) {
                return true;
            }
            return this._it.hasNext();
        }

        public Object next() {
            return this.nextNode();
        }

        public void remove() {
            throw new UnsupportedOperationException("remove is unsupported");
        }
    }
}

