/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.data.external;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.plugins.repository.data.external.ExternalizableDataProvider;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;

public class ExternalizableDataProviderExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<ExternalizableDataProvider> {
    public static final String ROLE = ExternalizableDataProviderExtensionPoint.class.getName();

    public Set<String> getExternalizableDataPaths(ModelAwareDataHolder dataHolder) {
        HashSet<String> dataPaths = new HashSet<String>();
        for (String id : this.getExtensionsIds()) {
            ExternalizableDataProvider provider = (ExternalizableDataProvider)this.getExtension(id);
            for (String dataPath : provider.getExternalizableDataPaths(dataHolder)) {
                if (dataPaths.contains(dataPath)) {
                    throw new UnsupportedOperationException("The data of path " + dataPath + " is already handled by another externalizable data provider");
                }
                dataPaths.add(dataPath);
            }
        }
        return dataPaths;
    }

    public boolean isDataExternalizable(ModelAwareDataHolder dataHolder, ModelItem modelItem) {
        return this.isDataExternalizable(dataHolder, modelItem, Map.of());
    }

    public boolean isDataExternalizable(ModelAwareDataHolder dataHolder, ModelItem modelItem, Map<String, Object> context) {
        for (String id : this.getExtensionsIds()) {
            ExternalizableDataProvider provider = (ExternalizableDataProvider)this.getExtension(id);
            if (!provider.isDataExternalizable(dataHolder, modelItem, context)) continue;
            return true;
        }
        return false;
    }
}

