/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.data.extractor.xml;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.util.dom.DOMUtils;
import org.ametys.plugins.repository.data.extractor.ModelAwareValuesExtractor;
import org.ametys.plugins.repository.data.extractor.xml.XMLValuesExtractorAdditionalDataGetter;
import org.ametys.plugins.repository.data.holder.impl.DataHolderHelper;
import org.ametys.plugins.repository.model.CompositeDefinition;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.ModelViewItem;
import org.ametys.runtime.model.ModelViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemContainer;
import org.ametys.runtime.model.exception.BadDataPathCardinalityException;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.ametys.runtime.model.type.ElementType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModelAwareXMLValuesExtractor
implements ModelAwareValuesExtractor {
    protected Element _element;
    protected Optional<XMLValuesExtractorAdditionalDataGetter> _additionalDataGetter;
    protected Collection<? extends ModelItemContainer> _modelItemContainers;

    public ModelAwareXMLValuesExtractor(Element element, Model ... models) {
        this(element, Arrays.asList(models));
    }

    public ModelAwareXMLValuesExtractor(Element element, Collection<? extends ModelItemContainer> modelItemContainers) {
        this(element, null, modelItemContainers);
    }

    public ModelAwareXMLValuesExtractor(Element element, XMLValuesExtractorAdditionalDataGetter additionalDataGetter, Model ... models) {
        this(element, additionalDataGetter, Arrays.asList(models));
    }

    public ModelAwareXMLValuesExtractor(Element element, XMLValuesExtractorAdditionalDataGetter additionalDataGetter, Collection<? extends ModelItemContainer> modelItemContainers) {
        this._element = element;
        this._additionalDataGetter = Optional.ofNullable(additionalDataGetter);
        this._modelItemContainers = modelItemContainers;
    }

    @Override
    public Map<String, Object> extractValues() throws Exception {
        View view = new View();
        this._fillViewItemContainerFromXML(this._element, (ViewItemContainer)view, this._modelItemContainers);
        return this.extractValues(view);
    }

    protected void _fillViewItemContainerFromXML(Element element, ViewItemContainer viewItemContainer, ModelItemContainer modelItemContainer) throws Exception {
        this._fillViewItemContainerFromXML(element, viewItemContainer, List.of(modelItemContainer));
    }

    protected void _fillViewItemContainerFromXML(Element element, ViewItemContainer viewItemContainer, Collection<? extends ModelItemContainer> modelItemContainers) throws Exception {
        List children = DOMUtils.getUniqueChildElements((Element)element);
        for (Element child : children) {
            ViewElement modelViewItem;
            Optional<ModelItem> optionalModelItem = this._getModelItemFromNodeName(element, child.getNodeName(), modelItemContainers);
            if (!optionalModelItem.isPresent()) continue;
            ModelItem modelItem = optionalModelItem.get();
            if (modelItem instanceof ModelItemGroup) {
                Element groupNode = child;
                if (modelItem instanceof RepeaterDefinition) {
                    groupNode = DOMUtils.getChildElementByTagName((Element)groupNode, (String)"entry");
                }
                modelViewItem = new ModelViewItemGroup();
                if (groupNode != null) {
                    this._fillViewItemContainerFromXML(groupNode, (ViewItemContainer)((ModelViewItemGroup)modelViewItem), (ModelItemContainer)((ModelItemGroup)modelItem));
                }
            } else {
                modelViewItem = new ViewElement();
            }
            modelViewItem.setDefinition(modelItem);
            if (viewItemContainer.hasModelViewItem((ModelViewItem)modelViewItem)) continue;
            viewItemContainer.addViewItem((ViewItem)modelViewItem);
        }
    }

    protected Optional<ModelItem> _getModelItemFromNodeName(Element parent, String nodeName, Collection<? extends ModelItemContainer> modelItemContainers) {
        if (ModelHelper.hasModelItem((String)nodeName, modelItemContainers)) {
            return Optional.of(ModelHelper.getModelItem((String)nodeName, modelItemContainers));
        }
        return Optional.empty();
    }

    @Override
    public Map<String, Object> extractValues(View view) throws Exception {
        return this._extractValues(this._element, (ViewItemContainer)view, "");
    }

    protected Map<String, Object> _extractValues(Element currentElement, ViewItemContainer viewItemContainer, String prefix) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (ViewItem viewItem : viewItemContainer.getViewItems()) {
            if (viewItem instanceof ModelViewItem) {
                ModelItem modelItem = ((ModelViewItem)viewItem).getDefinition();
                String dataName = modelItem.getName();
                if (!this._hasChildForAttribute(currentElement, dataName)) continue;
                Object value = viewItem instanceof ModelViewItemGroup ? this._extractGroupValues(currentElement, (ModelViewItemGroup)viewItem, dataName, prefix) : this._extractElementValue(currentElement, (ElementDefinition)modelItem, prefix);
                values.put(dataName, value);
                continue;
            }
            if (!(viewItem instanceof ViewItemContainer)) continue;
            values.putAll(this._extractValues(currentElement, (ViewItemContainer)viewItem, prefix));
        }
        return values;
    }

    protected boolean _hasChildForAttribute(Element element, String attributeName) {
        return DOMUtils.hasChildElement((Element)element, (String)attributeName);
    }

    @Override
    public <T> T extractValue(String dataPath) throws Exception {
        if (!ModelHelper.hasModelItem((String)dataPath, this._modelItemContainers)) {
            throw new UndefinedItemPathException("Unable to retrieve the value at path '" + dataPath + "'. There is no such item defined by the model.");
        }
        return this._extractValue(this._modelItemContainers, this._element, dataPath, "");
    }

    protected <T> T _extractValue(ModelItemContainer modelItemContainer, Element currentElement, String relativeDataPath, String prefix) throws Exception {
        return this._extractValue(List.of(modelItemContainer), currentElement, relativeDataPath, prefix);
    }

    protected <T> T _extractValue(Collection<? extends ModelItemContainer> modelItemContainers, Element currentElement, String relativeDataPath, String prefix) throws Exception {
        Object[] pathSegments = StringUtils.split((String)relativeDataPath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("Unable to extract the value of the data at the given path. This path is empty.");
        }
        if (pathSegments.length == 1) {
            String dataName = relativeDataPath;
            ModelItem modelItem = ModelHelper.getModelItem((String)dataName, modelItemContainers);
            if (modelItem instanceof ElementDefinition) {
                return this._extractElementValue(currentElement, (ElementDefinition)modelItem, prefix);
            }
            ModelViewItemGroup modelViewItemGroup = ModelViewItemGroup.of((ModelItemGroup)((ModelItemGroup)modelItem));
            return this._extractGroupValues(currentElement, modelViewItemGroup, dataName, prefix);
        }
        String firstSegmentDataName = pathSegments[0];
        String newRelativeDataPath = StringUtils.join((Object[])pathSegments, (String)"/", (int)1, (int)pathSegments.length);
        String newPrefix = StringUtils.isNotEmpty((CharSequence)prefix) ? prefix + "/" + firstSegmentDataName : firstSegmentDataName;
        ModelItem modelItem = ModelHelper.getModelItem((String)firstSegmentDataName, modelItemContainers);
        if (modelItem instanceof RepeaterDefinition) {
            if (DataHolderHelper.isRepeaterEntryPath(firstSegmentDataName)) {
                Pair<String, Integer> repeaterNameAndEntryPosition = DataHolderHelper.getRepeaterNameAndEntryPosition(firstSegmentDataName);
                Element repeaterEntryElement = (Element)XPathAPI.selectSingleNode((Node)currentElement, (String)((String)repeaterNameAndEntryPosition.getLeft() + "/entry[@name='" + String.valueOf(repeaterNameAndEntryPosition.getRight()) + "']"));
                if (repeaterEntryElement != null) {
                    return this._extractValue((ModelItemContainer)((RepeaterDefinition)modelItem), repeaterEntryElement, newRelativeDataPath, newPrefix);
                }
                return null;
            }
            throw new BadDataPathCardinalityException("Unable to extract the value at path '" + relativeDataPath + "'. The segment '" + (String)pathSegments[0] + "' refers to a repeater but not an entry.");
        }
        if (modelItem instanceof CompositeDefinition) {
            Element compositeElement = DOMUtils.getChildElementByTagName((Element)currentElement, (String)firstSegmentDataName);
            return compositeElement != null ? (T)this._extractValue((ModelItemContainer)((CompositeDefinition)modelItem), compositeElement, newRelativeDataPath, newPrefix) : null;
        }
        throw new BadItemTypeException("Unable to extract the value at path '" + relativeDataPath + "'. The segment '" + (String)pathSegments[0] + "' does not represent a group item.");
    }

    protected <T> T _extractElementValue(Element parent, ElementDefinition definition, String prefix) throws Exception {
        ElementType type = definition.getType();
        String dataName = definition.getName();
        String absoluteDataPath = StringUtils.isNotEmpty((CharSequence)prefix) ? prefix + "/" + dataName : dataName;
        Optional<Object> additionalData = this._additionalDataGetter.flatMap(dataGetter -> dataGetter.getAdditionalData(absoluteDataPath, type));
        Object value = this._extractElementValue(parent, definition, additionalData);
        if (definition.isMultiple() && value != null && !value.getClass().isArray()) {
            return (T)new Object[]{value};
        }
        if (!definition.isMultiple() && value != null && value.getClass().isArray()) {
            return (T)(Array.getLength(value) > 0 ? Array.get(value, 0) : null);
        }
        return (T)value;
    }

    protected <T> Object _extractElementValue(Element parent, ElementDefinition<T> definition, Optional<Object> additionalData) throws Exception {
        ElementType type = definition.getType();
        String dataName = definition.getName();
        return type.valueFromXML(parent, dataName, additionalData);
    }

    protected <T> T _extractGroupValues(Element parent, ModelViewItemGroup modelViewItemGroup, String dataName, String prefix) throws Exception {
        String newPrefix;
        ModelItemGroup modelItemGroup = modelViewItemGroup.getDefinition();
        String string = newPrefix = StringUtils.isNotEmpty((CharSequence)prefix) ? prefix + "/" + dataName : dataName;
        if (modelItemGroup instanceof RepeaterDefinition) {
            if (DataHolderHelper.isRepeaterEntryPath(dataName)) {
                Pair<String, Integer> repeaterNameAndEntryPosition = DataHolderHelper.getRepeaterNameAndEntryPosition(dataName);
                Element repeaterEntryElement = (Element)XPathAPI.selectSingleNode((Node)parent, (String)((String)repeaterNameAndEntryPosition.getLeft() + "/entry[@name='" + String.valueOf(repeaterNameAndEntryPosition.getRight()) + "']"));
                return (T)(repeaterEntryElement != null ? this._extractValues(repeaterEntryElement, (ViewItemContainer)modelViewItemGroup, newPrefix) : null);
            }
            Element repeaterElement = DOMUtils.getChildElementByTagName((Element)parent, (String)dataName);
            if (repeaterElement != null) {
                ArrayList<Map<String, Object>> repeaterValues = new ArrayList<Map<String, Object>>();
                int repeaterSize = Integer.valueOf(XPathAPI.eval((Node)repeaterElement, (String)"count(entry)").str());
                for (int i = 1; i <= repeaterSize; ++i) {
                    Element repeaterEntryElement = (Element)XPathAPI.selectSingleNode((Node)repeaterElement, (String)("entry[@name='" + i + "']"));
                    Map<String, Object> repeaterEntryValues = this._extractValues(repeaterEntryElement, (ViewItemContainer)modelViewItemGroup, newPrefix + "[" + i + "]");
                    repeaterValues.add(repeaterEntryValues);
                }
                return (T)repeaterValues;
            }
            return null;
        }
        Element compositeElement = DOMUtils.getChildElementByTagName((Element)parent, (String)dataName);
        return (T)(compositeElement != null ? this._extractValues(compositeElement, (ViewItemContainer)modelViewItemGroup, newPrefix) : null);
    }
}

