/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.data.extractor.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.util.dom.DOMUtils;
import org.ametys.plugins.repository.data.extractor.ModelLessValuesExtractor;
import org.ametys.plugins.repository.data.extractor.xml.XMLValuesExtractorAdditionalDataGetter;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.model.type.ModelItemType;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.apache.commons.lang3.StringUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModelLessXMLValuesExtractor
implements ModelLessValuesExtractor {
    protected Element _element;
    protected Optional<XMLValuesExtractorAdditionalDataGetter> _additionalDataGetter;
    protected AbstractThreadSafeComponentExtensionPoint<? extends ModelItemType> _dataTypesExtensionPoint;

    public ModelLessXMLValuesExtractor(Element element, AbstractThreadSafeComponentExtensionPoint<? extends ModelItemType> dataTypesExtensionPoint) {
        this(element, null, dataTypesExtensionPoint);
    }

    public ModelLessXMLValuesExtractor(Element element, XMLValuesExtractorAdditionalDataGetter additionalDataGetter, AbstractThreadSafeComponentExtensionPoint<? extends ModelItemType> dataTypesExtensionPoint) {
        this._element = element;
        this._additionalDataGetter = Optional.ofNullable(additionalDataGetter);
        this._dataTypesExtensionPoint = dataTypesExtensionPoint;
    }

    @Override
    public Map<String, Object> extractValues() throws Exception {
        return this._extractValues(this._element, "");
    }

    protected Map<String, Object> _extractValues(Element currentElement, String prefix) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        List children = DOMUtils.getUniqueChildElements((Element)currentElement);
        for (Element child : children) {
            String dataName = child.getNodeName();
            Object value = this._extractValue(currentElement, dataName, prefix);
            if (value == null) continue;
            values.put(dataName, value);
        }
        return values;
    }

    @Override
    public <T> T extractValue(String dataPath) throws Exception {
        return this._extractValue(this._element, dataPath, "");
    }

    protected <T> T _extractValue(Element currentElement, String relativeDataPath, String prefix) throws Exception {
        Object[] pathSegments = StringUtils.split((String)relativeDataPath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("Unable to extract the value of the data at the given path. This path is empty.");
        }
        if (pathSegments.length == 1) {
            String dataName = relativeDataPath;
            String dataTypeId = XPathAPI.eval((Node)currentElement, (String)(dataName + "/@typeId")).str();
            ModelItemType type = (ModelItemType)this._dataTypesExtensionPoint.getExtension(dataTypeId);
            if (type instanceof ElementType) {
                ElementType elementType = (ElementType)type;
                String absoluteDataPath = StringUtils.isNotEmpty((CharSequence)prefix) ? prefix + "/" + dataName : dataName;
                Optional additionalData = this._additionalDataGetter.flatMap(dataGetter -> dataGetter.getAdditionalData(absoluteDataPath, elementType));
                return (T)elementType.valueFromXML(currentElement, dataName, additionalData);
            }
            String newPrefix = StringUtils.isNotEmpty((CharSequence)prefix) ? prefix + "/" + dataName : dataName;
            Element compositeNode = (Element)XPathAPI.selectSingleNode((Node)currentElement, (String)dataName);
            return (T)(compositeNode != null ? this._extractValues(compositeNode, newPrefix) : null);
        }
        String firstSegmentDataName = pathSegments[0];
        String newRelativeDataPath = StringUtils.join((Object[])pathSegments, (String)"/", (int)1, (int)pathSegments.length);
        String newPrefix = StringUtils.isNotEmpty((CharSequence)prefix) ? prefix + "/" + firstSegmentDataName : firstSegmentDataName;
        Element compositeNode = (Element)XPathAPI.selectSingleNode((Node)currentElement, (String)firstSegmentDataName);
        return compositeNode != null ? (T)this._extractValue(compositeNode, newRelativeDataPath, newPrefix) : null;
    }
}

