/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.data.holder;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.ametys.plugins.repository.data.external.ExternalizableDataProvider;
import org.ametys.plugins.repository.data.holder.DataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareComposite;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.impl.DataHolderHelper;
import org.ametys.plugins.repository.data.holder.values.SynchronizationContext;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.model.ViewHelper;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.exception.BadDataPathCardinalityException;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ModelItemType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public interface ModelAwareDataHolder
extends DataHolder {
    public static final String ALTERNATIVE_SUFFIX = "__alt";
    public static final String STATUS_SUFFIX = "__status";

    @Override
    public ModelAwareComposite getComposite(String var1) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException;

    public ModelAwareComposite getLocalComposite(String var1) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException;

    public ModelAwareComposite getExternalComposite(String var1) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException;

    public ModelAwareRepeater getRepeater(String var1) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException;

    public ModelAwareRepeater getLocalRepeater(String var1) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException;

    public ModelAwareRepeater getExternalRepeater(String var1) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException;

    @Override
    public boolean hasValue(String var1) throws IllegalArgumentException, BadDataPathCardinalityException;

    public boolean hasLocalValue(String var1) throws IllegalArgumentException, BadDataPathCardinalityException;

    public boolean hasExternalValue(String var1) throws IllegalArgumentException, BadDataPathCardinalityException;

    @Override
    public boolean hasValueOrEmpty(String var1) throws IllegalArgumentException, BadDataPathCardinalityException;

    public boolean hasLocalValueOrEmpty(String var1) throws IllegalArgumentException, BadDataPathCardinalityException;

    public boolean hasExternalValueOrEmpty(String var1) throws IllegalArgumentException, BadDataPathCardinalityException;

    @Override
    public Collection<String> getDataNames();

    default public <T> T getValue(String dataPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException {
        return this.getValue(dataPath, false);
    }

    public <T> T getValue(String var1, boolean var2) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException;

    public <T> T getValue(String var1, boolean var2, T var3) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException;

    public <T> T getLocalValue(String var1) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException;

    public <T> T getExternalValue(String var1) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException;

    public ExternalizableDataProvider.ExternalizableDataStatus getStatus(String var1) throws IllegalArgumentException, UndefinedItemPathException, BadDataPathCardinalityException;

    default public boolean isMultiple(String path) throws IllegalArgumentException, UndefinedItemPathException {
        ModelItem item = this.getDefinition(path);
        if (item instanceof ElementDefinition) {
            return ((ElementDefinition)item).isMultiple();
        }
        if (item instanceof RepeaterDefinition) {
            return !DataHolderHelper.isRepeaterEntryPath(path);
        }
        return false;
    }

    default public <X extends ModelItemType> X getType(String path) throws IllegalArgumentException, UndefinedItemPathException {
        return (X)this.getDefinition(path).getType();
    }

    public Collection<? extends ModelItemContainer> getModel();

    default public ModelItem getDefinition(String path) throws IllegalArgumentException, UndefinedItemPathException {
        return ModelHelper.getModelItem((String)path, this.getModel());
    }

    default public boolean hasDefinition(String path) throws IllegalArgumentException {
        try {
            this.getDefinition(path);
            return true;
        }
        catch (UndefinedItemPathException e) {
            return false;
        }
    }

    default public void dataToSAX(ContentHandler contentHandler) throws SAXException, BadItemTypeException {
        this.dataToSAX(contentHandler, DataContext.newInstance());
    }

    default public void dataToSAX(ContentHandler contentHandler, DataContext context) throws SAXException, BadItemTypeException {
        ViewItemAccessor viewItemAccessor = ViewHelper.createViewItemAccessor(this.getModel());
        this.dataToSAX(contentHandler, viewItemAccessor, context);
    }

    default public void dataToSAX(ContentHandler contentHandler, ViewItemAccessor viewItemAccessor) throws SAXException, BadItemTypeException {
        this.dataToSAX(contentHandler, viewItemAccessor, DataContext.newInstance());
    }

    public void dataToSAX(ContentHandler var1, ViewItemAccessor var2, DataContext var3) throws SAXException, BadItemTypeException;

    public void dataToSAXForEdition(ContentHandler var1, ViewItemAccessor var2, DataContext var3) throws SAXException, BadItemTypeException;

    default public Map<String, Object> dataToJSON() throws BadItemTypeException {
        return this.dataToJSON(DataContext.newInstance());
    }

    default public Map<String, Object> dataToJSON(DataContext context) throws BadItemTypeException {
        ViewItemAccessor viewItemAccessor = ViewHelper.createViewItemAccessor(this.getModel());
        return this.dataToJSON(viewItemAccessor, context);
    }

    default public Map<String, Object> dataToJSON(ViewItemAccessor viewItemAccessor) throws BadItemTypeException {
        return this.dataToJSON(viewItemAccessor, DataContext.newInstance());
    }

    public Map<String, Object> dataToJSON(ViewItemAccessor var1, DataContext var2) throws BadItemTypeException;

    public Map<String, Object> dataToJSONForEdition(ViewItemAccessor var1, DataContext var2) throws BadItemTypeException;

    default public Map<String, Object> dataToMap() {
        return this.dataToMap(DataContext.newInstance());
    }

    default public Map<String, Object> dataToMap(DataContext context) {
        ViewItemAccessor viewItemAccessor = ViewHelper.createViewItemAccessor(this.getModel());
        return this.dataToMap(viewItemAccessor, context);
    }

    default public Map<String, Object> dataToMap(ViewItemAccessor viewItemAccessor) {
        return this.dataToMap(viewItemAccessor, DataContext.newInstance());
    }

    public Map<String, Object> dataToMap(ViewItemAccessor var1, DataContext var2);

    public boolean hasDifferences(ViewItemAccessor var1, Map<String, Object> var2) throws UndefinedItemPathException, BadItemTypeException;

    public boolean hasDifferences(ViewItemAccessor var1, Map<String, Object> var2, SynchronizationContext var3) throws UndefinedItemPathException, BadItemTypeException;

    public Collection<ModelItem> getDifferences(ViewItemAccessor var1, Map<String, Object> var2) throws UndefinedItemPathException, BadItemTypeException;

    public Collection<ModelItem> getDifferences(ViewItemAccessor var1, Map<String, Object> var2, SynchronizationContext var3) throws UndefinedItemPathException, BadItemTypeException;

    public Optional<? extends ModelAwareDataHolder> getParentDataHolder();

    @Override
    public ModelAwareDataHolder getRootDataHolder();
}

