/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.data.holder.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.UnknownDataException;
import org.ametys.plugins.repository.data.ametysobject.ModelAwareDataAwareAmetysObject;
import org.ametys.plugins.repository.data.ametysobject.ModelLessDataAwareAmetysObject;
import org.ametys.plugins.repository.data.external.ExternalizableDataProvider;
import org.ametys.plugins.repository.data.external.ExternalizableDataProviderExtensionPoint;
import org.ametys.plugins.repository.data.holder.DataHolder;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableDataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.group.Composite;
import org.ametys.plugins.repository.data.holder.group.ModelAwareComposite;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.data.holder.group.ModifiableComposite;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.RepeaterEntry;
import org.ametys.plugins.repository.data.holder.values.SynchronizableRepeater;
import org.ametys.plugins.repository.data.holder.values.SynchronizableValue;
import org.ametys.plugins.repository.data.holder.values.SynchronizationContext;
import org.ametys.plugins.repository.data.holder.values.UntouchedValue;
import org.ametys.plugins.repository.data.holder.values.ValueContext;
import org.ametys.plugins.repository.data.type.RepositoryModelItemType;
import org.ametys.plugins.repository.model.CompositeDefinition;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.plugins.repository.model.ViewHelper;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemAccessor;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.ModelViewItemGroup;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.exception.BadDataPathCardinalityException;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.NotUniqueTypeException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.ametys.runtime.model.exception.UnknownTypeException;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ElementType;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class DataHolderHelper
implements Component,
Serviceable,
Disposable {
    public static final Pattern REPEATER_ENTRY_PATTERN = Pattern.compile("(.*)\\[(\\d+)\\]$");
    private static final Logger __LOGGER = LoggerFactory.getLogger(DataHolderHelper.class);
    private static ExternalizableDataProviderExtensionPoint _externalizableDataProviderEP;
    private static AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        _externalizableDataProviderEP = (ExternalizableDataProviderExtensionPoint)((Object)manager.lookup(ExternalizableDataProviderExtensionPoint.ROLE));
        _resolver = (AmetysObjectResolver)((Object)manager.lookup(AmetysObjectResolver.ROLE));
    }

    public void dispose() {
        _externalizableDataProviderEP = null;
        _resolver = null;
    }

    public static boolean hasRepeaterEntry(ModelAwareDataHolder dataHolder, String repeaterName, int entryPosition) throws BadItemTypeException {
        if (dataHolder.getRepositoryData().hasValue(repeaterName)) {
            ModelAwareRepeater repeater = dataHolder.getRepeater(repeaterName);
            return repeater.hasEntry(entryPosition);
        }
        return false;
    }

    public static boolean hasNonEmptyRepeaterEntry(ModelAwareDataHolder dataHolder, String repeaterName, int entryPosition) throws BadItemTypeException {
        ModelAwareRepeater repeater;
        if (dataHolder.getRepositoryData().hasValue(repeaterName) && (repeater = dataHolder.getRepeater(repeaterName)).hasEntry(entryPosition)) {
            RepeaterEntry entry = repeater.getEntry(entryPosition);
            return !entry.getDataNames().isEmpty();
        }
        return false;
    }

    public static RepeaterEntry getRepeaterEntry(ModelAwareDataHolder dataHolder, String repeaterName, int entryPosition) throws BadItemTypeException {
        ModelAwareRepeater repeater = dataHolder.getRepeater(repeaterName);
        if (repeater == null) {
            return null;
        }
        if (repeater.hasEntry(entryPosition)) {
            return repeater.getEntry(entryPosition);
        }
        return null;
    }

    public static boolean isRepeaterEntryPath(String path) {
        return REPEATER_ENTRY_PATTERN.matcher(path).matches();
    }

    public static Pair<String, Integer> getRepeaterNameAndEntryPosition(String pathSegment) {
        Matcher matcher = REPEATER_ENTRY_PATTERN.matcher(pathSegment);
        if (matcher.matches()) {
            String repeaterName = matcher.group(1);
            String entryPositionAsString = matcher.group(2);
            return new ImmutablePair((Object)repeaterName, (Object)Integer.parseInt(entryPositionAsString));
        }
        return null;
    }

    public static boolean hasValue(ModelAwareDataHolder dataHolder, String dataPath, ValueContext context) throws IllegalArgumentException, BadDataPathCardinalityException {
        if (context.getStatus().isPresent()) {
            ExternalizableDataProvider.ExternalizableDataStatus status = context.getStatus().get();
            if (ExternalizableDataProvider.ExternalizableDataStatus.LOCAL.equals((Object)status)) {
                return dataHolder.hasLocalValue(dataPath);
            }
            return dataHolder.hasExternalValue(dataPath);
        }
        return dataHolder.hasValue(dataPath);
    }

    public static boolean hasValueOrEmpty(ModelAwareDataHolder dataHolder, String dataPath, ValueContext context) throws IllegalArgumentException, BadDataPathCardinalityException {
        if (context.getStatus().isPresent()) {
            ExternalizableDataProvider.ExternalizableDataStatus status = context.getStatus().get();
            if (ExternalizableDataProvider.ExternalizableDataStatus.LOCAL.equals((Object)status)) {
                return dataHolder.hasLocalValueOrEmpty(dataPath);
            }
            return dataHolder.hasExternalValueOrEmpty(dataPath);
        }
        return dataHolder.hasValueOrEmpty(dataPath);
    }

    @Callable(rights={"__READ_ACCESS"}, rightContext="right.assignment.context.ametysobject", paramIndex=0)
    public static <T> T getValue(String ametysObjectId, String dataPath) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException {
        Object ametysObject = _resolver.resolveById(ametysObjectId);
        return DataHolderHelper.getValue(ametysObject, dataPath);
    }

    public static <T> T getValue(AmetysObject ametysObject, String dataPath) {
        if (ametysObject instanceof ModelAwareDataAwareAmetysObject) {
            return ((ModelAwareDataAwareAmetysObject)ametysObject).getValue(dataPath);
        }
        if (ametysObject instanceof ModelLessDataAwareAmetysObject) {
            return ((ModelLessDataAwareAmetysObject)ametysObject).getValue(dataPath);
        }
        String message = String.format("Unable to retrieve the value at path '%s' from the ametys object '%s': this ametys object is not data aware.", dataPath, ametysObject.getId());
        throw new IllegalArgumentException(message);
    }

    public static <T> T getValue(ModelAwareDataHolder dataHolder, String dataPath, ValueContext context) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException {
        if (context.getStatus().isPresent()) {
            ExternalizableDataProvider.ExternalizableDataStatus status = context.getStatus().get();
            if (ExternalizableDataProvider.ExternalizableDataStatus.LOCAL.equals((Object)status)) {
                return dataHolder.getLocalValue(dataPath);
            }
            return dataHolder.getExternalValue(dataPath);
        }
        return dataHolder.getValue(dataPath);
    }

    public static void setValue(ModifiableModelAwareDataHolder dataHolder, String dataPath, Object value, ValueContext context) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException {
        DataHolderHelper.setValue(dataHolder, dataPath, value, context, false);
    }

    public static void setValue(ModifiableModelAwareDataHolder dataHolder, String dataPath, Object value, ValueContext context, boolean forceStatus) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, BadDataPathCardinalityException {
        if (context.getStatus().isPresent()) {
            ExternalizableDataProvider.ExternalizableDataStatus status = context.getStatus().get();
            if (ExternalizableDataProvider.ExternalizableDataStatus.LOCAL.equals((Object)status)) {
                dataHolder.setLocalValue(dataPath, value);
            } else {
                dataHolder.setExternalValue(dataPath, value);
            }
            if (forceStatus) {
                dataHolder.setStatus(dataPath, status);
            }
        } else {
            dataHolder.setValue(dataPath, value);
        }
    }

    public static void removeValue(ModifiableModelAwareDataHolder dataHolder, String dataPath, ValueContext context) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException, UnknownDataException, BadDataPathCardinalityException {
        if (context.getStatus().isPresent()) {
            ExternalizableDataProvider.ExternalizableDataStatus status = context.getStatus().get();
            if (ExternalizableDataProvider.ExternalizableDataStatus.LOCAL.equals((Object)status)) {
                dataHolder.removeLocalValue(dataPath);
            } else {
                dataHolder.removeExternalValue(dataPath);
            }
        } else {
            dataHolder.removeValue(dataPath);
        }
    }

    public static void copyTo(DataHolder source, ModifiableDataHolder destination, DataContext context) {
        for (String name : source.getDataNames()) {
            DataContext newContext = context.cloneContext().addSegmentToDataPath(name);
            DataHolderHelper.copyTo(source, destination, name, newContext);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void copyTo(DataHolder source, ModifiableDataHolder destination, String name, DataContext context) {
        Object object;
        Object object2 = object = source instanceof ModelAwareDataHolder ? ((ModelAwareDataHolder)source).getType(name) : ((ModelLessDataHolder)source).getType(name);
        if ("composite".equals(object.getId())) {
            Composite composite = source.getComposite(name);
            ModifiableComposite compositeDestination = destination.getComposite(name, true);
            composite.copyTo(compositeDestination, context);
            return;
        }
        if (source instanceof ModelAwareDataHolder) {
            ModelAwareDataHolder modelAwareSource = (ModelAwareDataHolder)source;
            if (destination instanceof ModifiableModelAwareDataHolder) {
                RepositoryDataContext repositoryDataContext;
                ModifiableModelAwareDataHolder modelAwareDestination = (ModifiableModelAwareDataHolder)destination;
                if ("repeater".equals(object.getId())) {
                    ModelAwareRepeater repeater = modelAwareSource.getRepeater(name);
                    ModifiableModelAwareRepeater repeaterDestination = modelAwareDestination.getRepeater(name, true);
                    repeater.copyTo(repeaterDestination, context);
                    return;
                }
                ModelItem modelItem = modelAwareDestination.getDefinition(name);
                if (!(modelItem instanceof ElementDefinition)) return;
                ElementDefinition definition = (ElementDefinition)modelItem;
                if (!definition.isEditable()) return;
                if (context instanceof RepositoryDataContext && (repositoryDataContext = (RepositoryDataContext)context).copyExternalMetadata()) {
                    Object localValue = modelAwareSource.getLocalValue(name);
                    modelAwareDestination.setLocalValue(name, localValue);
                    Object externalValue = modelAwareSource.getExternalValue(name);
                    modelAwareDestination.setExternalValue(name, externalValue);
                    ExternalizableDataProvider.ExternalizableDataStatus status = modelAwareSource.getStatus(name);
                    modelAwareDestination.setStatus(name, status);
                    return;
                }
                Object value = modelAwareSource.getValue(name);
                modelAwareDestination.setValue(name, value);
                return;
            }
        }
        if (!(source instanceof ModelLessDataHolder)) return;
        ModelLessDataHolder modelLessSource = (ModelLessDataHolder)source;
        if (!(destination instanceof ModifiableModelLessDataHolder)) return;
        ModifiableModelLessDataHolder modelLessDestination = (ModifiableModelLessDataHolder)destination;
        Object value = modelLessSource.getValue(name);
        modelLessDestination.setValue(name, value);
    }

    public static void dataToSAX(ModelLessDataHolder dataHolder, ContentHandler contentHandler, DataContext context) throws SAXException, UnknownTypeException, NotUniqueTypeException {
        for (String dataName : dataHolder.getDataNames()) {
            DataContext newContext = context.cloneContext().addSegmentToDataPath(dataName);
            DataHolderHelper.dataToSAX(dataHolder, contentHandler, dataName, newContext);
        }
    }

    public static void dataToSAX(ModelLessDataHolder dataHolder, ContentHandler contentHandler, String relativeDataPath, DataContext context) throws SAXException, UnknownTypeException, NotUniqueTypeException {
        String dataName = relativeDataPath;
        if (relativeDataPath.contains("/")) {
            dataName = StringUtils.substringAfterLast((String)relativeDataPath, (String)"/");
        }
        if (dataHolder.hasValue(relativeDataPath) || context.renderEmptyValues() && dataHolder.hasValueOrEmpty(relativeDataPath)) {
            RepositoryModelItemType type = dataHolder.getType(relativeDataPath);
            Object value = dataHolder.getValueOfType(relativeDataPath, type.getId());
            type.valueToSAX(contentHandler, dataName, value, context);
        }
    }

    public static Map<String, Object> dataToJSON(ModelLessDataHolder dataHolder, DataContext context) throws UnknownTypeException, NotUniqueTypeException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String dataName : dataHolder.getDataNames()) {
            if (!context.renderEmptyValues() && !dataHolder.hasValue(dataName)) continue;
            DataContext newContext = context.cloneContext().addSegmentToDataPath(dataName);
            result.put(dataName, DataHolderHelper.dataToJSON(dataHolder, dataName, newContext));
        }
        return result;
    }

    public static Object dataToJSON(ModelLessDataHolder dataHolder, String relativeDataPath, DataContext context) throws UnknownTypeException, NotUniqueTypeException {
        RepositoryModelItemType type = dataHolder.getType(relativeDataPath);
        Object value = dataHolder.getValueOfType(relativeDataPath, type.getId());
        return type.valueToJSONForClient(value, context);
    }

    public static <T> Map<String, T> findEditableItemsByType(ModelAwareDataHolder dataHolder, String type) {
        ViewItemAccessor viewItemAccessor = org.ametys.runtime.model.ViewHelper.createViewItemAccessor(dataHolder.getModel());
        return DataHolderHelper._findItemsByType(dataHolder, viewItemAccessor, type, false, "");
    }

    public static <T> Map<String, T> findItemsByType(ModelAwareDataHolder dataHolder, String type) {
        ViewItemAccessor viewItemAccessor = org.ametys.runtime.model.ViewHelper.createViewItemAccessor(dataHolder.getModel());
        return DataHolderHelper._findItemsByType(dataHolder, viewItemAccessor, type, true, "");
    }

    public static <T> Map<String, T> findItemsByType(ModelAwareDataHolder dataHolder, ViewItemAccessor viewItemAccessor, String type) {
        return DataHolderHelper._findItemsByType(dataHolder, viewItemAccessor, type, true, "");
    }

    private static <T> Map<String, T> _findItemsByType(ModelAwareDataHolder dataHolder, ViewItemAccessor viewItemAccessor, String type, boolean includeNotEditableItems, String prefix) {
        HashMap attributes = new HashMap();
        ViewHelper.visitView(viewItemAccessor, (element, definition) -> {
            if ((includeNotEditableItems || definition.isEditable()) && definition.getType().getId().equals(type)) {
                String name = definition.getName();
                attributes.put(prefix + name, dataHolder.getValue(name));
            }
        }, (group, definition) -> {
            String name = definition.getName();
            ModelAwareComposite composite = dataHolder.getComposite(name);
            if (composite != null) {
                attributes.putAll(DataHolderHelper._findItemsByType(composite, (ViewItemAccessor)group, type, includeNotEditableItems, prefix + name + "/"));
            }
        }, (group, definition) -> {
            String name = definition.getName();
            ModelAwareRepeater repeater = dataHolder.getRepeater(name);
            if (repeater != null) {
                for (ModelAwareRepeaterEntry modelAwareRepeaterEntry : repeater.getEntries()) {
                    attributes.putAll(DataHolderHelper._findItemsByType(modelAwareRepeaterEntry, (ViewItemAccessor)group, type, includeNotEditableItems, prefix + name + "[" + modelAwareRepeaterEntry.getPosition() + "]/"));
                }
            }
        }, group -> attributes.putAll(DataHolderHelper._findItemsByType(dataHolder, (ViewItemAccessor)group, type, includeNotEditableItems, prefix)));
        return attributes;
    }

    public static ExternalizableDataProviderExtensionPoint getExternalizableDataProviderExtensionPoint() {
        return _externalizableDataProviderEP;
    }

    public static ValueContext createValueContextFromSynchronizationContext(ModelAwareDataHolder dataHolder, String dataPath, SynchronizationContext synchronizationContext) {
        ModelItem modelItem = dataHolder.getDefinition(dataPath);
        ValueContext valueContext = ValueContext.newInstance();
        boolean isDataExternalizableInAnyContext = DataHolderHelper.getExternalizableDataProviderExtensionPoint().isDataExternalizable(dataHolder.getRootDataHolder(), modelItem);
        if (isDataExternalizableInAnyContext) {
            boolean isDataExternalizableInCurrentContext = DataHolderHelper.getExternalizableDataProviderExtensionPoint().isDataExternalizable(dataHolder.getRootDataHolder(), modelItem, synchronizationContext.getExternalizableDataContext());
            if (ExternalizableDataProvider.ExternalizableDataStatus.EXTERNAL.equals((Object)synchronizationContext.getStatusToSynchronize()) && isDataExternalizableInCurrentContext) {
                valueContext.withStatus(ExternalizableDataProvider.ExternalizableDataStatus.EXTERNAL);
            } else {
                valueContext.withStatus(ExternalizableDataProvider.ExternalizableDataStatus.LOCAL);
            }
        }
        return valueContext;
    }

    public static Object getValueFromSynchronizableValue(Object value, ModelAwareDataHolder dataHolder, ModelItem modelItem, Optional<String> dataPath, SynchronizationContext context) {
        if (value instanceof SynchronizableValue) {
            SynchronizableValue synchronizableValue = (SynchronizableValue)value;
            Optional<ExternalizableDataProvider.ExternalizableDataStatus> valueStatus = Optional.empty();
            if (!DataHolderHelper.getExternalizableDataProviderExtensionPoint().isDataExternalizable(dataHolder, modelItem, context.getExternalizableDataContext())) {
                valueStatus = Optional.of(ExternalizableDataProvider.ExternalizableDataStatus.LOCAL);
            } else if (synchronizableValue.getExternalizableStatus() != null) {
                valueStatus = Optional.of(synchronizableValue.getExternalizableStatus());
            } else if (dataPath.isPresent()) {
                Object dataName;
                ModelAwareDataHolder parentDataHolder;
                Object[] pathSegments = StringUtils.split((String)dataPath.get(), (String)"/");
                if (pathSegments.length == 1) {
                    parentDataHolder = dataHolder;
                    dataName = pathSegments[0];
                } else {
                    String parentPath = StringUtils.join((Object[])pathSegments, (String)"/", (int)0, (int)(pathSegments.length - 1));
                    parentDataHolder = (ModelAwareDataHolder)dataHolder.getValue(parentPath);
                    dataName = pathSegments[pathSegments.length - 1];
                }
                if (parentDataHolder != null && parentDataHolder.getRepositoryData().hasValue((String)dataName + "__status")) {
                    valueStatus = Optional.of(parentDataHolder.getStatus((String)dataName));
                } else if (context.forceStatusIfNotPresent()) {
                    valueStatus = Optional.of(context.getStatusToSynchronize());
                }
            } else if (context.forceStatusIfNotPresent()) {
                valueStatus = Optional.of(context.getStatusToSynchronize());
            }
            return synchronizableValue.getValue(valueStatus);
        }
        return value;
    }

    public static Object getArrayValuesFromSynchronizableValue(SynchronizableValue synchronizableValue, ValueContext valueContext) {
        Object values = synchronizableValue.getValue(valueContext.getStatus());
        if (values != null && !values.getClass().isArray()) {
            Object singleValue = values;
            values = Array.newInstance(singleValue.getClass(), 1);
            Array.set(values, 0, singleValue);
        }
        return values;
    }

    public static boolean isMultiple(ModelItemAccessor parent, String attributePath) {
        ElementDefinition definition;
        String firstSegment = StringUtils.substringBefore((String)attributePath, (String)"/");
        if (!parent.hasModelItem(firstSegment)) {
            throw new UndefinedItemPathException("The item at path '" + firstSegment + "' is not defined in the model item accessor " + String.valueOf(parent) + ".");
        }
        ModelItem modelItem = parent.getModelItem(firstSegment);
        if (modelItem instanceof ElementDefinition && (definition = (ElementDefinition)modelItem).isMultiple()) {
            return true;
        }
        if (modelItem instanceof RepeaterDefinition) {
            return true;
        }
        if (!Strings.CS.equals(firstSegment, attributePath) && modelItem instanceof ModelItemAccessor) {
            ModelItemAccessor accessor = (ModelItemAccessor)modelItem;
            return DataHolderHelper.isMultiple(accessor, StringUtils.substringAfter((String)attributePath, (String)"/"));
        }
        return false;
    }

    public static Map<String, Object> convertValues(ViewItemAccessor viewItemAccessor, Map<String, Object> values) {
        return DataHolderHelper.convertValues(viewItemAccessor, values, DataHolderHelper::convertValue);
    }

    public static Map<String, Object> convertValues(ViewItemAccessor viewItemAccessor, Map<String, Object> values, BiFunction<ElementDefinition, Object, Object> convertValueFunction) {
        return DataHolderHelper._convertValues(viewItemAccessor, values, convertValueFunction, false, Optional.empty());
    }

    public static Map<String, Object> convertValuesWithSynchronizableValues(ViewItemAccessor viewItemAccessor, Map<String, Object> values, BiFunction<ElementDefinition, Object, Object> convertValueFunction, Optional<SynchronizableValuesStatusInfos> synchronizableValuesStatusInfos) {
        return DataHolderHelper._convertValues(viewItemAccessor, values, convertValueFunction, true, synchronizableValuesStatusInfos);
    }

    private static Map<String, Object> _convertValues(ViewItemAccessor viewItemAccessor, Map<String, Object> values, BiFunction<ElementDefinition, Object, Object> convertValueFunction, boolean withSynchronizableValues, Optional<SynchronizableValuesStatusInfos> synchronizableValuesStatusInfos) {
        if (values == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ViewHelper.visitView(viewItemAccessor, (element, definition) -> {
            String name = definition.getName();
            if (values.containsKey(name)) {
                Object value = values.get(name);
                if (value instanceof SynchronizableValue) {
                    SynchronizableValue syncValue = (SynchronizableValue)value;
                    syncValue.setLocalValue(convertValueFunction.apply((ElementDefinition)definition, syncValue.getLocalValue()));
                    syncValue.setExternalValue(convertValueFunction.apply((ElementDefinition)definition, syncValue.getExternalValue()));
                    result.put(name, syncValue);
                } else {
                    value = convertValueFunction.apply((ElementDefinition)definition, value);
                    if (withSynchronizableValues) {
                        ExternalizableDataProvider.ExternalizableDataStatus status = ExternalizableDataProvider.ExternalizableDataStatus.LOCAL;
                        if (synchronizableValuesStatusInfos.isPresent() && DataHolderHelper.getExternalizableDataProviderExtensionPoint().isDataExternalizable(((SynchronizableValuesStatusInfos)synchronizableValuesStatusInfos.get()).dataHolder(), (ModelItem)definition, ((SynchronizableValuesStatusInfos)synchronizableValuesStatusInfos.get()).externalizableContext)) {
                            status = ExternalizableDataProvider.ExternalizableDataStatus.EXTERNAL;
                        }
                        value = new SynchronizableValue(value, status);
                    }
                    result.put(name, value);
                }
            }
        }, (group, definition) -> {
            String name = definition.getName();
            if (values.containsKey(name)) {
                result.put(name, DataHolderHelper._convertValues((ViewItemAccessor)group, (Map)values.get(name), convertValueFunction, withSynchronizableValues, synchronizableValuesStatusInfos));
            }
        }, (group, definition) -> {
            String name = definition.getName();
            if (values.containsKey(name)) {
                Object value = DataHolderHelper._convertRepeaterValues((ModelViewItemGroup<RepeaterDefinition>)group, values.get(name), convertValueFunction, withSynchronizableValues, synchronizableValuesStatusInfos);
                result.put(name, value);
            }
        }, group -> result.putAll(DataHolderHelper._convertValues((ViewItemAccessor)group, values, convertValueFunction, withSynchronizableValues, synchronizableValuesStatusInfos)));
        return result;
    }

    private static Object _convertRepeaterValues(ModelViewItemGroup<RepeaterDefinition> group, Object value, BiFunction<ElementDefinition, Object, Object> convertValueFunction, boolean withSynchronizableValues, Optional<SynchronizableValuesStatusInfos> synchronizableValuesStatusInfos) {
        SynchronizableRepeater syncRepeater;
        SynchronizableRepeater synchronizableRepeater = syncRepeater = value instanceof SynchronizableRepeater ? (SynchronizableRepeater)value : null;
        List<Map<String, Object>> entries = value == null ? null : (value instanceof List ? (List<Map<String, Object>>)value : ((SynchronizableRepeater)value).getEntries());
        Object newValue = null;
        if (entries != null) {
            ArrayList<Map<String, Object>> newEntries = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < entries.size(); ++i) {
                newEntries.add(DataHolderHelper._convertValues(group, entries.get(i), convertValueFunction, withSynchronizableValues, synchronizableValuesStatusInfos));
            }
            newValue = syncRepeater != null ? SynchronizableRepeater.copy(syncRepeater, newEntries) : (withSynchronizableValues ? SynchronizableRepeater.replaceAll(newEntries, null) : newEntries);
        }
        return newValue;
    }

    public static Object convertValueIgnoringIncompatibleOnes(ElementDefinition definition, Object value) {
        try {
            return DataHolderHelper.convertValue(definition, value);
        }
        catch (BadItemTypeException e) {
            __LOGGER.error("Unable to convert the item '{}', the value '{}' is compatible with the data type ('{}'). This attribute will be ignored", new Object[]{definition.getPath(), value, definition.getType().getId(), e});
            return new UntouchedValue();
        }
    }

    public static Object convertValue(ElementDefinition definition, Object value) throws BadItemTypeException {
        if (value == null) {
            return null;
        }
        if (value instanceof UntouchedValue) {
            return value;
        }
        if (definition.isMultiple()) {
            if (value instanceof Collection) {
                return ((Collection)value).stream().map(v -> definition.getType().castValue(v)).toArray(i -> Array.newInstance(definition.getType().getManagedClass(), i));
            }
            if (value.getClass().isArray()) {
                Stream<Object> valueStream;
                Class<?> valueType = value.getClass().getComponentType();
                if (!valueType.isPrimitive()) {
                    valueStream = Arrays.stream((Object[])value);
                } else if (valueType.equals(Boolean.TYPE)) {
                    valueStream = Arrays.stream(ArrayUtils.toObject((boolean[])((boolean[])value)));
                } else if (valueType.equals(Byte.TYPE)) {
                    valueStream = Arrays.stream(ArrayUtils.toObject((byte[])((byte[])value)));
                } else if (valueType.equals(Character.TYPE)) {
                    valueStream = Arrays.stream(ArrayUtils.toObject((char[])((char[])value)));
                } else if (valueType.equals(Short.TYPE)) {
                    valueStream = Arrays.stream(ArrayUtils.toObject((short[])((short[])value)));
                } else if (valueType.equals(Integer.TYPE)) {
                    valueStream = Arrays.stream(ArrayUtils.toObject((int[])((int[])value)));
                } else if (valueType.equals(Long.TYPE)) {
                    valueStream = Arrays.stream(ArrayUtils.toObject((long[])((long[])value)));
                } else if (valueType.equals(Double.TYPE)) {
                    valueStream = Arrays.stream(ArrayUtils.toObject((double[])((double[])value)));
                } else if (valueType.equals(Float.TYPE)) {
                    valueStream = Arrays.stream(ArrayUtils.toObject((float[])((float[])value)));
                } else {
                    throw new IllegalArgumentException(String.valueOf(value) + " cannot be converted to array");
                }
                return valueStream.map(v -> definition.getType().castValue(v)).toArray(i -> (Object[])Array.newInstance(definition.getType().getManagedClass(), i));
            }
            throw new IllegalArgumentException(String.valueOf(value) + " cannot be converted to array");
        }
        return definition.getType().castValue(value);
    }

    public static ViewItemAccessor createViewItemAccessorFromValues(Collection<? extends ModelItemAccessor> modelItemAccessors, Map<String, Object> values) {
        ViewItemAccessor viewItemAccessor = org.ametys.runtime.model.ViewHelper.createEmptyViewItemAccessor(modelItemAccessors);
        DataHolderHelper._fillViewItemContainerFromValues(modelItemAccessors, viewItemAccessor, values);
        return viewItemAccessor;
    }

    private static void _fillViewItemContainerFromValues(Collection<? extends ModelItemAccessor> modelItemAccessors, ViewItemAccessor viewItemAccessor, Map<String, Object> values) {
        for (String dataName : values.keySet()) {
            ModelViewItemGroup modelViewItemGroup;
            ModelItem modelItem = ModelHelper.getModelItem((String)dataName, modelItemAccessors);
            if (modelItem instanceof RepeaterDefinition) {
                RepeaterDefinition repeaterDefinition = (RepeaterDefinition)modelItem;
                modelViewItemGroup = (ModelViewItemGroup)viewItemAccessor.getModelViewItem(dataName);
                if (modelViewItemGroup == null) {
                    modelViewItemGroup = new ModelViewItemGroup();
                    modelViewItemGroup.setDefinition((ModelItemGroup)repeaterDefinition);
                    viewItemAccessor.addViewItem((ViewItem)modelViewItemGroup);
                }
                List<Map<String, Object>> entries = DataHolderHelper._getRepeaterEntriesFromValues(dataName, values);
                for (Map<String, Object> entry : entries) {
                    DataHolderHelper._fillViewItemContainerFromValues(List.of(repeaterDefinition), (ViewItemAccessor)modelViewItemGroup, entry);
                }
                continue;
            }
            if (modelItem instanceof CompositeDefinition) {
                CompositeDefinition compositeDefinition = (CompositeDefinition)modelItem;
                modelViewItemGroup = (ModelViewItemGroup)viewItemAccessor.getModelViewItem(dataName);
                if (modelViewItemGroup == null) {
                    modelViewItemGroup = new ModelViewItemGroup();
                    modelViewItemGroup.setDefinition((ModelItemGroup)compositeDefinition);
                    viewItemAccessor.addViewItem((ViewItem)modelViewItemGroup);
                }
                Map<String, Object> composite = DataHolderHelper._getCompositeFromValues(dataName, values);
                DataHolderHelper._fillViewItemContainerFromValues(List.of(compositeDefinition), (ViewItemAccessor)modelViewItemGroup, composite);
                continue;
            }
            if (viewItemAccessor.hasModelViewItem(dataName)) continue;
            org.ametys.runtime.model.ViewHelper.addViewItem((String)dataName, (ViewItemAccessor)viewItemAccessor, (ModelItemAccessor[])modelItemAccessors.toArray(new ModelItemAccessor[modelItemAccessors.size()]));
        }
    }

    private static List<Map<String, Object>> _getRepeaterEntriesFromValues(String dataName, Map<String, Object> values) {
        Object value = values.get(dataName);
        if (value == null) {
            return new ArrayList<Map<String, Object>>();
        }
        if (value instanceof SynchronizableRepeater) {
            SynchronizableRepeater synchronizableRepeater = (SynchronizableRepeater)value;
            return synchronizableRepeater.getEntries();
        }
        if (value instanceof List) {
            return (List)value;
        }
        throw new BadItemTypeException("Unable to synchronize the repeater named '" + dataName + "': the given value should be a list containing its entries");
    }

    private static Map<String, Object> _getCompositeFromValues(String dataName, Map<String, Object> values) {
        Object value = values.get(dataName);
        if (value == null) {
            return new HashMap<String, Object>();
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new BadItemTypeException("Unable to synchronize the composite named '" + dataName + "': the given value should be a map containing values of all of its items");
    }

    public static <T> T aggregateMultipleValues(List<? extends ModelAwareDataHolder> dataHolders, String dataPath, Class managedClass) {
        ArrayList<Object> allValuesAsList = new ArrayList<Object>();
        for (ModelAwareDataHolder modelAwareDataHolder : dataHolders) {
            Object value = modelAwareDataHolder.getValue(dataPath, true);
            if (value == null) continue;
            if (value.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    allValuesAsList.add(Array.get(value, i));
                }
                continue;
            }
            allValuesAsList.add(value);
        }
        Object[] array = (Object[])Array.newInstance(managedClass, allValuesAsList.size());
        return (T)allValuesAsList.toArray(array);
    }

    public static Object removeValuesInArray(Object originalValues, Object valuesToRemove, ElementType elementType) {
        ArrayList<Object> valuesAsList = new ArrayList<Object>();
        for (int i = 0; i < Array.getLength(originalValues); ++i) {
            Object originalValue = Array.get(originalValues, i);
            boolean keepOldValue = true;
            for (int j = 0; j < Array.getLength(valuesToRemove); ++j) {
                Object valueToRemove = Array.get(valuesToRemove, j);
                if (elementType.compareValues(valueToRemove, originalValue).count() != 0L) continue;
                keepOldValue = false;
                break;
            }
            if (!keepOldValue) continue;
            valuesAsList.add(originalValue);
        }
        Object[] values = (Object[])Array.newInstance(elementType.getManagedClass(), valuesAsList.size());
        return valuesAsList.toArray(values);
    }

    public static Object appendValuesInArray(Object originalValues, Object valuesToAppend, ElementType elementType) {
        Object[] values = Arrays.copyOf((Object[])originalValues, Array.getLength(originalValues) + Array.getLength(valuesToAppend));
        for (int i = 0; i < Array.getLength(valuesToAppend); ++i) {
            Object valueToAppend;
            values[i + Array.getLength((Object)originalValues)] = valueToAppend = elementType.castValue(Array.get(valuesToAppend, i));
        }
        return values;
    }

    public record SynchronizableValuesStatusInfos(ModelAwareDataHolder dataHolder, Map<String, Object> externalizableContext) {
    }
}

