/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.data.holder.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.plugins.repository.data.UnknownDataException;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelLessComposite;
import org.ametys.plugins.repository.data.holder.group.impl.DefaultModelLessComposite;
import org.ametys.plugins.repository.data.holder.impl.DataHolderHelper;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.data.type.RepositoryElementType;
import org.ametys.plugins.repository.data.type.RepositoryModelItemGroupType;
import org.ametys.plugins.repository.data.type.RepositoryModelItemType;
import org.ametys.runtime.model.exception.BadDataPathCardinalityException;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.NotUniqueTypeException;
import org.ametys.runtime.model.exception.UnknownTypeException;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.model.type.ModelItemType;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DefaultModelLessDataHolder
implements ModelLessDataHolder {
    protected ModelItemTypeExtensionPoint _typeExtensionPoint;
    protected RepositoryData _repositoryData;
    protected Optional<? extends ModelLessDataHolder> _parent;
    protected ModelLessDataHolder _root;

    public DefaultModelLessDataHolder(ModelItemTypeExtensionPoint typeExtensionPoint, RepositoryData repositoryData) {
        this(typeExtensionPoint, repositoryData, Optional.empty(), Optional.empty());
    }

    public DefaultModelLessDataHolder(ModelItemTypeExtensionPoint typeExtensionPoint, RepositoryData repositoryData, Optional<? extends ModelLessDataHolder> parent, Optional<? extends ModelLessDataHolder> root) {
        this._typeExtensionPoint = typeExtensionPoint;
        this._repositoryData = repositoryData;
        this._parent = parent;
        this._root = root.map(ModelLessDataHolder.class::cast).or(() -> this._parent.map(ModelLessDataHolder::getRootDataHolder)).orElse(this);
    }

    @Override
    public ModelLessComposite getComposite(String compositePath) throws IllegalArgumentException, BadItemTypeException, BadDataPathCardinalityException {
        Object value = this.getValueOfType(compositePath, "composite");
        if (value == null) {
            return null;
        }
        if (value instanceof ModelLessComposite) {
            return (ModelLessComposite)value;
        }
        throw new BadItemTypeException("The item at path '" + compositePath + "' is not a composite.");
    }

    @Override
    public <T> T getValue(String dataPath) throws IllegalArgumentException, UnknownTypeException, NotUniqueTypeException, BadItemTypeException, BadDataPathCardinalityException {
        String[] pathSegments = StringUtils.split((String)dataPath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("Unable to retrieve the data at the given path. This path is empty.");
        }
        if (pathSegments.length == 1) {
            try {
                if (this._repositoryData.hasValue(dataPath + "__isEmpty", "ametys-internal")) {
                    return null;
                }
                return this.getValueOfType(dataPath, this.getType(dataPath).getId());
            }
            catch (UnknownDataException e) {
                return null;
            }
        }
        ModelLessDataHolder parent = DefaultModelLessDataHolder._getParentValue(this, dataPath);
        if (parent == null) {
            return null;
        }
        String childName = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        return parent.getValue(childName);
    }

    @Override
    public <T> T getValue(String dataPath, T defaultValue) throws IllegalArgumentException, UnknownTypeException, NotUniqueTypeException, BadItemTypeException, BadDataPathCardinalityException {
        String[] pathSegments = StringUtils.split((String)dataPath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("Unable to retrieve the data at the given path. This path is empty.");
        }
        if (pathSegments.length == 1) {
            try {
                if (this._repositoryData.hasValue(dataPath + "__isEmpty", "ametys-internal")) {
                    return defaultValue;
                }
                return this.getValueOfType(dataPath, this.getType(dataPath).getId(), defaultValue);
            }
            catch (UnknownDataException e) {
                return defaultValue;
            }
        }
        ModelLessDataHolder parent = DefaultModelLessDataHolder._getParentValue(this, dataPath);
        if (parent == null) {
            return defaultValue;
        }
        String childName = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        return parent.getValue(childName, defaultValue);
    }

    @Override
    public <T> T getValueOfType(String dataPath, String dataTypeId, T defaultValue) throws IllegalArgumentException, UnknownTypeException, BadItemTypeException, BadDataPathCardinalityException {
        if (this.hasValue(dataPath, dataTypeId)) {
            return this.getValueOfType(dataPath, dataTypeId);
        }
        return defaultValue;
    }

    @Override
    public <T> T getValueOfType(String dataPath, String dataTypeId) throws IllegalArgumentException, UnknownTypeException, BadItemTypeException, BadDataPathCardinalityException {
        if (!this._typeExtensionPoint.hasExtension(dataTypeId)) {
            String availableTypes = StringUtils.join((Iterable)this._typeExtensionPoint.getExtensionsIds(), (String)", ");
            throw new UnknownTypeException("The type '" + dataTypeId + "' is not available for the extension point '" + String.valueOf((Object)this._typeExtensionPoint) + "'. Available types are: '" + availableTypes + "'.");
        }
        String[] pathSegments = StringUtils.split((String)dataPath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("Unable to retrieve the data at the given path. This path is empty.");
        }
        if (pathSegments.length == 1) {
            RepositoryModelItemType type = (RepositoryModelItemType)this._typeExtensionPoint.getExtension(dataTypeId);
            if (type instanceof RepositoryElementType) {
                return (T)((RepositoryElementType)type).read(this._repositoryData, dataPath);
            }
            return (T)this._getComposite(dataPath);
        }
        ModelLessDataHolder parent = DefaultModelLessDataHolder._getParentValue(this, dataPath);
        if (parent == null) {
            return null;
        }
        String childName = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        return parent.getValueOfType(childName, dataTypeId);
    }

    protected ModelLessComposite _getComposite(String name) throws BadItemTypeException {
        RepositoryModelItemGroupType type = (RepositoryModelItemGroupType)this._typeExtensionPoint.getExtension("composite");
        RepositoryData compositeRepositoryData = type.read(this._repositoryData, name);
        if (compositeRepositoryData != null) {
            return new DefaultModelLessComposite(this._typeExtensionPoint, compositeRepositoryData, this, this._root);
        }
        return null;
    }

    @Override
    public boolean hasValue(String dataPath) throws IllegalArgumentException, BadDataPathCardinalityException {
        String[] pathSegments = StringUtils.split((String)dataPath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("The data path is empty. It is not possible to determine if it has a value or not.");
        }
        if (pathSegments.length == 1) {
            try {
                RepositoryModelItemType type = this.getType(dataPath);
                return this.hasValue(dataPath, type.getId());
            }
            catch (UnknownDataException | NotUniqueTypeException | UnknownTypeException e) {
                return false;
            }
        }
        try {
            ModelLessDataHolder parent = DefaultModelLessDataHolder._getParentValue(this, dataPath);
            if (parent == null) {
                return false;
            }
            String childName = StringUtils.substringAfterLast((String)dataPath, (String)"/");
            return parent.hasValue(childName);
        }
        catch (BadItemTypeException e) {
            return false;
        }
    }

    @Override
    public boolean hasValue(String dataPath, String dataTypeId) throws IllegalArgumentException, UnknownTypeException, BadDataPathCardinalityException {
        if (!this._typeExtensionPoint.hasExtension(dataTypeId)) {
            String availableTypes = StringUtils.join((Iterable)this._typeExtensionPoint.getExtensionsIds(), (String)", ");
            throw new UnknownTypeException("The type '" + dataTypeId + "' is not available for the extension point '" + String.valueOf((Object)this._typeExtensionPoint) + "'. Available types are: '" + availableTypes + "'.");
        }
        String[] pathSegments = StringUtils.split((String)dataPath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("The data path is empty. It is not possible to determine if it has a value or not.");
        }
        if (pathSegments.length == 1) {
            try {
                RepositoryModelItemType type = (RepositoryModelItemType)this._typeExtensionPoint.getExtension(dataTypeId);
                return type.hasNonEmptyValue(this._repositoryData, dataPath);
            }
            catch (BadItemTypeException e) {
                return false;
            }
        }
        try {
            ModelLessDataHolder parent = DefaultModelLessDataHolder._getParentValue(this, dataPath);
            if (parent == null) {
                return false;
            }
            String childName = StringUtils.substringAfterLast((String)dataPath, (String)"/");
            return parent.hasValue(childName, dataTypeId);
        }
        catch (BadItemTypeException e) {
            return false;
        }
    }

    @Override
    public boolean hasValueOrEmpty(String dataPath) throws IllegalArgumentException, BadDataPathCardinalityException {
        String[] pathSegments = StringUtils.split((String)dataPath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("The data path is empty. It is not possible to determine if it has a value or not.");
        }
        if (pathSegments.length == 1) {
            return this._repositoryData.hasValue(dataPath) || this._repositoryData.hasValue(dataPath + "__isEmpty", "ametys-internal");
        }
        try {
            ModelLessDataHolder parent = DefaultModelLessDataHolder._getParentValue(this, dataPath);
            if (parent == null) {
                return false;
            }
            String childName = StringUtils.substringAfterLast((String)dataPath, (String)"/");
            return parent.hasValueOrEmpty(childName);
        }
        catch (BadItemTypeException e) {
            return false;
        }
    }

    @Override
    public boolean isMultiple(String dataPath) throws IllegalArgumentException, UnknownDataException, UnknownTypeException, NotUniqueTypeException, BadItemTypeException, BadDataPathCardinalityException {
        String[] pathSegments = StringUtils.split((String)dataPath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("The data path is empty. It is not possible to determine if it is multiple or not.");
        }
        if (pathSegments.length == 1) {
            return this.isMultiple(dataPath, this.getType(dataPath).getId());
        }
        ModelLessDataHolder parent = DefaultModelLessDataHolder._getParentValue(this, dataPath);
        if (parent == null) {
            throw new UnknownDataException("The data at path '" + dataPath + "' does not exist. It is not possible to determine if it is multiple or not.");
        }
        String childName = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        return parent.isMultiple(childName);
    }

    @Override
    public boolean isMultiple(String dataPath, String dataTypeId) throws IllegalArgumentException, UnknownDataException, UnknownTypeException, BadItemTypeException, BadDataPathCardinalityException {
        if (!this._typeExtensionPoint.hasExtension(dataTypeId)) {
            String availableTypes = StringUtils.join((Iterable)this._typeExtensionPoint.getExtensionsIds(), (String)", ");
            throw new UnknownTypeException("The type '" + dataTypeId + "' is not available for the extension point '" + String.valueOf((Object)this._typeExtensionPoint) + "'. Available types are: '" + availableTypes + "'.");
        }
        String[] pathSegments = StringUtils.split((String)dataPath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("The data path is empty. It is not possible to determine if it is multiple or not.");
        }
        if (pathSegments.length == 1) {
            RepositoryModelItemType type = (RepositoryModelItemType)this._typeExtensionPoint.getExtension(dataTypeId);
            return type.isMultiple(this._repositoryData, dataPath);
        }
        ModelLessDataHolder parent = DefaultModelLessDataHolder._getParentValue(this, dataPath);
        if (parent == null) {
            throw new UnknownDataException("The data at path '" + dataPath + "' does not exist. It is not possible to determine if it is multiple or not.");
        }
        String childName = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        return parent.isMultiple(childName, dataTypeId);
    }

    @Override
    public RepositoryModelItemType getType(String dataPath) throws IllegalArgumentException, UnknownDataException, UnknownTypeException, NotUniqueTypeException, BadDataPathCardinalityException {
        String[] pathSegments = StringUtils.split((String)dataPath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("The data path is empty. It is not possible to determine its type.");
        }
        if (pathSegments.length == 1) {
            return this._getType(dataPath);
        }
        ModelLessDataHolder parent = DefaultModelLessDataHolder._getParentValue(this, dataPath);
        if (parent == null) {
            throw new UnknownDataException("The data at path '" + dataPath + "' does not exist. It is not possible to determine its type.");
        }
        String childName = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        return parent.getType(childName);
    }

    private RepositoryModelItemType _getType(String dataName) throws UnknownDataException, UnknownTypeException, NotUniqueTypeException {
        List compatibleTypes = this._typeExtensionPoint.getExtensionsIds().stream().map(id -> (ModelItemType)this._typeExtensionPoint.getExtension((String)id)).filter(RepositoryModelItemType.class::isInstance).map(RepositoryModelItemType.class::cast).filter(type -> type.isCompatible(this._repositoryData, dataName)).collect(Collectors.toList());
        if (compatibleTypes.isEmpty()) {
            throw new UnknownTypeException("Unable to retrieve the type of the data '" + dataName + "'. No compatible type have been found.");
        }
        if (compatibleTypes.size() > 1) {
            List compatibleTypesIds = compatibleTypes.stream().map(type -> type.getId()).collect(Collectors.toList());
            throw new NotUniqueTypeException("Unable to retrieve the type of the data '" + dataName + "'. Many compatible types have been found, there is no way to determine which one is the good one. Compatible types found are: " + StringUtils.join(compatibleTypesIds, (String)", "));
        }
        return (RepositoryModelItemType)compatibleTypes.get(0);
    }

    protected static ModelLessDataHolder _getParentValue(ModelLessDataHolder dataHolder, String dataPath) throws BadItemTypeException, BadDataPathCardinalityException {
        Object[] pathSegments = StringUtils.split((String)dataPath, (String)"/");
        String parentPath = StringUtils.join((Object[])pathSegments, (String)"/", (int)0, (int)(pathSegments.length - 1));
        return (ModelLessDataHolder)dataHolder.getValueOfType(parentPath, "composite");
    }

    @Override
    public Collection<String> getDataNames() {
        return this._repositoryData.getDataNames();
    }

    @Override
    public void dataToSAX(ContentHandler contentHandler, String dataPath, DataContext context) throws SAXException, UnknownTypeException, NotUniqueTypeException {
        DataHolderHelper.dataToSAX(this, contentHandler, dataPath, context.cloneContext().withDataPath(dataPath));
    }

    @Override
    public void dataToSAX(ContentHandler contentHandler, DataContext context) throws SAXException, UnknownTypeException, NotUniqueTypeException {
        DataHolderHelper.dataToSAX(this, contentHandler, context);
    }

    @Override
    public Object dataToJSON(String dataPath, DataContext context) throws UnknownTypeException, NotUniqueTypeException {
        return DataHolderHelper.dataToJSON(this, dataPath, context);
    }

    @Override
    public Map<String, Object> dataToJSON(DataContext context) throws UnknownTypeException, NotUniqueTypeException {
        return DataHolderHelper.dataToJSON(this, context);
    }

    @Override
    public boolean hasDifferences(Map<String, Object> values) throws UnknownTypeException, NotUniqueTypeException {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Object oldValue;
            ElementType type;
            ModelLessComposite composite;
            String dataName = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Map ? (composite = this.getComposite(dataName)).hasDifferences((Map)value) : (this._repositoryData.hasValue(dataName + "__isEmpty", "ametys-internal") ? value != null : (this.hasValueOrEmpty(dataName) ? (type = (ElementType)this.getType(dataName)).compareValues(value, oldValue = this.getValue(dataName)).count() > 0L : value != null)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public RepositoryData getRepositoryData() {
        return this._repositoryData;
    }

    @Override
    public Optional<? extends ModelLessDataHolder> getParentDataHolder() {
        return this._parent;
    }

    @Override
    public ModelLessDataHolder getRootDataHolder() {
        return this._root;
    }

    @Override
    public ModelItemTypeExtensionPoint getModelItemTypeExtensionPoint() {
        return this._typeExtensionPoint;
    }
}

