/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.data.holder.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.plugins.repository.data.UnknownDataException;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelLessComposite;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelLessComposite;
import org.ametys.plugins.repository.data.holder.group.impl.DefaultModifiableModelLessComposite;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.data.type.RepositoryElementType;
import org.ametys.plugins.repository.data.type.RepositoryModelItemGroupType;
import org.ametys.plugins.repository.data.type.RepositoryModelItemType;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.ametys.runtime.model.exception.BadDataPathCardinalityException;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.NotUniqueTypeException;
import org.ametys.runtime.model.exception.UnknownTypeException;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.model.type.ModelItemType;
import org.apache.commons.lang3.StringUtils;

public class DefaultModifiableModelLessDataHolder
extends DefaultModelLessDataHolder
implements ModifiableModelLessDataHolder {
    protected ModifiableRepositoryData _modifiableRepositoryData;
    protected Optional<LockableAmetysObject> _lockableAmetysObject;
    protected Optional<? extends ModifiableModelLessDataHolder> _modifiableParent;
    protected ModifiableModelLessDataHolder _modifiableRoot;

    public DefaultModifiableModelLessDataHolder(ModelItemTypeExtensionPoint typeExtensionPoint, ModifiableRepositoryData repositoryData) {
        this(typeExtensionPoint, repositoryData, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public DefaultModifiableModelLessDataHolder(ModelItemTypeExtensionPoint typeExtensionPoint, ModifiableRepositoryData repositoryData, Optional<LockableAmetysObject> lockableAmetysObject) {
        this(typeExtensionPoint, repositoryData, lockableAmetysObject, Optional.empty(), Optional.empty());
    }

    public DefaultModifiableModelLessDataHolder(ModelItemTypeExtensionPoint typeExtensionPoint, ModifiableRepositoryData repositoryData, Optional<LockableAmetysObject> lockableAmetysObject, Optional<? extends ModifiableModelLessDataHolder> parent, Optional<? extends ModifiableModelLessDataHolder> root) {
        super(typeExtensionPoint, repositoryData, parent, root);
        this._modifiableRepositoryData = repositoryData;
        this._lockableAmetysObject = lockableAmetysObject;
        this._modifiableParent = parent;
        this._modifiableRoot = root.map(ModifiableModelLessDataHolder.class::cast).or(() -> this._modifiableParent.map(ModifiableModelLessDataHolder::getRootDataHolder)).orElse(this);
    }

    @Override
    public ModifiableModelLessComposite getComposite(String compositePath) throws IllegalArgumentException, BadItemTypeException {
        return (ModifiableModelLessComposite)super.getComposite(compositePath);
    }

    @Override
    protected ModelLessComposite _getComposite(String name) throws BadItemTypeException {
        return this._getComposite(name, false);
    }

    @Override
    public ModifiableModelLessComposite getComposite(String compositePath, boolean createNew) throws IllegalArgumentException, BadItemTypeException {
        if (!this._typeExtensionPoint.hasExtension("composite")) {
            throw new UnknownTypeException("The composites are not available for the extension point '" + String.valueOf((Object)this._typeExtensionPoint) + "'");
        }
        String[] pathSegments = StringUtils.split((String)compositePath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("Unable to retrieve the composite at the given path. This path is empty.");
        }
        if (pathSegments.length == 1) {
            return this._getComposite(compositePath, createNew);
        }
        ModifiableModelLessDataHolder parent = DefaultModifiableModelLessDataHolder._getParentValue(this, compositePath);
        if (parent == null) {
            return null;
        }
        String childName = compositePath.substring(compositePath.lastIndexOf("/") + 1);
        return parent.getComposite(childName, createNew);
    }

    protected ModifiableModelLessComposite _getComposite(String name, boolean createNew) throws BadItemTypeException {
        RepositoryModelItemGroupType type = (RepositoryModelItemGroupType)this._typeExtensionPoint.getExtension("composite");
        RepositoryData compositeRepositoryData = type.read(this._modifiableRepositoryData, name);
        if (compositeRepositoryData != null) {
            return new DefaultModifiableModelLessComposite(this._typeExtensionPoint, (ModifiableRepositoryData)compositeRepositoryData, this._lockableAmetysObject, this, this._modifiableRoot);
        }
        if (createNew) {
            this._lockableAmetysObject.ifPresent(lao -> lao.setLockInfoOnCurrentContext());
            ModifiableRepositoryData createdRepositoryData = type.add(this._modifiableRepositoryData, name);
            return new DefaultModifiableModelLessComposite(this._typeExtensionPoint, createdRepositoryData, this._lockableAmetysObject, this, this._modifiableRoot);
        }
        return null;
    }

    @Override
    public boolean synchronizeValues(Map<String, Object> values) throws UnknownTypeException, NotUniqueTypeException {
        boolean hasChanged = false;
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String dataName = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                ModifiableModelLessComposite composite = this.getComposite(dataName, true);
                hasChanged = composite.synchronizeValues((Map)value) || hasChanged;
                continue;
            }
            if (this._repositoryData.hasValue(dataName + "__isEmpty", "ametys-internal")) {
                if (value == null) continue;
                hasChanged = true;
                this.setValue(dataName, value);
                continue;
            }
            if (this.hasValueOrEmpty(dataName)) {
                Object oldValue;
                ElementType type = (ElementType)this.getType(dataName);
                if (type.compareValues(value, oldValue = this.getValue(dataName)).count() <= 0L) continue;
                hasChanged = true;
                this.setValue(dataName, value);
                continue;
            }
            if (value == null) continue;
            hasChanged = true;
            this.setValue(dataName, value);
        }
        return hasChanged;
    }

    @Override
    public void setValue(String dataPath, Object value) throws IllegalArgumentException, UnknownTypeException, NotUniqueTypeException, UnknownDataException {
        List compatibleTypes = this._typeExtensionPoint.getExtensionsIds().stream().map(id -> (ModelItemType)this._typeExtensionPoint.getExtension((String)id)).filter(RepositoryElementType.class::isInstance).map(RepositoryElementType.class::cast).filter(type -> type.isCompatible(value)).collect(Collectors.toList());
        if (compatibleTypes.isEmpty()) {
            String availableTypes = StringUtils.join((Iterable)this._typeExtensionPoint.getExtensionsIds(), (String)", ");
            throw new UnknownTypeException("Unable to retrieve the type of the data '" + dataPath + "'. No compatible type have been found. Available types are: '" + availableTypes + "'.");
        }
        if (compatibleTypes.size() > 1) {
            List compatibleTypesIds = compatibleTypes.stream().map(type -> type.getId()).collect(Collectors.toList());
            throw new NotUniqueTypeException("Unable to retrieve the type of the data '" + dataPath + "'. Many compatible types have been found, there is no way to determine which one is the good one. Compatible types found are: " + StringUtils.join(compatibleTypesIds, (String)", "));
        }
        this.setValue(dataPath, value, ((RepositoryModelItemType)compatibleTypes.get(0)).getId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(String dataPath, Object value, String dataTypeId) throws IllegalArgumentException, BadItemTypeException, UnknownDataException {
        if (!this._typeExtensionPoint.hasExtension(dataTypeId)) {
            String availableTypes = StringUtils.join((Iterable)this._typeExtensionPoint.getExtensionsIds(), (String)", ");
            throw new UnknownTypeException("The type '" + dataTypeId + "' is not available for the extension point '" + String.valueOf((Object)this._typeExtensionPoint) + "'. Available types are: '" + availableTypes + "'.");
        }
        Object[] pathSegments = StringUtils.split((String)dataPath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("Unable to set a value at the given path. This path is empty.");
        }
        if (pathSegments.length == 1) {
            RepositoryModelItemType type = (RepositoryModelItemType)this._typeExtensionPoint.getExtension(dataTypeId);
            if (!(type instanceof RepositoryElementType)) throw new BadItemTypeException("Unable to set the value '" + String.valueOf(value) + "' on the data at path '" + dataPath + "' in the repository because it is a group item.");
            this._lockableAmetysObject.ifPresent(lao -> lao.setLockInfoOnCurrentContext());
            ((RepositoryElementType)type).write(this._modifiableRepositoryData, dataPath, value);
            return;
        } else {
            ModifiableModelLessDataHolder parent = DefaultModifiableModelLessDataHolder._getParentValue(this, dataPath);
            if (parent == null) {
                String parentPath = StringUtils.join((Object[])pathSegments, (String)"/", (int)0, (int)(pathSegments.length - 1));
                throw new UnknownDataException("The data at path '" + parentPath + "' does not exist. It is not possible to get the data at path '" + dataPath + "'.");
            }
            String childName = dataPath.substring(dataPath.lastIndexOf("/") + 1);
            parent.setValue(childName, value, dataTypeId);
        }
    }

    @Override
    public void removeValue(String dataPath) throws IllegalArgumentException, BadItemTypeException {
        String[] pathSegments = StringUtils.split((String)dataPath, (String)"/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("Unable to remove the value at the given path. This path is empty.");
        }
        if (pathSegments.length == 1) {
            if (this._modifiableRepositoryData.hasValue(dataPath)) {
                this._lockableAmetysObject.ifPresent(lao -> lao.setLockInfoOnCurrentContext());
                this._modifiableRepositoryData.removeValue(dataPath);
            }
            if (this._modifiableRepositoryData.hasValue(dataPath + "__isEmpty", "ametys-internal")) {
                this._lockableAmetysObject.ifPresent(lao -> lao.setLockInfoOnCurrentContext());
                this._modifiableRepositoryData.removeValue(dataPath + "__isEmpty", "ametys-internal");
            }
        } else {
            ModifiableModelLessDataHolder parent = DefaultModifiableModelLessDataHolder._getParentValue(this, dataPath);
            if (parent != null) {
                String childName = dataPath.substring(dataPath.lastIndexOf("/") + 1);
                parent.removeValue(childName);
            }
        }
    }

    protected static ModifiableModelLessDataHolder _getParentValue(ModifiableModelLessDataHolder modifiableDataHolder, String dataPath) throws BadDataPathCardinalityException, BadItemTypeException {
        return (ModifiableModelLessDataHolder)DefaultModelLessDataHolder._getParentValue(modifiableDataHolder, dataPath);
    }

    @Override
    public ModifiableRepositoryData getRepositoryData() {
        return this._modifiableRepositoryData;
    }

    @Override
    public Optional<? extends ModifiableModelLessDataHolder> getParentDataHolder() {
        return this._modifiableParent;
    }

    @Override
    public ModifiableModelLessDataHolder getRootDataHolder() {
        return this._modifiableRoot;
    }
}

