/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.data.holder.values;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class SynchronizableRepeater {
    private List<Map<String, Object>> _entries;
    private Map<Integer, Integer> _positionsMapping;
    private List<Integer> _replacePositions;
    private Set<Integer> _removedEntries;
    private Mode _mode;

    private SynchronizableRepeater(List<Map<String, Object>> entries, Mode mode) {
        this._entries = entries;
        this._mode = mode;
    }

    private SynchronizableRepeater(List<Map<String, Object>> entries, Map<Integer, Integer> positionsMapping, List<Integer> replacePositions, Set<Integer> removedEntries, Mode mode) {
        this._entries = entries;
        this._positionsMapping = positionsMapping;
        this._replacePositions = replacePositions;
        this._removedEntries = removedEntries;
        this._mode = mode;
    }

    public static SynchronizableRepeater replaceAll(List<Map<String, Object>> entries, Map<Integer, Integer> positionsMapping) {
        SynchronizableRepeater repeater = new SynchronizableRepeater(entries, Mode.REPLACE_ALL);
        repeater._positionsMapping = positionsMapping != null ? positionsMapping : IntStream.rangeClosed(1, entries.size()).boxed().collect(Collectors.toMap(Function.identity(), Function.identity()));
        return repeater;
    }

    public static SynchronizableRepeater replace(List<Map<String, Object>> entries, List<Integer> positions) {
        assert (positions == null || positions.size() == entries.size());
        SynchronizableRepeater repeater = new SynchronizableRepeater(entries, Mode.REPLACE);
        repeater._replacePositions = positions != null ? positions : IntStream.rangeClosed(1, entries.size()).boxed().collect(Collectors.toList());
        return repeater;
    }

    public static SynchronizableRepeater appendOrRemove(List<Map<String, Object>> newEntries, Set<Integer> removedEntries) {
        SynchronizableRepeater repeater = new SynchronizableRepeater(newEntries, Mode.APPEND);
        repeater._removedEntries = removedEntries;
        return repeater;
    }

    public static SynchronizableRepeater copy(SynchronizableRepeater repeater, List<Map<String, Object>> newEntries) {
        return new SynchronizableRepeater(newEntries != null ? newEntries : repeater.getEntries(), repeater.getPositionsMapping(), repeater.getReplacePositions(), repeater.getRemovedEntries(), repeater.getMode());
    }

    public Map<Integer, Integer> getPositionsMapping() {
        return this._positionsMapping;
    }

    public List<Integer> getReplacePositions() {
        return this._replacePositions;
    }

    public List<Map<String, Object>> getEntries() {
        return this._entries;
    }

    public Set<Integer> getRemovedEntries() {
        return this._removedEntries;
    }

    public Optional<Integer> getPreviousPosition(int newPosition) {
        Map<Integer, Integer> mapping = this.getPositionsMapping();
        if (mapping != null) {
            for (Map.Entry<Integer, Integer> mappingEntry : mapping.entrySet()) {
                if (!mappingEntry.getValue().equals(newPosition)) continue;
                return Optional.of(mappingEntry.getKey());
            }
        }
        return Optional.empty();
    }

    public Mode getMode() {
        return this._mode;
    }

    public static enum Mode {
        REPLACE_ALL,
        REPLACE,
        APPEND;

    }
}

