/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.data.holder.values;

import java.util.Optional;
import org.ametys.plugins.repository.data.external.ExternalizableDataProvider;
import org.ametys.plugins.repository.data.holder.values.UntouchedValue;

public class SynchronizableValue {
    private Object _localValue;
    private Object _externalValue;
    private ExternalizableDataProvider.ExternalizableDataStatus _externalizableDataStatus;
    private Mode _mode = Mode.REPLACE;

    public SynchronizableValue(Object localValue) {
        this(localValue, ExternalizableDataProvider.ExternalizableDataStatus.LOCAL);
    }

    public SynchronizableValue(Object value, ExternalizableDataProvider.ExternalizableDataStatus valueStatus) {
        if (ExternalizableDataProvider.ExternalizableDataStatus.EXTERNAL.equals((Object)valueStatus)) {
            this._externalValue = value;
            this._localValue = new UntouchedValue();
        } else {
            this._localValue = value;
            this._externalValue = new UntouchedValue();
        }
    }

    public Object getLocalValue() {
        return this._localValue;
    }

    public void setLocalValue(Object localValue) {
        this._localValue = localValue;
    }

    public Object getExternalValue() {
        return this._externalValue;
    }

    public void setExternalValue(Object externalValue) {
        this._externalValue = externalValue;
    }

    public Object getValue(Optional<ExternalizableDataProvider.ExternalizableDataStatus> status) {
        if (status.isPresent() && ExternalizableDataProvider.ExternalizableDataStatus.EXTERNAL.equals((Object)status.get())) {
            return this.getExternalValue();
        }
        return this.getLocalValue();
    }

    public ExternalizableDataProvider.ExternalizableDataStatus getExternalizableStatus() {
        return this._externalizableDataStatus;
    }

    public void setExternalizableStatus(ExternalizableDataProvider.ExternalizableDataStatus externalizableDataStatus) {
        this._externalizableDataStatus = externalizableDataStatus;
    }

    public Mode getMode() {
        return this._mode;
    }

    public void setMode(Mode mode) {
        this._mode = mode;
    }

    public static enum Mode {
        REPLACE,
        APPEND,
        REMOVE;

    }
}

