/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.data.repositorydata.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.UnknownDataException;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.jcr.NodeHelper;
import org.ametys.plugins.repository.jcr.NodeTypeHelper;
import org.apache.commons.lang3.StringUtils;

public class JCRRepositoryData
implements ModifiableRepositoryData {
    private static final Map<Integer, String> __DATA_TYPES = new LinkedHashMap<Integer, String>(6);
    private Node _node;
    private String _defaultPrefix;

    public JCRRepositoryData(Node node) {
        this(node, "ametys");
    }

    public JCRRepositoryData(Node node, String defaultPrefix) {
        this._node = node;
        this._defaultPrefix = defaultPrefix;
    }

    @Override
    public String getString(String name, String prefix) {
        try {
            Value value = this._getValue(name, prefix);
            return value.getString();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the value of string data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public String[] getStrings(String name, String prefix) {
        try {
            Value[] values = this._getValues(name, prefix);
            String[] results = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                results[i] = value.getString();
            }
            return results;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the values of multiple string data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public Calendar getDate(String name, String prefix) {
        try {
            Value value = this._getValue(name, prefix);
            return value.getDate();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the value of date data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public Calendar[] getDates(String name, String prefix) {
        try {
            Value[] values = this._getValues(name, prefix);
            Calendar[] results = new Calendar[values.length];
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                results[i] = value.getDate();
            }
            return results;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the values of multiple date data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public Long getLong(String name, String prefix) {
        try {
            Value value = this._getValue(name, prefix);
            return value.getLong();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the value on long data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public Long[] getLongs(String name, String prefix) {
        try {
            Value[] values = this._getValues(name, prefix);
            Long[] results = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                results[i] = value.getLong();
            }
            return results;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the values of multiple long data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public Double getDouble(String name, String prefix) {
        try {
            Value value = this._getValue(name, prefix);
            return value.getDouble();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the value of double data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public Double[] getDoubles(String name, String prefix) {
        try {
            Value[] values = this._getValues(name, prefix);
            Double[] results = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                results[i] = value.getDouble();
            }
            return results;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the values of multiple double data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public Boolean getBoolean(String name, String prefix) {
        try {
            Value value = this._getValue(name, prefix);
            return value.getBoolean();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the value of boolean data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public Boolean[] getBooleans(String name, String prefix) {
        try {
            Value[] values = this._getValues(name, prefix);
            Boolean[] results = new Boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                results[i] = value.getBoolean();
            }
            return results;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the values of multiple boolean data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public InputStream[] getStreams(String name, String prefix) {
        try {
            Value[] values = this._getValues(name, prefix);
            InputStream[] results = new InputStream[values.length];
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                results[i] = value.getBinary().getStream();
            }
            return results;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the values of multiple stream data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public InputStream getStream(String name, String prefix) {
        try {
            Value value = this._getValue(name, prefix);
            return value.getBinary().getStream();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the value of stream data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public Long getStreamLength(String name, String prefix) {
        try {
            return this._node.getProperty(this._getFullName(name, prefix)).getLength();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the length of the value of stream data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    private Value _getValue(String name, String prefix) {
        try {
            Property property = this._node.getProperty(this._getFullName(name, prefix));
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                if (values.length > 0) {
                    return values[0];
                }
                throw new AmetysRepositoryException("Cannot get the value of data '" + this._getFullName(name, prefix) + "' from an empty array in repository data at path '" + String.valueOf(this) + "'.");
            }
            return property.getValue();
        }
        catch (PathNotFoundException e) {
            throw new UnknownDataException("Unknown data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the value of data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    private Value[] _getValues(String name, String prefix) {
        try {
            Property property = this._node.getProperty(this._getFullName(name, prefix));
            if (property.getDefinition().isMultiple()) {
                return property.getValues();
            }
            Value value = property.getValue();
            return new Value[]{value};
        }
        catch (PathNotFoundException e) {
            throw new UnknownDataException("Unknown data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the multiple value of data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public ModifiableRepositoryData getRepositoryData(String name, String prefix) {
        try {
            if (this._node.hasNode(this._getFullName(name, prefix))) {
                Node node = this._node.getNode(this._getFullName(name, prefix));
                return new JCRRepositoryData(node);
            }
            throw new UnknownDataException("Unknown repository data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the repository data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public RepositoryData[] getAllRepositoryData(String name, String prefix) {
        try {
            if (this._node.hasNode(this._getFullName(name, prefix))) {
                ArrayList<JCRRepositoryData> results = new ArrayList<JCRRepositoryData>();
                NodeIterator nodeIterator = this._node.getNodes(this._getFullName(name, prefix));
                while (nodeIterator.hasNext()) {
                    results.add(new JCRRepositoryData((Node)nodeIterator.next()));
                }
                return results.toArray(new RepositoryData[results.size()]);
            }
            throw new UnknownDataException("Unknown repository data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the repository data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public Set<String> getDataNames(String prefix) throws AmetysRepositoryException {
        Object finalPrefix = prefix == null ? "*:" : (StringUtils.isEmpty((CharSequence)prefix) ? prefix : prefix + ":");
        try {
            PropertyIterator propertiesIterator = this._node.getProperties((String)finalPrefix + "*");
            NodeIterator itNode = this._node.getNodes((String)finalPrefix + "*");
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            while (propertiesIterator.hasNext()) {
                Property property = propertiesIterator.nextProperty();
                String propertyName = property.getName();
                if (StringUtils.isEmpty((CharSequence)finalPrefix) && propertyName.contains(":")) continue;
                names.add(propertyName.substring(((String)finalPrefix).length()));
            }
            while (itNode.hasNext()) {
                Node node = itNode.nextNode();
                if (NodeTypeHelper.isNodeType(node, "ametys:object") && !NodeTypeHelper.isNodeType(node, "ametys:user")) continue;
                names.add(node.getName().substring(((String)finalPrefix).length()));
            }
            return names;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the data names of the repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public String getName() {
        try {
            return this.getName(this._node);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the name of the repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    protected String getName(Node node) throws RepositoryException {
        String fullName = node.getName();
        int prefixLength = fullName.indexOf(":") + 1;
        return prefixLength > 0 ? fullName.substring(prefixLength) : fullName;
    }

    @Override
    public boolean hasValue(String name, String prefix) {
        try {
            return this._node.hasProperty(this._getFullName(name, prefix)) || this._node.hasNode(this._getFullName(name, prefix));
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to determine if there is a value for data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public String getType(String name, String prefix) throws UnknownDataException {
        try {
            String dataName = this._getFullName(name, prefix);
            if (this._node.hasProperty(dataName)) {
                Property property = this._node.getProperty(dataName);
                int jcrType = property.getType();
                String dataType = __DATA_TYPES.get(jcrType);
                if (dataType == null) {
                    throw new AmetysRepositoryException("Unable to get the type of data '" + dataName + "' in repository data at path '" + String.valueOf(this) + "'.");
                }
                return dataType;
            }
            if (this._node.hasNode(dataName)) {
                return NodeTypeHelper.getNodeTypeName(this._node.getNode(dataName));
            }
            throw new UnknownDataException("No data found for '" + dataName + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the type of data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public boolean isMultiple(String name, String prefix) throws UnknownDataException {
        try {
            String dataName = this._getFullName(name, prefix);
            if (this._node.hasProperty(dataName)) {
                Property property = this._node.getProperty(dataName);
                return property.getDefinition().isMultiple();
            }
            if (this._node.hasNode(dataName)) {
                String nodeTypeName = NodeTypeHelper.getNodeTypeName(this._node.getNode(dataName));
                return "ametys:multipleItem".equals(nodeTypeName);
            }
            throw new UnknownDataException("No data found for '" + dataName + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to determine if data '" + this._getFullName(name, prefix) + "' is multiple in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public void rename(String newName, String prefix) {
        NodeHelper.rename(this._node, prefix + ":" + newName);
    }

    @Override
    public void setValue(String name, String value, String prefix) {
        if (value == null) {
            throw new NullPointerException("Unable to set a 'null' data for '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        this._checkDataName(name, prefix);
        try {
            this._node.setProperty(this._getFullName(name, prefix), value);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set the value '" + value + "' for data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public void setValues(String name, String[] values, String prefix) {
        if (values == null) {
            throw new NullPointerException("Unable to set a 'null' data for '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        this._checkDataName(name, prefix);
        try {
            this._node.setProperty(this._getFullName(name, prefix), values);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set the values '" + String.valueOf(values) + "' for data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public void setValue(String name, Calendar value, String prefix) {
        if (value == null) {
            throw new NullPointerException("Unable to set a 'null' data for '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        this._checkDataName(name, prefix);
        try {
            this._node.setProperty(this._getFullName(name, prefix), value);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set the value '" + String.valueOf(value) + "' for data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public void setValues(String name, Calendar[] values, String prefix) {
        if (values == null) {
            throw new NullPointerException("Unable to set a 'null' data for '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        this._checkDataName(name, prefix);
        try {
            Value[] jcrValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                Calendar value = values[i];
                jcrValues[i] = this._node.getSession().getValueFactory().createValue(value);
            }
            this._node.setProperty(this._getFullName(name, prefix), jcrValues, 5);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set the values '" + String.valueOf(values) + "' for data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public void setValue(String name, Long value, String prefix) {
        if (value == null) {
            throw new NullPointerException("Unable to set a 'null' data for '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        this._checkDataName(name, prefix);
        try {
            this._node.setProperty(this._getFullName(name, prefix), value.longValue());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set the value '" + value + "' for data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public void setValues(String name, Long[] values, String prefix) {
        if (values == null) {
            throw new NullPointerException("Unable to set a 'null' data for '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        this._checkDataName(name, prefix);
        try {
            Value[] jcrValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                long value = values[i];
                jcrValues[i] = this._node.getSession().getValueFactory().createValue(value);
            }
            this._node.setProperty(this._getFullName(name, prefix), jcrValues, 3);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set the values '" + String.valueOf(values) + "' for data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public void setValue(String name, Double value, String prefix) {
        if (value == null) {
            throw new NullPointerException("Unable to set a 'null' data for '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        this._checkDataName(name, prefix);
        try {
            this._node.setProperty(this._getFullName(name, prefix), value.doubleValue());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set the value '" + value + "' for data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public void setValues(String name, Double[] values, String prefix) {
        if (values == null) {
            throw new NullPointerException("Unable to set a 'null' data for '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        this._checkDataName(name, prefix);
        try {
            Value[] jcrValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                double value = values[i];
                jcrValues[i] = this._node.getSession().getValueFactory().createValue(value);
            }
            this._node.setProperty(this._getFullName(name, prefix), jcrValues, 4);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set the values '" + String.valueOf(values) + "' for data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public void setValue(String name, Boolean value, String prefix) {
        if (value == null) {
            throw new NullPointerException("Unable to set a 'null' data for '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        this._checkDataName(name, prefix);
        try {
            this._node.setProperty(this._getFullName(name, prefix), value.booleanValue());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set the value '" + value + "' for data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public void setValues(String name, Boolean[] values, String prefix) {
        if (values == null) {
            throw new NullPointerException("Unable to set a 'null' data for '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        this._checkDataName(name, prefix);
        try {
            Value[] jcrValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                boolean value = values[i];
                jcrValues[i] = this._node.getSession().getValueFactory().createValue(value);
            }
            this._node.setProperty(this._getFullName(name, prefix), jcrValues, 6);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set the values '" + String.valueOf(values) + "' for data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public void setValue(String name, InputStream value, String prefix) {
        if (value == null) {
            throw new NullPointerException("Unable to set a 'null' data for '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        this._checkDataName(name, prefix);
        try {
            Binary binary = this._node.getSession().getValueFactory().createBinary(value);
            this._node.setProperty(this._getFullName(name, prefix), binary);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set the value '" + String.valueOf(value) + "' for data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public void setValues(String name, InputStream[] values, String prefix) {
        if (values == null) {
            throw new NullPointerException("Unable to set a 'null' data for '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.");
        }
        this._checkDataName(name, prefix);
        try {
            Value[] jcrValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                InputStream value = values[i];
                Binary binary = this._node.getSession().getValueFactory().createBinary(value);
                jcrValues[i] = this._node.getSession().getValueFactory().createValue(binary);
            }
            this._node.setProperty(this._getFullName(name, prefix), jcrValues, 2);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set the values '" + String.valueOf(values) + "' for data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public ModifiableRepositoryData addRepositoryData(String name, String dataTypeName, String prefix) {
        try {
            Node node = this._node.addNode(this._getFullName(name, prefix), dataTypeName);
            return new JCRRepositoryData(node);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to create repository data '" + this._getFullName(name, prefix) + "' with type '" + dataTypeName + "' in repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    private void _checkDataName(String name, String prefix) {
        if (name == null) {
            throw new AmetysRepositoryException("Unable to set a value with the invalid data name (null) in repository data at path '" + String.valueOf(this) + "'.");
        }
        if (!DATA_NAME_PATTERN.matcher(name).matches()) {
            throw new AmetysRepositoryException("Unable to set a value with the invalid data name '" + name + "'. Only [a-zA-Z][a-zA-Z0-9-_]* are allowed.");
        }
        if (this.hasValue(name, prefix)) {
            this.removeValue(name, prefix);
        }
    }

    @Override
    public void removeValue(String name, String prefix) throws UnknownDataException {
        block5: {
            try {
                String dataName = this._getFullName(name, prefix);
                if (this._node.hasProperty(dataName)) {
                    this._node.getProperty(dataName).remove();
                    break block5;
                }
                if (this._node.hasNode(dataName)) {
                    NodeIterator it = this._node.getNodes(dataName);
                    while (it.hasNext()) {
                        Node next = it.nextNode();
                        next.remove();
                    }
                    break block5;
                }
                throw new UnknownDataException("No data found for '" + dataName + "' in repository data at path '" + String.valueOf(this) + "'.");
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException("Unable to remove data '" + this._getFullName(name, prefix) + "' in repository data at path '" + String.valueOf(this) + "'.", e);
            }
        }
    }

    private String _getFullName(String name, String prefix) {
        return StringUtils.isEmpty((CharSequence)prefix) ? name : prefix + ":" + name;
    }

    public Node getNode() {
        return this._node;
    }

    public Session getSession() throws AmetysRepositoryException {
        try {
            return this._node.getSession();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("unable to retrieve the session of the repository data at path '" + String.valueOf(this) + "'.", e);
        }
    }

    @Override
    public String getDefaultPrefix() {
        return this._defaultPrefix;
    }

    public String toString() {
        try {
            return this._node.getPath() + " (" + this._node.getIdentifier() + ")";
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get infos about the repository data of node '" + String.valueOf(this._node) + "'.", e);
        }
    }

    static {
        __DATA_TYPES.put(1, "string");
        __DATA_TYPES.put(3, "long");
        __DATA_TYPES.put(4, "double");
        __DATA_TYPES.put(6, "boolean");
        __DATA_TYPES.put(5, "calendar");
        __DATA_TYPES.put(2, "stream");
    }
}

