/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.data.repositorydata.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.UnknownDataException;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class MemoryRepositoryData
implements ModifiableRepositoryData {
    private String _fullName;
    private Map<String, Pair<String, Object>> _data;
    private String _defaultPrefix;

    public MemoryRepositoryData(String name) {
        this(name, "ametys");
    }

    public MemoryRepositoryData(String name, String defaultPrefix) {
        this._fullName = this._getFullName(name, defaultPrefix);
        this._defaultPrefix = defaultPrefix;
        this._data = new HashMap<String, Pair<String, Object>>();
    }

    @Override
    public String getString(String name, String prefix) {
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            if ("string".equals(value.getLeft()) && value.getRight() instanceof String) {
                return (String)value.getRight();
            }
            throw new AmetysRepositoryException("Unable to get the value of string data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
        }
        throw new UnknownDataException("Unknown data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public String[] getStrings(String name, String prefix) {
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            if ("string".equals(value.getLeft()) && value.getRight() instanceof String[]) {
                return (String[])value.getRight();
            }
            throw new AmetysRepositoryException("Unable to get the value of multiple string data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
        }
        throw new UnknownDataException("Unknown data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public Calendar getDate(String name, String prefix) {
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            if ("calendar".equals(value.getLeft()) && value.getRight() instanceof Calendar) {
                return (Calendar)value.getRight();
            }
            throw new AmetysRepositoryException("Unable to get the value of date data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
        }
        throw new UnknownDataException("Unknown data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public Calendar[] getDates(String name, String prefix) {
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            if ("calendar".equals(value.getLeft()) && value.getRight() instanceof Calendar[]) {
                return (Calendar[])value.getRight();
            }
            throw new AmetysRepositoryException("Unable to get the value of multiple date data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
        }
        throw new UnknownDataException("Unknown data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public Long getLong(String name, String prefix) {
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            if ("long".equals(value.getLeft()) && value.getRight() instanceof Long) {
                return (Long)value.getRight();
            }
            throw new AmetysRepositoryException("Unable to get the value of long data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
        }
        throw new UnknownDataException("Unknown data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public Long[] getLongs(String name, String prefix) {
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            if ("long".equals(value.getLeft()) && value.getRight() instanceof Long[]) {
                return (Long[])value.getRight();
            }
            throw new AmetysRepositoryException("Unable to get the value of multiple long data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
        }
        throw new UnknownDataException("Unknown data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public Double getDouble(String name, String prefix) {
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            if ("double".equals(value.getLeft()) && value.getRight() instanceof Double) {
                return (Double)value.getRight();
            }
            throw new AmetysRepositoryException("Unable to get the value of double data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
        }
        throw new UnknownDataException("Unknown data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public Double[] getDoubles(String name, String prefix) {
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            if ("double".equals(value.getLeft()) && value.getRight() instanceof Double[]) {
                return (Double[])value.getRight();
            }
            throw new AmetysRepositoryException("Unable to get the value of multiple double data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
        }
        throw new UnknownDataException("Unknown data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public Boolean getBoolean(String name, String prefix) {
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            if ("boolean".equals(value.getLeft()) && value.getRight() instanceof Boolean) {
                return (Boolean)value.getRight();
            }
            throw new AmetysRepositoryException("Unable to get the value of boolean data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
        }
        throw new UnknownDataException("Unknown data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public Boolean[] getBooleans(String name, String prefix) {
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            if ("boolean".equals(value.getLeft()) && value.getRight() instanceof Boolean[]) {
                return (Boolean[])value.getRight();
            }
            throw new AmetysRepositoryException("Unable to get the value of multiple boolean data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
        }
        throw new UnknownDataException("Unknown data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public ModifiableRepositoryData getRepositoryData(String name, String prefix) {
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            if (value.getRight() instanceof ModifiableRepositoryData[]) {
                ModifiableRepositoryData[] allRepositoryData = (ModifiableRepositoryData[])value.getRight();
                if (allRepositoryData.length >= 1) {
                    return ((ModifiableRepositoryData[])value.getRight())[0];
                }
                throw new UnknownDataException("Unknown data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
            }
            throw new AmetysRepositoryException("Unable to get the value of repository data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
        }
        throw new UnknownDataException("Unknown data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public RepositoryData[] getAllRepositoryData(String name, String prefix) {
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            if (value.getRight() instanceof ModifiableRepositoryData[]) {
                return (ModifiableRepositoryData[])value.getRight();
            }
            throw new AmetysRepositoryException("Unable to get the value of multiple repository data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
        }
        throw new UnknownDataException("Unknown data '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public Set<String> getDataNames(String prefix) {
        Object finalPrefix = prefix == null ? "*:" : (StringUtils.isEmpty((CharSequence)prefix) ? prefix : prefix + ":");
        return this._data.keySet().stream().filter(arg_0 -> MemoryRepositoryData.lambda$getDataNames$0((String)finalPrefix, arg_0)).map(arg_0 -> MemoryRepositoryData.lambda$getDataNames$1((String)finalPrefix, arg_0)).collect(Collectors.toSet());
    }

    @Override
    public String getName() {
        int prefixLength = this._fullName.indexOf(":") + 1;
        return prefixLength > 0 ? this._fullName.substring(prefixLength) : this._fullName;
    }

    @Override
    public boolean hasValue(String name, String prefix) {
        return this._data.containsKey(this._getFullName(name, prefix));
    }

    @Override
    public String getType(String name, String prefix) throws UnknownDataException {
        Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
        if (value != null) {
            return (String)value.getLeft();
        }
        throw new UnknownDataException("No data found for '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public boolean isMultiple(String name, String prefix) throws UnknownDataException {
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            if ("ametys:multipleItem".equals(value.getLeft())) {
                return true;
            }
            if (value.getRight().getClass().isArray()) {
                if (value.getRight() instanceof ModifiableRepositoryData[]) {
                    return ((ModifiableRepositoryData[])value.getRight()).length > 1;
                }
                return true;
            }
            return false;
        }
        throw new UnknownDataException("No data found for '" + prefix + ":" + name + "' in repository data named '" + this._fullName + "'.");
    }

    @Override
    public String getDefaultPrefix() {
        return this._defaultPrefix;
    }

    @Override
    public ModifiableRepositoryData addRepositoryData(String name, String dataTypeName, String prefix) {
        MemoryRepositoryData repositoryData = new MemoryRepositoryData(name, prefix);
        ArrayList<ModifiableRepositoryData> allRepositoryData = new ArrayList<ModifiableRepositoryData>();
        if (this.hasValue(name, prefix)) {
            Pair<String, Object> value = this._data.get(this._getFullName(name, prefix));
            allRepositoryData.addAll(Arrays.asList((ModifiableRepositoryData[])value.getRight()));
        }
        allRepositoryData.add(repositoryData);
        ModifiableRepositoryData[] result = allRepositoryData.toArray(new ModifiableRepositoryData[allRepositoryData.size()]);
        this._data.put(this._getFullName(name, prefix), (Pair<String, Object>)new ImmutablePair((Object)dataTypeName, (Object)result));
        return repositoryData;
    }

    @Override
    public void rename(String newName, String prefix) {
        this._fullName = this._getFullName(newName, prefix);
    }

    @Override
    public void setValue(String name, String value, String prefix) {
        this._setValue(name, "string", value, prefix);
    }

    @Override
    public void setValues(String name, String[] values, String prefix) {
        this._setValue(name, "string", values, prefix);
    }

    @Override
    public void setValue(String name, Calendar value, String prefix) {
        this._setValue(name, "calendar", value, prefix);
    }

    @Override
    public void setValues(String name, Calendar[] values, String prefix) {
        this._setValue(name, "calendar", values, prefix);
    }

    @Override
    public void setValue(String name, Long value, String prefix) {
        this._setValue(name, "long", value, prefix);
    }

    @Override
    public void setValues(String name, Long[] values, String prefix) {
        this._setValue(name, "long", values, prefix);
    }

    @Override
    public void setValue(String name, Double value, String prefix) {
        this._setValue(name, "double", value, prefix);
    }

    @Override
    public void setValues(String name, Double[] values, String prefix) {
        this._setValue(name, "double", values, prefix);
    }

    @Override
    public void setValue(String name, Boolean value, String prefix) {
        this._setValue(name, "boolean", value, prefix);
    }

    @Override
    public void setValues(String name, Boolean[] values, String prefix) {
        this._setValue(name, "boolean", values, prefix);
    }

    private void _setValue(String name, String dataTypeName, Object value, String prefix) {
        String fullName = this._getFullName(name, prefix);
        if (value == null) {
            throw new NullPointerException("Unable to set a 'null' data for '" + fullName + "' in repository data named '" + this._fullName + "'.");
        }
        this._checkDataName(name);
        if (this.hasValue(name, prefix)) {
            this.removeValue(name, prefix);
        }
        this._data.put(fullName, (Pair<String, Object>)new ImmutablePair((Object)dataTypeName, value));
    }

    private void _checkDataName(String name) {
        if (name == null) {
            throw new AmetysRepositoryException("Unable to set a value with the invalid data name (null) in repository data named '" + this._fullName + "'.");
        }
        if (!DATA_NAME_PATTERN.matcher(name).matches()) {
            throw new AmetysRepositoryException("Unable to set a value with the invalid data name '" + name + "'. Only [a-zA-Z][a-zA-Z0-9-_]* are allowed.");
        }
    }

    @Override
    public void removeValue(String name, String prefix) throws UnknownDataException {
        if (!this.hasValue(name, prefix)) {
            throw new UnknownDataException("No data found for '" + this._getFullName(name, prefix) + "' in repository data named '" + this._fullName + "'.");
        }
        this._data.remove(this._getFullName(name, prefix));
    }

    private String _getFullName(String name, String prefix) {
        return StringUtils.isEmpty((CharSequence)prefix) ? name : prefix + ":" + name;
    }

    @Override
    public InputStream getStream(String name, String prefix) {
        throw new UnsupportedOperationException("Streams are not supported by the memory repository data");
    }

    @Override
    public Long getStreamLength(String name, String prefix) {
        throw new UnsupportedOperationException("Streams are not supported by the memory repository data");
    }

    @Override
    public InputStream[] getStreams(String name, String prefix) {
        throw new UnsupportedOperationException("Streams are not supported by the memory repository data");
    }

    @Override
    public void setValue(String name, InputStream value, String prefix) {
        throw new UnsupportedOperationException("Streams are not supported by the memory repository data");
    }

    @Override
    public void setValues(String name, InputStream[] values, String prefix) {
        throw new UnsupportedOperationException("Streams are not supported by the memory repository data");
    }

    public String toString() {
        return this._fullName;
    }

    private static /* synthetic */ String lambda$getDataNames$1(String finalPrefix, String name) {
        return name.substring(finalPrefix.length());
    }

    private static /* synthetic */ boolean lambda$getDataNames$0(String finalPrefix, String name) {
        return name.startsWith(finalPrefix);
    }
}

