/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.data.type;

import java.lang.reflect.Array;
import org.ametys.plugins.repository.data.UnknownDataException;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.type.RepositoryElementType;
import org.ametys.runtime.model.exception.BadItemTypeException;

public interface ComplexRepositoryElementType<T>
extends RepositoryElementType<T> {
    public static final String TYPE_ID_DATA_NAME = "typeId";

    @Override
    default public Object read(RepositoryData parentData, String name) throws BadItemTypeException {
        if (!parentData.hasValue(name)) {
            return null;
        }
        if (!this.isCompatible(parentData, name)) {
            throw new BadItemTypeException("Try to get " + this.getId() + " value from the non '" + this.getId() + "' data '" + name + "' on '" + String.valueOf(parentData) + "'");
        }
        if (parentData.isMultiple(name)) {
            RepositoryData multipleParentData = parentData.getRepositoryData(name);
            return multipleParentData.getDataNames().stream().map(singleDataName -> multipleParentData.getRepositoryData((String)singleDataName)).map(singleData -> this.readSingleValue((RepositoryData)singleData)).toArray(size -> (Object[])Array.newInstance(this.getManagedClass(), size));
        }
        RepositoryData data = parentData.getRepositoryData(name);
        return !this.isSingleValueEmpty(data) ? this.readSingleValue(data) : null;
    }

    @Override
    default public boolean hasNonEmptyValue(RepositoryData parentData, String name) throws BadItemTypeException {
        if (!parentData.hasValue(name)) {
            return false;
        }
        if (!this.isCompatible(parentData, name)) {
            throw new BadItemTypeException("Try to check " + this.getId() + " value from the non '" + this.getId() + "' data '" + name + "' on '" + String.valueOf(parentData) + "'");
        }
        if (parentData.isMultiple(name)) {
            RepositoryData multipleParentData = parentData.getRepositoryData(name);
            return !multipleParentData.getDataNames().isEmpty();
        }
        RepositoryData data = parentData.getRepositoryData(name);
        return !this.isSingleValueEmpty(data);
    }

    public boolean isSingleValueEmpty(RepositoryData var1);

    public T readSingleValue(RepositoryData var1);

    @Override
    default public void write(ModifiableRepositoryData parentData, String name, Object value) throws BadItemTypeException {
        if (value == null) {
            if (parentData.hasValue(name) && parentData.isMultiple(name)) {
                parentData.removeValue(name);
                ModifiableRepositoryData multipleParentData = parentData.addRepositoryData(name, "ametys:multipleItem");
                multipleParentData.setValue(TYPE_ID_DATA_NAME, this.getId(), "ametys-internal");
            } else {
                this.emptySingleValue(parentData, name);
            }
        } else if (this.getManagedClass().isInstance(value)) {
            if (parentData.hasValue(name) && this.removeValueBeforeWritingIt()) {
                parentData.removeValue(name);
            }
            this.writeSingleValue(parentData, name, value);
        } else if (this.getManagedClassArray().isInstance(value)) {
            int i;
            ModifiableRepositoryData multipleParentData;
            if (parentData.hasValue(name) && !this.removeValueBeforeWritingIt()) {
                multipleParentData = parentData.getRepositoryData(name);
            } else {
                if (parentData.hasValue(name)) {
                    parentData.removeValue(name);
                }
                multipleParentData = parentData.addRepositoryData(name, "ametys:multipleItem");
                multipleParentData.setValue(TYPE_ID_DATA_NAME, this.getId(), "ametys-internal");
            }
            for (i = 0; i < ((Object[])value).length; ++i) {
                Object singleValue = ((Object[])value)[i];
                if (singleValue == null) {
                    throw new IllegalArgumentException("Try to set a null value into the multiple " + this.getId() + " data '" + name + "' on '" + String.valueOf(parentData) + "'");
                }
                this.writeSingleValue(multipleParentData, String.valueOf(i + 1), singleValue);
            }
            for (i = multipleParentData.getDataNames().size(); i > ((Object[])value).length; --i) {
                multipleParentData.removeValue(String.valueOf(i));
            }
        } else {
            StringBuilder message = new StringBuilder().append("Try to set the non ").append(this.getId()).append(" value '").append(value);
            message.append("' to the ").append(this.getId()).append(" data '").append(name).append("' on '").append(parentData).append("'");
            throw new BadItemTypeException(message.toString());
        }
    }

    default public boolean removeValueBeforeWritingIt() {
        return true;
    }

    default public void emptySingleValue(ModifiableRepositoryData parentData, String name) {
        if (this.removeValueBeforeWritingIt()) {
            if (parentData.hasValue(name)) {
                parentData.removeValue(name);
            }
            parentData.addRepositoryData(name, this.getRepositoryDataType());
        }
    }

    public void writeSingleValue(ModifiableRepositoryData var1, String var2, T var3);

    @Override
    default public boolean isCompatible(RepositoryData parentData, String name) throws UnknownDataException {
        if (parentData.hasValue(name + "__isEmpty", "ametys-internal")) {
            return true;
        }
        if (this.getRepositoryDataType().equals(parentData.getType(name))) {
            return true;
        }
        if ("ametys:multipleItem".equals(parentData.getType(name))) {
            RepositoryData multipleItemNode = parentData.getRepositoryData(name);
            return this.getId().equals(multipleItemNode.getString(TYPE_ID_DATA_NAME, "ametys-internal"));
        }
        return false;
    }
}

