/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.dom;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.util.dom.AbstractWrappingAmetysElement;
import org.ametys.core.util.dom.AmetysAttribute;
import org.ametys.plugins.repository.dom.MetadataElement;
import org.ametys.plugins.repository.dom.MultilingualStringElement;
import org.ametys.plugins.repository.dom.UserMetadataElement;
import org.ametys.plugins.repository.metadata.CompositeMetadata;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CompositeMetadataElement
extends AbstractWrappingAmetysElement<CompositeMetadata> {
    String _name;

    public CompositeMetadataElement(CompositeMetadata metadata, String name) {
        this(metadata, name, null);
    }

    public CompositeMetadataElement(CompositeMetadata metadata, String name, CompositeMetadataElement parent) {
        super((Object)metadata, (Element)((Object)parent));
        this._name = name;
    }

    public String getTagName() {
        char c = this._name.charAt(0);
        if (c >= '0' && c <= '9') {
            String hex = Integer.toHexString(c);
            return "_x" + StringUtils.leftPad((String)hex, (int)4, (char)'0') + "_" + this._name.substring(1);
        }
        return this._name;
    }

    protected Map<String, AmetysAttribute> _lookupAttributes() {
        HashMap<String, AmetysAttribute> result = new HashMap<String, AmetysAttribute>();
        result.put("name", new AmetysAttribute("name", "name", null, this._name, (Element)((Object)this)));
        result.put("type", new AmetysAttribute("type", "type", null, CompositeMetadata.MetadataType.COMPOSITE.toString(), (Element)((Object)this)));
        return result;
    }

    public boolean hasChildNodes() {
        String[] childNames = ((CompositeMetadata)this._object).getMetadataNames();
        return childNames != null ? childNames.length > 0 : false;
    }

    public Node getFirstChild() {
        String[] childNames = ((CompositeMetadata)this._object).getMetadataNames();
        if (childNames != null && childNames.length > 0) {
            if (((CompositeMetadata)this._object).getType(childNames[0]).equals((Object)CompositeMetadata.MetadataType.COMPOSITE)) {
                return new CompositeMetadataElement(((CompositeMetadata)this._object).getCompositeMetadata(childNames[0]), childNames[0], this);
            }
            if (((CompositeMetadata)this._object).getType(childNames[0]).equals((Object)CompositeMetadata.MetadataType.USER)) {
                return new UserMetadataElement(((CompositeMetadata)this._object).getCompositeMetadata(childNames[0]), childNames[0], this);
            }
            return new MetadataElement(childNames[0], (CompositeMetadata)this._object, this);
        }
        return null;
    }

    public Node getNextSibling() {
        if (this._parent == null) {
            return null;
        }
        CompositeMetadataElement parentElement = (CompositeMetadataElement)((Object)this._parent);
        CompositeMetadata parent = (CompositeMetadata)parentElement.getWrappedObject();
        String[] children = parent.getMetadataNames();
        boolean isNext = false;
        String nextSibling = null;
        int i = 0;
        while (nextSibling == null && i < children.length) {
            String child = children[i++];
            if (isNext) {
                nextSibling = child;
                continue;
            }
            if (!this._name.equals(child)) continue;
            isNext = true;
        }
        if (nextSibling != null) {
            CompositeMetadata.MetadataType type = parent.getType(nextSibling);
            switch (type) {
                case COMPOSITE: {
                    return new CompositeMetadataElement(parent.getCompositeMetadata(nextSibling), nextSibling, parentElement);
                }
                case USER: {
                    return new UserMetadataElement(parent.getCompositeMetadata(nextSibling), nextSibling, parentElement);
                }
                case MULTILINGUAL_STRING: {
                    return new MultilingualStringElement(parent.getMultilingualString(nextSibling), nextSibling, parentElement);
                }
            }
            return new MetadataElement(nextSibling, parent);
        }
        return null;
    }
}

