/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.ametys.core.util.dom.AbstractWrappingAmetysElement;
import org.ametys.core.util.dom.AmetysAttribute;
import org.ametys.core.util.dom.AmetysText;
import org.ametys.plugins.repository.dom.MultilingualStringElement;
import org.ametys.plugins.repository.metadata.MultilingualString;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LocaleStringElement
extends AbstractWrappingAmetysElement<Locale> {
    private MultilingualString _multilingualString;
    private Locale _locale;

    public LocaleStringElement(Locale locale, MultilingualString multilingualString) {
        this(locale, multilingualString, null);
    }

    public LocaleStringElement(Locale locale, MultilingualString multilingualString, MultilingualStringElement parent) {
        super((Object)locale, (Element)((Object)parent));
        this._locale = locale;
        this._multilingualString = multilingualString;
    }

    public String getTagName() {
        return ((Locale)this._object).getLanguage();
    }

    protected Map<String, AmetysAttribute> _lookupAttributes() {
        return new HashMap<String, AmetysAttribute>();
    }

    public boolean hasChildNodes() {
        return this._multilingualString.hasLocale(this._locale);
    }

    public Node getFirstChild() {
        return new AmetysText(this._multilingualString.getValue(this._locale), (Element)((Object)this));
    }

    public Node getNextSibling() {
        if (this._parent == null) {
            return null;
        }
        boolean isNext = false;
        Locale nextSibling = null;
        Iterator<Locale> brothers = this._multilingualString.getLocales().iterator();
        while (nextSibling == null && brothers.hasNext()) {
            Locale brother = brothers.next();
            if (isNext) {
                nextSibling = brother;
                continue;
            }
            if (!((Locale)this._object).getLanguage().equals(brother.getLanguage())) continue;
            isNext = true;
        }
        if (nextSibling == null) {
            return null;
        }
        return new LocaleStringElement(nextSibling, this._multilingualString, (MultilingualStringElement)((Object)this.getParentNode()));
    }
}

