/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.ametys.core.util.dom.AbstractWrappingAmetysElement;
import org.ametys.core.util.dom.AmetysAttribute;
import org.ametys.plugins.repository.dom.CompositeMetadataElement;
import org.ametys.plugins.repository.dom.LocaleStringElement;
import org.ametys.plugins.repository.dom.MetadataElement;
import org.ametys.plugins.repository.dom.UserMetadataElement;
import org.ametys.plugins.repository.metadata.CompositeMetadata;
import org.ametys.plugins.repository.metadata.MultilingualString;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultilingualStringElement
extends AbstractWrappingAmetysElement<MultilingualString> {
    String _name;

    public MultilingualStringElement(MultilingualString multilingualString, String name) {
        this(multilingualString, name, null);
    }

    public MultilingualStringElement(MultilingualString multilingualString, String name, CompositeMetadataElement parent) {
        super((Object)multilingualString, (Element)((Object)parent));
        this._name = name;
    }

    public String getTagName() {
        char c = this._name.charAt(0);
        if (c >= '0' && c <= '9') {
            String hex = Integer.toHexString(c);
            return "_x" + StringUtils.leftPad((String)hex, (int)4, (char)'0') + "_" + this._name.substring(1);
        }
        return this._name;
    }

    protected Map<String, AmetysAttribute> _lookupAttributes() {
        HashMap<String, AmetysAttribute> result = new HashMap<String, AmetysAttribute>();
        result.put("name", new AmetysAttribute("name", "name", null, this._name, (Element)((Object)this)));
        result.put("type", new AmetysAttribute("type", "type", null, CompositeMetadata.MetadataType.MULTILINGUAL_STRING.toString(), (Element)((Object)this)));
        return result;
    }

    public boolean hasChildNodes() {
        return ((MultilingualString)this._object).getLocales().size() > 0;
    }

    public Node getFirstChild() {
        Iterator<Locale> locales = ((MultilingualString)this._object).getLocales().iterator();
        if (locales.hasNext()) {
            Locale first = locales.next();
            return new LocaleStringElement(first, (MultilingualString)this._object, this);
        }
        return null;
    }

    public Node getNextSibling() {
        if (this._parent == null) {
            return null;
        }
        CompositeMetadataElement parentElement = (CompositeMetadataElement)((Object)this._parent);
        CompositeMetadata parent = (CompositeMetadata)parentElement.getWrappedObject();
        String[] children = parent.getMetadataNames();
        boolean isNext = false;
        String nextSibling = null;
        int i = 0;
        while (nextSibling == null && i < children.length) {
            String child = children[i++];
            if (isNext) {
                nextSibling = child;
                continue;
            }
            if (!this._name.equals(child)) continue;
            isNext = true;
        }
        if (nextSibling != null) {
            CompositeMetadata.MetadataType type = parent.getType(nextSibling);
            switch (type) {
                case COMPOSITE: {
                    return new CompositeMetadataElement(parent.getCompositeMetadata(nextSibling), nextSibling, parentElement);
                }
                case USER: {
                    return new UserMetadataElement(parent.getCompositeMetadata(nextSibling), nextSibling, parentElement);
                }
                case MULTILINGUAL_STRING: {
                    return new MultilingualStringElement(parent.getMultilingualString(nextSibling), nextSibling, parentElement);
                }
            }
            return new MetadataElement(nextSibling, parent);
        }
        return null;
    }
}

