/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.jcr;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import javax.jcr.query.Query;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.ProfileAssignmentStorage;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;

public class ACLJCRAmetysObjectHelper
implements Component,
Serviceable,
LogEnabled {
    protected static AmetysObjectResolver _resolver;
    protected static Repository _repository;
    private static final String __NODE_NAME_ROOT_ACL = "ametys-internal:acl";
    private static final String __NODETYPE_ROOT_ACL = "ametys:acl";
    private static final String __NODE_NAME_ACL_USERS = "users";
    private static final String __NODE_NAME_ACL_GROUPS = "groups";
    private static final String __NODETYPE_ACL_USER = "ametys:acl-user";
    private static final String __NODETYPE_ACL_GROUP = "ametys:acl-group";
    private static final String __PROPERTY_NAME_ALLOWED_ANY_CONNECTED_PROFILES = "ametys:allowed-any-connected-profiles";
    private static final String __PROPERTY_NAME_DENIED_ANY_CONNECTED_PROFILES = "ametys:denied-any-connected-profiles";
    private static final String __PROPERTY_NAME_ALLOWED_ANONYMOUS_PROFILES = "ametys:allowed-anonymous-profiles";
    private static final String __PROPERTY_NAME_DENIED_ANONYMOUS_PROFILES = "ametys:denied-anonymous-profiles";
    private static final String __PROPERTY_NAME_ALLOWED_PROFILES = "ametys:allowed-profiles";
    private static final String __PROPERTY_NAME_DENIED_PROFILES = "ametys:denied-profiles";
    private static final String __PROPERTY_NAME_DISALLOW_INHERITANCE = "ametys:disallow-inheritance";
    private static final Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> __ANONYMOUS_OR_ANYCONNECTEDUSER_NORIGHT;
    private static final Map<ProfileAssignmentStorage.UserOrGroup, Set<String>> __USER_OR_GROUP_NORIGHT;
    private static Logger _logger;

    public void service(ServiceManager manager) throws ServiceException {
        _resolver = (AmetysObjectResolver)((Object)manager.lookup(AmetysObjectResolver.ROLE));
        _repository = (Repository)manager.lookup("javax.jcr.Repository");
    }

    public void setLogger(Logger logger) {
        _logger = logger;
    }

    private static Set<String> _convertNodeToPath(Set<? extends Object> rootNodes) {
        return rootNodes.stream().filter(JCRAmetysObject.class::isInstance).map(JCRAmetysObject.class::cast).map(LambdaUtils.wrap(ao -> ISO9075.encodePath((String)ao.getNode().getPath()))).collect(Collectors.toSet());
    }

    public static Set<String> hasUserAnyAllowedProfile(Set<? extends Object> rootNodes, UserIdentity user, Set<String> profileIds) {
        AllowedProfileExpression expr = new AllowedProfileExpression(profileIds.toArray(new String[profileIds.size()]));
        for (String rootPath : ACLJCRAmetysObjectHelper._convertNodeToPath(rootNodes)) {
            NodeIterator nodes = ACLJCRAmetysObjectHelper.getACLUsers(user, rootPath, expr);
            if (!nodes.hasNext()) continue;
            Node userNode = nodes.nextNode();
            return ACLJCRAmetysObjectHelper._getProperty(userNode, __PROPERTY_NAME_ALLOWED_PROFILES);
        }
        return Set.of();
    }

    public static Set<String> hasGroupAnyAllowedProfile(Set<? extends Object> rootNodes, Set<GroupIdentity> groups, Set<String> profileIds) {
        if (!groups.isEmpty()) {
            AllowedProfileExpression expr = new AllowedProfileExpression(profileIds.toArray(new String[profileIds.size()]));
            for (String rootPath : ACLJCRAmetysObjectHelper._convertNodeToPath(rootNodes)) {
                NodeIterator nodes = ACLJCRAmetysObjectHelper._getApprochingACLGroups(groups, rootPath, expr);
                while (nodes.hasNext()) {
                    String directoryId;
                    String groupId;
                    Node groupNode = nodes.nextNode();
                    try {
                        groupId = Text.unescapeIllegalJcrChars((String)groupNode.getName());
                        directoryId = groupNode.getParent().getName();
                    }
                    catch (RepositoryException ex) {
                        throw new AmetysRepositoryException("An error occured getting group information", ex);
                    }
                    if (!groups.contains(new GroupIdentity(groupId, directoryId))) continue;
                    return ACLJCRAmetysObjectHelper._getProperty(groupNode, __PROPERTY_NAME_ALLOWED_PROFILES);
                }
            }
        }
        return Set.of();
    }

    public static Set<String> hasAnyConnectedAnyAllowedProfile(Set<? extends Object> rootNodes, Set<String> profileIds) {
        AnyConnectedAllowedProfileExpression expr = new AnyConnectedAllowedProfileExpression(profileIds.toArray(new String[profileIds.size()]));
        for (String rootPath : ACLJCRAmetysObjectHelper._convertNodeToPath(rootNodes)) {
            NodeIterator nodes = ACLJCRAmetysObjectHelper.getACLRoots(rootPath, expr);
            if (!nodes.hasNext()) continue;
            Node aclNode = nodes.nextNode();
            return ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_ALLOWED_ANY_CONNECTED_PROFILES);
        }
        return Set.of();
    }

    public static Set<String> hasAnonymousAnyAllowedProfile(Set<? extends Object> rootNodes, Set<String> profileIds) {
        AnonymousAllowedProfileExpression expr = new AnonymousAllowedProfileExpression(profileIds.toArray(new String[profileIds.size()]));
        for (String rootPath : ACLJCRAmetysObjectHelper._convertNodeToPath(rootNodes)) {
            NodeIterator nodes = ACLJCRAmetysObjectHelper.getACLRoots(rootPath, expr);
            if (!nodes.hasNext()) continue;
            Node aclNode = nodes.nextNode();
            return ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_ALLOWED_ANONYMOUS_PROFILES);
        }
        return Set.of();
    }

    public static Map<Object, Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>>> getAllProfilesForAnonymousAndAnyConnectedUser(Set<? extends Object> rootNodes) {
        HashMap<Object, Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>>> result = new HashMap<Object, Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>>>();
        OrExpression predicate = new OrExpression(() -> "@ametys:allowed-anonymous-profiles", () -> "@ametys:denied-anonymous-profiles", () -> "@ametys:allowed-any-connected-profiles", () -> "@ametys:denied-any-connected-profiles");
        for (String rootPath : ACLJCRAmetysObjectHelper._convertNodeToPath(rootNodes)) {
            NodeIterator nodes = ACLJCRAmetysObjectHelper.getACLRoots(rootPath, predicate);
            while (nodes.hasNext()) {
                Node aclNode = nodes.nextNode();
                try {
                    Set<String> deniedAny;
                    Set<String> allowedAny;
                    Set<String> deniedAnonymous;
                    HashMap<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> aoResult = new HashMap<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>>();
                    Set<String> allowedAnonymous = ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_ALLOWED_ANONYMOUS_PROFILES);
                    if (!allowedAnonymous.isEmpty()) {
                        aoResult.put(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED, allowedAnonymous);
                    }
                    if (!(deniedAnonymous = ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_DENIED_ANONYMOUS_PROFILES)).isEmpty()) {
                        aoResult.put(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED, deniedAnonymous);
                    }
                    if (!(allowedAny = ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_ALLOWED_ANY_CONNECTED_PROFILES)).isEmpty()) {
                        aoResult.put(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED, allowedAny);
                    }
                    if (!(deniedAny = ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_DENIED_ANY_CONNECTED_PROFILES)).isEmpty()) {
                        aoResult.put(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED, deniedAny);
                    }
                    if (aoResult.isEmpty()) continue;
                    AmetysObject ao = ACLJCRAmetysObjectHelper._getAmetysObjectFromACLNode(aclNode);
                    result.put(ao, aoResult);
                }
                catch (RepositoryException e) {
                    _logger.error("Failed to retrieve object for acl node " + aclNode.toString() + ". The node will be ignored.");
                }
            }
        }
        return result;
    }

    public static Map<Object, Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>>> getAllProfilesForGroups(Set<? extends Object> rootNodes, Set<GroupIdentity> groups) {
        HashMap<Object, Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>>> result = new HashMap<Object, Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>>>();
        if (!groups.isEmpty()) {
            for (String rootPath : ACLJCRAmetysObjectHelper._convertNodeToPath(rootNodes)) {
                NodeIterator nodes = ACLJCRAmetysObjectHelper._getApprochingACLGroups(groups, rootPath, null);
                while (nodes.hasNext()) {
                    String directoryId;
                    String groupId;
                    Node groupNode = nodes.nextNode();
                    try {
                        groupId = Text.unescapeIllegalJcrChars((String)groupNode.getName());
                        directoryId = groupNode.getParent().getName();
                    }
                    catch (RepositoryException ex) {
                        throw new AmetysRepositoryException("An error occured getting group information", ex);
                    }
                    GroupIdentity currentGroup = new GroupIdentity(groupId, directoryId);
                    if (!groups.contains(currentGroup)) continue;
                    try {
                        Set<String> deniedProfiles;
                        HashMap<ProfileAssignmentStorage.UserOrGroup, Set<String>> groupPermissions = new HashMap<ProfileAssignmentStorage.UserOrGroup, Set<String>>();
                        Set<String> allowedProfiles = ACLJCRAmetysObjectHelper._getProperty(groupNode, __PROPERTY_NAME_ALLOWED_PROFILES);
                        if (!allowedProfiles.isEmpty()) {
                            groupPermissions.put(ProfileAssignmentStorage.UserOrGroup.ALLOWED, allowedProfiles);
                        }
                        if (!(deniedProfiles = ACLJCRAmetysObjectHelper._getProperty(groupNode, __PROPERTY_NAME_DENIED_PROFILES)).isEmpty()) {
                            groupPermissions.put(ProfileAssignmentStorage.UserOrGroup.DENIED, deniedProfiles);
                        }
                        if (groupPermissions.isEmpty()) continue;
                        AmetysObject ao = ACLJCRAmetysObjectHelper._getAmetysObjectFromACLNode(groupNode);
                        Map objectPermissions = result.computeIfAbsent(ao, k -> new HashMap());
                        objectPermissions.put(currentGroup, groupPermissions);
                    }
                    catch (RepositoryException e) {
                        _logger.error("Failed to retrieve object for group acl node " + groupNode.toString() + ". The node will be ignored.");
                    }
                }
            }
        }
        return result;
    }

    public static Map<Object, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getAllProfilesForUser(Set<? extends Object> rootNodes, UserIdentity user) {
        HashMap<Object, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> result = new HashMap<Object, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>>();
        for (String rootPath : ACLJCRAmetysObjectHelper._convertNodeToPath(rootNodes)) {
            NodeIterator nodes = ACLJCRAmetysObjectHelper.getACLUsers(user, rootPath, null);
            while (nodes.hasNext()) {
                Node userNode = nodes.nextNode();
                try {
                    Set<String> deniedProfiles;
                    HashMap<ProfileAssignmentStorage.UserOrGroup, Set<String>> aoResult = new HashMap<ProfileAssignmentStorage.UserOrGroup, Set<String>>();
                    Set<String> allowedProfiles = ACLJCRAmetysObjectHelper._getProperty(userNode, __PROPERTY_NAME_ALLOWED_PROFILES);
                    if (!allowedProfiles.isEmpty()) {
                        aoResult.put(ProfileAssignmentStorage.UserOrGroup.ALLOWED, allowedProfiles);
                    }
                    if (!(deniedProfiles = ACLJCRAmetysObjectHelper._getProperty(userNode, __PROPERTY_NAME_DENIED_PROFILES)).isEmpty()) {
                        aoResult.put(ProfileAssignmentStorage.UserOrGroup.DENIED, deniedProfiles);
                    }
                    if (aoResult.isEmpty()) continue;
                    AmetysObject ao = ACLJCRAmetysObjectHelper._getAmetysObjectFromACLNode(userNode);
                    result.put(ao, aoResult);
                }
                catch (RepositoryException e) {
                    _logger.error("Failed to retrieve object for user acl node " + userNode.toString() + ". The node will be ignored.");
                }
            }
        }
        return result;
    }

    private static AmetysObject _getAmetysObjectFromACLNode(Node node) throws RepositoryException, ItemNotFoundException, AccessDeniedException {
        switch (node.getPrimaryNodeType().getName()) {
            case "ametys:acl": {
                return _resolver.resolve(node.getParent(), false);
            }
            case "ametys:acl-user": 
            case "ametys:acl-group": {
                return _resolver.resolve(node.getParent().getParent().getParent().getParent(), false);
            }
        }
        return null;
    }

    public static NodeIterator getACLRoots(String rootPath, Expression predicat) {
        StringBuilder sb = new StringBuilder("/jcr:root");
        if (rootPath != null) {
            sb.append(rootPath);
        }
        sb.append("//element(*, ").append(__NODETYPE_ROOT_ACL).append(")");
        if (predicat != null) {
            sb.append("[").append(predicat.build()).append("]");
        }
        return ACLJCRAmetysObjectHelper._query(sb.toString());
    }

    public static NodeIterator getACLUsers(UserIdentity user, String rootPath, Expression predicat) {
        StringBuilder sb = new StringBuilder("/jcr:root");
        if (rootPath != null) {
            sb.append(rootPath);
        }
        sb.append("//element(*, ").append(__NODETYPE_ROOT_ACL).append(")").append("/").append(__NODE_NAME_ACL_USERS).append("/").append(user.getPopulationId()).append("/").append(ISO9075.encode((String)user.getLogin()));
        if (predicat != null) {
            sb.append("[").append(predicat.build()).append("]");
        }
        String jcrQuery = sb.toString();
        return ACLJCRAmetysObjectHelper._query(jcrQuery);
    }

    public static NodeIterator getACLUsers(String rootPath, Expression predicate) {
        StringBuilder sb = new StringBuilder("/jcr:root");
        if (rootPath != null) {
            sb.append(rootPath);
        }
        sb.append("//element(*, ").append(__NODETYPE_ACL_USER).append(")");
        if (predicate != null) {
            sb.append("[").append(predicate.build()).append("]");
        }
        String jcrQuery = sb.toString();
        return ACLJCRAmetysObjectHelper._query(jcrQuery);
    }

    public static NodeIterator getACLUsers(Expression predicat) {
        StringBuilder sb = new StringBuilder();
        sb.append("//element(*, ").append(__NODETYPE_ACL_USER).append(")");
        if (predicat != null) {
            sb.append("[").append(predicat.build()).append("]");
        }
        return ACLJCRAmetysObjectHelper._query(sb.toString());
    }

    public static NodeIterator getACLGroups(Expression predicat) {
        StringBuilder sb = new StringBuilder();
        sb.append("//element(*, ").append(__NODETYPE_ACL_GROUP).append(")");
        if (predicat != null) {
            sb.append("[").append(predicat.build()).append("]");
        }
        return ACLJCRAmetysObjectHelper._query(sb.toString());
    }

    public static NodeIterator getACLGroups(String rootPath, Expression predicate) {
        StringBuilder sb = new StringBuilder("/jcr:root");
        if (rootPath != null) {
            sb.append(rootPath);
        }
        sb.append("//element(*, ").append(__NODETYPE_ACL_GROUP).append(")");
        if (predicate != null) {
            sb.append("[").append(predicate.build()).append("]");
        }
        return ACLJCRAmetysObjectHelper._query(sb.toString());
    }

    private static NodeIterator _getApprochingACLGroups(Set<GroupIdentity> groups, String rootPath, Expression predicat) {
        StringBuilder sb = new StringBuilder("/jcr:root");
        if (rootPath != null) {
            sb.append(rootPath);
        }
        sb.append("//element(*, ametys:acl-group)[(");
        sb.append(groups.stream().map(GroupIdentity::getId).map(Text::escapeIllegalJcrChars).map(ISO9075::encode).map(nodeName -> "fn:name()='" + nodeName + "'").collect(Collectors.joining(Expression.LogicalOperator.OR.toString())));
        sb.append(")");
        if (predicat != null) {
            sb.append(Expression.LogicalOperator.AND.toString()).append(predicat.build());
        }
        sb.append("]");
        return ACLJCRAmetysObjectHelper._query(sb.toString());
    }

    public static NodeIterator getACLGroups(GroupIdentity group, String rootPath, Expression predicat) {
        StringBuilder sb = new StringBuilder("/jcr:root");
        if (rootPath != null) {
            sb.append(rootPath);
        }
        sb.append("//element(*, ").append(__NODETYPE_ROOT_ACL).append(")").append("/").append(__NODE_NAME_ACL_GROUPS).append("/").append(group.getDirectoryId()).append("/").append(ISO9075.encode((String)Text.escapeIllegalJcrChars((String)group.getId())));
        if (predicat != null) {
            sb.append("[").append(predicat.build()).append("]");
        }
        return ACLJCRAmetysObjectHelper._query(sb.toString());
    }

    private static NodeIterator _query(String jcrQuery) {
        Session session = null;
        try {
            session = _repository.login();
            long t1 = System.currentTimeMillis();
            Query query = session.getWorkspace().getQueryManager().createQuery(jcrQuery, "xpath");
            if (_logger.isInfoEnabled()) {
                _logger.info("ACLJCR query '" + jcrQuery + "' executed in " + (System.currentTimeMillis() - t1) + " ms");
            }
            return query.execute().getNodes();
        }
        catch (RepositoryException ex) {
            if (session != null) {
                session.logout();
            }
            throw new AmetysRepositoryException("An error occured executing the JCR query : " + jcrQuery, ex);
        }
    }

    public static Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> getProfilesForAnonymousAndAnyConnectedUser(Node node) {
        Node aclNode = ACLJCRAmetysObjectHelper._getACLNode(node);
        if (aclNode == null) {
            return __ANONYMOUS_OR_ANYCONNECTEDUSER_NORIGHT;
        }
        return Map.of(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED, ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_ALLOWED_ANONYMOUS_PROFILES), ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED, ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_DENIED_ANONYMOUS_PROFILES), ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED, ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_ALLOWED_ANY_CONNECTED_PROFILES), ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED, ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_DENIED_ANY_CONNECTED_PROFILES));
    }

    public static void addAllowedProfilesForAnyConnectedUser(Node node, Set<String> profileIds) {
        Node aclNode = ACLJCRAmetysObjectHelper._getOrCreateACLNode(node);
        for (String profile : profileIds) {
            ACLJCRAmetysObjectHelper._addProperty(aclNode, __PROPERTY_NAME_ALLOWED_ANY_CONNECTED_PROFILES, profile);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void removeAllowedProfilesForAnyConnectedUser(Node node, Set<String> profileIds) {
        Node aclNode = ACLJCRAmetysObjectHelper._getOrCreateACLNode(node);
        for (String profile : profileIds) {
            ACLJCRAmetysObjectHelper._removeProperty(aclNode, __PROPERTY_NAME_ALLOWED_ANY_CONNECTED_PROFILES, profile);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void addDeniedProfilesForAnyConnectedUser(Node node, Set<String> profileIds) {
        Node aclNode = ACLJCRAmetysObjectHelper._getOrCreateACLNode(node);
        for (String profile : profileIds) {
            ACLJCRAmetysObjectHelper._addProperty(aclNode, __PROPERTY_NAME_DENIED_ANY_CONNECTED_PROFILES, profile);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void removeDeniedProfilesForAnyConnectedUser(Node node, Set<String> profileIds) {
        Node aclNode = ACLJCRAmetysObjectHelper._getOrCreateACLNode(node);
        for (String profile : profileIds) {
            ACLJCRAmetysObjectHelper._removeProperty(aclNode, __PROPERTY_NAME_DENIED_ANY_CONNECTED_PROFILES, profile);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void addAllowedProfilesForAnonymous(Node node, Set<String> profileIds) {
        Node aclNode = ACLJCRAmetysObjectHelper._getOrCreateACLNode(node);
        for (String profile : profileIds) {
            ACLJCRAmetysObjectHelper._addProperty(aclNode, __PROPERTY_NAME_ALLOWED_ANONYMOUS_PROFILES, profile);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void removeAllowedProfilesForAnonymous(Node node, Set<String> profileIds) {
        Node aclNode = ACLJCRAmetysObjectHelper._getOrCreateACLNode(node);
        for (String profile : profileIds) {
            ACLJCRAmetysObjectHelper._removeProperty(aclNode, __PROPERTY_NAME_ALLOWED_ANONYMOUS_PROFILES, profile);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void addDeniedProfilesForAnonymous(Node node, Set<String> profileIds) {
        Node aclNode = ACLJCRAmetysObjectHelper._getOrCreateACLNode(node);
        for (String profile : profileIds) {
            ACLJCRAmetysObjectHelper._addProperty(aclNode, __PROPERTY_NAME_DENIED_ANONYMOUS_PROFILES, profile);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void removeDeniedProfilesForAnonymous(Node node, Set<String> profileIds) {
        Node aclNode = ACLJCRAmetysObjectHelper._getOrCreateACLNode(node);
        for (String profile : profileIds) {
            ACLJCRAmetysObjectHelper._removeProperty(aclNode, __PROPERTY_NAME_DENIED_ANONYMOUS_PROFILES, profile);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static Map<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getProfilesForUsers(Node node, UserIdentity user) {
        if (user == null) {
            try {
                Node usersNode = ACLJCRAmetysObjectHelper._getUsersNode(node);
                if (usersNode == null) {
                    return Map.of();
                }
                HashMap<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> result = new HashMap<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>>();
                NodeIterator populationsIterator = usersNode.getNodes();
                while (populationsIterator.hasNext()) {
                    Node populationNode = populationsIterator.nextNode();
                    NodeIterator usersIterator = populationNode.getNodes();
                    while (usersIterator.hasNext()) {
                        Node userNode = usersIterator.nextNode();
                        Set<String> allowedProfiles = ACLJCRAmetysObjectHelper._getProperty(userNode, __PROPERTY_NAME_ALLOWED_PROFILES);
                        Set<String> deniedProfiles = ACLJCRAmetysObjectHelper._getProperty(userNode, __PROPERTY_NAME_DENIED_PROFILES);
                        if (allowedProfiles.isEmpty() && deniedProfiles.isEmpty()) continue;
                        result.put(new UserIdentity(userNode.getName(), populationNode.getName()), Map.of(ProfileAssignmentStorage.UserOrGroup.ALLOWED, allowedProfiles, ProfileAssignmentStorage.UserOrGroup.DENIED, deniedProfiles));
                    }
                }
                return result;
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException("Unable to get allowed/denied users", e);
            }
        }
        Node userNode = ACLJCRAmetysObjectHelper._getUserNode(node, user);
        if (userNode == null) {
            return Map.of(user, __USER_OR_GROUP_NORIGHT);
        }
        return Map.of(user, Map.of(ProfileAssignmentStorage.UserOrGroup.ALLOWED, ACLJCRAmetysObjectHelper._getProperty(userNode, __PROPERTY_NAME_ALLOWED_PROFILES), ProfileAssignmentStorage.UserOrGroup.DENIED, ACLJCRAmetysObjectHelper._getProperty(userNode, __PROPERTY_NAME_DENIED_PROFILES)));
    }

    public static void addAllowedUsers(Set<UserIdentity> users, Node node, String profileId) {
        for (UserIdentity userIdentity : users) {
            Node userNode = ACLJCRAmetysObjectHelper._getOrCreateUserNode(node, userIdentity);
            ACLJCRAmetysObjectHelper._addProperty(userNode, __PROPERTY_NAME_ALLOWED_PROFILES, profileId);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void removeAllowedUsers(Set<UserIdentity> users, Node node, String profileId) {
        for (UserIdentity userIdentity : users) {
            Node userNode = ACLJCRAmetysObjectHelper._getOrCreateUserNode(node, userIdentity);
            ACLJCRAmetysObjectHelper._removeProperty(userNode, __PROPERTY_NAME_ALLOWED_PROFILES, profileId);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void removeAllowedUsers(Set<UserIdentity> users, Node node) {
        for (UserIdentity userIdentity : users) {
            Node userNode = ACLJCRAmetysObjectHelper._getOrCreateUserNode(node, userIdentity);
            ACLJCRAmetysObjectHelper._setProperty(userNode, __PROPERTY_NAME_ALLOWED_PROFILES, Collections.EMPTY_SET);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void addDeniedUsers(Set<UserIdentity> users, Node node, String profileId) {
        for (UserIdentity userIdentity : users) {
            Node userNode = ACLJCRAmetysObjectHelper._getOrCreateUserNode(node, userIdentity);
            ACLJCRAmetysObjectHelper._addProperty(userNode, __PROPERTY_NAME_DENIED_PROFILES, profileId);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void removeDeniedUsers(Set<UserIdentity> users, Node node, String profileId) {
        for (UserIdentity userIdentity : users) {
            Node userNode = ACLJCRAmetysObjectHelper._getOrCreateUserNode(node, userIdentity);
            ACLJCRAmetysObjectHelper._removeProperty(userNode, __PROPERTY_NAME_DENIED_PROFILES, profileId);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void removeDeniedUsers(Set<UserIdentity> users, Node node) {
        for (UserIdentity userIdentity : users) {
            Node userNode = ACLJCRAmetysObjectHelper._getOrCreateUserNode(node, userIdentity);
            ACLJCRAmetysObjectHelper._setProperty(userNode, __PROPERTY_NAME_DENIED_PROFILES, Collections.EMPTY_SET);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getProfilesForGroups(Node node, Set<GroupIdentity> groups) {
        try {
            if (groups != null && groups.isEmpty()) {
                return Map.of();
            }
            Node groupsNode = ACLJCRAmetysObjectHelper._getGroupsNode(node);
            if (groupsNode == null) {
                return Map.of();
            }
            HashMap<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> result = new HashMap<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>>();
            if (groups == null) {
                NodeIterator groupDirectoriesIterator = groupsNode.getNodes();
                while (groupDirectoriesIterator.hasNext()) {
                    Node groupDirectoryNode = groupDirectoriesIterator.nextNode();
                    NodeIterator groupsIterator = groupDirectoryNode.getNodes();
                    while (groupsIterator.hasNext()) {
                        Node groupNode = groupsIterator.nextNode();
                        Set<String> allowedProfiles = ACLJCRAmetysObjectHelper._getProperty(groupNode, __PROPERTY_NAME_ALLOWED_PROFILES);
                        Set<String> deniedProfiles = ACLJCRAmetysObjectHelper._getProperty(groupNode, __PROPERTY_NAME_DENIED_PROFILES);
                        if (allowedProfiles.isEmpty() && deniedProfiles.isEmpty()) continue;
                        result.put(new GroupIdentity(Text.unescapeIllegalJcrChars((String)groupNode.getName()), groupDirectoryNode.getName()), Map.of(ProfileAssignmentStorage.UserOrGroup.ALLOWED, allowedProfiles, ProfileAssignmentStorage.UserOrGroup.DENIED, deniedProfiles));
                    }
                }
            } else {
                HashMap groupsNodeByDirectoryIdCache = new HashMap();
                for (GroupIdentity group : groups) {
                    Node directoryNode = (Node)groupsNodeByDirectoryIdCache.computeIfAbsent(group.getDirectoryId(), LambdaUtils.wrap(directoryId -> groupsNode.hasNode(directoryId) ? groupsNode.getNode(directoryId) : null));
                    String groupNodeName = Text.escapeIllegalJcrChars((String)group.getId());
                    if (directoryNode == null || !directoryNode.hasNode(groupNodeName)) continue;
                    Node groupNode = directoryNode.getNode(groupNodeName);
                    result.put(group, Map.of(ProfileAssignmentStorage.UserOrGroup.ALLOWED, ACLJCRAmetysObjectHelper._getProperty(groupNode, __PROPERTY_NAME_ALLOWED_PROFILES), ProfileAssignmentStorage.UserOrGroup.DENIED, ACLJCRAmetysObjectHelper._getProperty(groupNode, __PROPERTY_NAME_DENIED_PROFILES)));
                }
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get allowed/denied groups", e);
        }
    }

    public static void addAllowedGroups(Set<GroupIdentity> groups, Node node, String profileId) {
        for (GroupIdentity groupIdentity : groups) {
            Node groupNode = ACLJCRAmetysObjectHelper._getOrCreateGroupNode(node, groupIdentity);
            ACLJCRAmetysObjectHelper._addProperty(groupNode, __PROPERTY_NAME_ALLOWED_PROFILES, profileId);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void removeAllowedGroups(Set<GroupIdentity> groups, Node node, String profileId) {
        for (GroupIdentity groupIdentity : groups) {
            Node groupNode = ACLJCRAmetysObjectHelper._getOrCreateGroupNode(node, groupIdentity);
            ACLJCRAmetysObjectHelper._removeProperty(groupNode, __PROPERTY_NAME_ALLOWED_PROFILES, profileId);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void removeAllowedGroups(Set<GroupIdentity> groups, Node node) {
        for (GroupIdentity groupIdentity : groups) {
            Node groupNode = ACLJCRAmetysObjectHelper._getOrCreateGroupNode(node, groupIdentity);
            ACLJCRAmetysObjectHelper._setProperty(groupNode, __PROPERTY_NAME_ALLOWED_PROFILES, Collections.EMPTY_SET);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void addDeniedGroups(Set<GroupIdentity> groups, Node node, String profileId) {
        for (GroupIdentity groupIdentity : groups) {
            Node groupNode = ACLJCRAmetysObjectHelper._getOrCreateGroupNode(node, groupIdentity);
            ACLJCRAmetysObjectHelper._addProperty(groupNode, __PROPERTY_NAME_DENIED_PROFILES, profileId);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void removeDeniedGroups(Set<GroupIdentity> groups, Node node, String profileId) {
        for (GroupIdentity groupIdentity : groups) {
            Node groupNode = ACLJCRAmetysObjectHelper._getOrCreateGroupNode(node, groupIdentity);
            ACLJCRAmetysObjectHelper._removeProperty(groupNode, __PROPERTY_NAME_DENIED_PROFILES, profileId);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void removeDeniedGroups(Set<GroupIdentity> groups, Node node) {
        for (GroupIdentity groupIdentity : groups) {
            Node groupNode = ACLJCRAmetysObjectHelper._getOrCreateGroupNode(node, groupIdentity);
            ACLJCRAmetysObjectHelper._setProperty(groupNode, __PROPERTY_NAME_DENIED_PROFILES, Collections.EMPTY_SET);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    public static void removeProfile(String profileId) {
        OrExpression expr = new OrExpression(new AllowedProfileExpression(profileId), new DeniedProfileExpression(profileId));
        NodeIterator users = ACLJCRAmetysObjectHelper.getACLUsers(expr);
        while (users.hasNext()) {
            Node userNode = (Node)users.next();
            ACLJCRAmetysObjectHelper._removeProperty(userNode, __PROPERTY_NAME_ALLOWED_PROFILES, profileId);
            ACLJCRAmetysObjectHelper._removeProperty(userNode, __PROPERTY_NAME_DENIED_PROFILES, profileId);
            ACLJCRAmetysObjectHelper._save(userNode);
        }
        NodeIterator groups = ACLJCRAmetysObjectHelper.getACLGroups(expr);
        while (groups.hasNext()) {
            Node groupNode = (Node)groups.next();
            ACLJCRAmetysObjectHelper._removeProperty(groupNode, __PROPERTY_NAME_ALLOWED_PROFILES, profileId);
            ACLJCRAmetysObjectHelper._removeProperty(groupNode, __PROPERTY_NAME_DENIED_PROFILES, profileId);
            ACLJCRAmetysObjectHelper._save(groupNode);
        }
        expr = new OrExpression(new AnonymousAllowedProfileExpression(profileId), new AnonymousDeniedProfileExpression(profileId), new AnyConnectedAllowedProfileExpression(profileId), new AnyConnectedDeniedProfileExpression(profileId));
        NodeIterator nodes = ACLJCRAmetysObjectHelper.getACLRoots(null, expr);
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            ACLJCRAmetysObjectHelper._removeProperty(node, __PROPERTY_NAME_ALLOWED_ANY_CONNECTED_PROFILES, profileId);
            ACLJCRAmetysObjectHelper._removeProperty(node, __PROPERTY_NAME_DENIED_ANY_CONNECTED_PROFILES, profileId);
            ACLJCRAmetysObjectHelper._removeProperty(node, __PROPERTY_NAME_ALLOWED_ANONYMOUS_PROFILES, profileId);
            ACLJCRAmetysObjectHelper._removeProperty(node, __PROPERTY_NAME_DENIED_ANONYMOUS_PROFILES, profileId);
            ACLJCRAmetysObjectHelper._save(node);
        }
    }

    public static void removeUser(UserIdentity user) {
        NodeIterator users = ACLJCRAmetysObjectHelper.getACLUsers(user, null, null);
        while (users.hasNext()) {
            Node userNode = (Node)users.next();
            try {
                userNode.remove();
                ACLJCRAmetysObjectHelper._save(userNode);
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException(e);
            }
        }
    }

    public static void removeGroup(GroupIdentity group) {
        NodeIterator groups = ACLJCRAmetysObjectHelper.getACLGroups(group, null, null);
        while (groups.hasNext()) {
            Node gpNode = (Node)groups.next();
            try {
                gpNode.remove();
                ACLJCRAmetysObjectHelper._save(gpNode);
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException(e);
            }
        }
    }

    public static boolean isInheritanceDisallowed(Node node) {
        try {
            Node aclNode = ACLJCRAmetysObjectHelper._getACLNode(node);
            if (aclNode != null && aclNode.hasProperty(__PROPERTY_NAME_DISALLOW_INHERITANCE)) {
                return aclNode.getProperty(__PROPERTY_NAME_DISALLOW_INHERITANCE).getBoolean();
            }
            return false;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get ametys:disallow-inheritance property", e);
        }
    }

    public static void disallowInheritance(Node node, boolean disallow) {
        Node aclNode = ACLJCRAmetysObjectHelper._getOrCreateACLNode(node);
        try {
            aclNode.setProperty(__PROPERTY_NAME_DISALLOW_INHERITANCE, disallow);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set ametys:disallow-inheritance property", e);
        }
        ACLJCRAmetysObjectHelper._save(node);
    }

    private static void _checkLock(Node node) throws AmetysRepositoryException {
        try {
            if (node.isLocked()) {
                LockManager lockManager = node.getSession().getWorkspace().getLockManager();
                Lock lock = lockManager.getLock(node.getPath());
                Node lockHolder = lock.getNode();
                lockManager.addLockToken(lockHolder.getProperty("ametys-internal:lockToken").getString());
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to add lock token on ACL node", e);
        }
    }

    private static Node _getOrCreateACLNode(Node node) {
        try {
            if (node.hasNode(__NODE_NAME_ROOT_ACL)) {
                return node.getNode(__NODE_NAME_ROOT_ACL);
            }
            ACLJCRAmetysObjectHelper._checkLock(node);
            return node.addNode(__NODE_NAME_ROOT_ACL, __NODETYPE_ROOT_ACL);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error while getting root ACL node.", e);
        }
    }

    private static Node _getACLNode(Node node) {
        try {
            if (node.hasNode(__NODE_NAME_ROOT_ACL)) {
                return node.getNode(__NODE_NAME_ROOT_ACL);
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error while getting root ACL node.", e);
        }
    }

    private static Node _getOrCreateUsersNode(Node node) {
        try {
            Node aclNode = ACLJCRAmetysObjectHelper._getOrCreateACLNode(node);
            if (aclNode.hasNode(__NODE_NAME_ACL_USERS)) {
                return aclNode.getNode(__NODE_NAME_ACL_USERS);
            }
            return aclNode.addNode(__NODE_NAME_ACL_USERS, "nt:unstructured");
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error while getting 'users' ACL node.", e);
        }
    }

    private static Node _getUserNode(Node node, UserIdentity user) {
        try {
            Node popNode;
            Node aclUsersNode;
            Node aclNode = ACLJCRAmetysObjectHelper._getACLNode(node);
            if (aclNode != null && aclNode.hasNode(__NODE_NAME_ACL_USERS) && (aclUsersNode = aclNode.getNode(__NODE_NAME_ACL_USERS)).hasNode(user.getPopulationId()) && (popNode = aclUsersNode.getNode(user.getPopulationId())).hasNode(user.getLogin())) {
                return popNode.getNode(user.getLogin());
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error while getting 'users' ACL node.", e);
        }
    }

    private static Node _getUsersNode(Node node) {
        try {
            Node aclNode = ACLJCRAmetysObjectHelper._getACLNode(node);
            if (aclNode != null && aclNode.hasNode(__NODE_NAME_ACL_USERS)) {
                return aclNode.getNode(__NODE_NAME_ACL_USERS);
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error while getting 'users' ACL node.", e);
        }
    }

    private static Node _getOrCreateGroupsNode(Node node) {
        try {
            Node aclNode = ACLJCRAmetysObjectHelper._getOrCreateACLNode(node);
            if (aclNode.hasNode(__NODE_NAME_ACL_GROUPS)) {
                return aclNode.getNode(__NODE_NAME_ACL_GROUPS);
            }
            return aclNode.addNode(__NODE_NAME_ACL_GROUPS, "nt:unstructured");
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error while getting 'groups' ACL node.", e);
        }
    }

    private static Node _getGroupsNode(Node node) {
        try {
            Node aclNode = ACLJCRAmetysObjectHelper._getACLNode(node);
            if (aclNode != null && aclNode.hasNode(__NODE_NAME_ACL_GROUPS)) {
                return aclNode.getNode(__NODE_NAME_ACL_GROUPS);
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error while getting 'groups' ACL node.", e);
        }
    }

    private static Node _getOrCreateUserNode(Node node, UserIdentity userIdentity) {
        try {
            Node usersNode = ACLJCRAmetysObjectHelper._getOrCreateUsersNode(node);
            String population = userIdentity.getPopulationId();
            String login = userIdentity.getLogin();
            if (usersNode.hasNode(population)) {
                Node populationNode = usersNode.getNode(population);
                if (populationNode.hasNode(login)) {
                    return populationNode.getNode(login);
                }
                return populationNode.addNode(login, __NODETYPE_ACL_USER);
            }
            return usersNode.addNode(population, "nt:unstructured").addNode(login, __NODETYPE_ACL_USER);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(String.format("Error while getting 'user' ACL node for %s.", userIdentity.toString()), e);
        }
    }

    private static Node _getOrCreateGroupNode(Node node, GroupIdentity groupIdentity) {
        try {
            Node groupsNode = ACLJCRAmetysObjectHelper._getOrCreateGroupsNode(node);
            String directoryId = groupIdentity.getDirectoryId();
            String id = Text.escapeIllegalJcrChars((String)groupIdentity.getId());
            if (groupsNode.hasNode(directoryId)) {
                Node populationNode = groupsNode.getNode(directoryId);
                if (populationNode.hasNode(id)) {
                    return populationNode.getNode(id);
                }
                return populationNode.addNode(id, __NODETYPE_ACL_GROUP);
            }
            return groupsNode.addNode(directoryId, "nt:unstructured").addNode(id, __NODETYPE_ACL_GROUP);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(String.format("Error while getting 'group' ACL node for %s.", groupIdentity.toString()), e);
        }
    }

    private static Set<String> _getProperty(Node node, String propertyName) {
        try {
            Value[] values = node.getProperty(propertyName).getValues();
            HashSet<String> result = new HashSet<String>();
            for (Value value : values) {
                result.add(value.getString());
            }
            return result;
        }
        catch (PathNotFoundException e) {
            return new HashSet<String>();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get " + propertyName + " property", e);
        }
    }

    private static void _setProperty(Node node, String propertyName, Set<String> profiles) {
        try {
            node.setProperty(propertyName, profiles.toArray(new String[profiles.size()]));
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set " + propertyName + " property", e);
        }
    }

    private static void _addProperty(Node node, String propertyName, String profileToAdd) {
        Set<String> profiles = ACLJCRAmetysObjectHelper._getProperty(node, propertyName);
        if (!profiles.contains(profileToAdd)) {
            profiles.add(profileToAdd);
            ACLJCRAmetysObjectHelper._setProperty(node, propertyName, profiles);
        }
    }

    private static void _removeProperty(Node node, String propertyName, String profileToRemove) {
        Set<String> profiles = ACLJCRAmetysObjectHelper._getProperty(node, propertyName);
        if (profiles.contains(profileToRemove)) {
            profiles.remove(profileToRemove);
            ACLJCRAmetysObjectHelper._setProperty(node, propertyName, profiles);
        }
    }

    private static void _save(Node node) {
        try {
            node.getSession().save();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to save changes", e);
        }
    }

    public static Map<Object, Set<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys>> getProfilePermissionsForAnonymousAndAnyConnectedUser(Set<? extends Object> rootNodes, String profileId) {
        OrExpression expr = new OrExpression(new AnyConnectedAllowedProfileExpression(profileId), new AnyConnectedDeniedProfileExpression(profileId), new AnonymousAllowedProfileExpression(profileId), new AnonymousDeniedProfileExpression(profileId));
        HashMap<Object, Set<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys>> result = new HashMap<Object, Set<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys>>();
        for (String rootPath : ACLJCRAmetysObjectHelper._convertNodeToPath(rootNodes)) {
            NodeIterator nodes = ACLJCRAmetysObjectHelper.getACLRoots(rootPath, expr);
            while (nodes.hasNext()) {
                Node aclNode = nodes.nextNode();
                try {
                    Set<String> deniedAny;
                    Set<String> allowedAny;
                    Set<String> deniedAnonymous;
                    HashSet<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys> aoResult = new HashSet<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys>();
                    Set<String> allowedAnonymous = ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_ALLOWED_ANONYMOUS_PROFILES);
                    if (allowedAnonymous.contains(profileId)) {
                        aoResult.add(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED);
                    }
                    if ((deniedAnonymous = ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_DENIED_ANONYMOUS_PROFILES)).contains(profileId)) {
                        aoResult.add(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED);
                    }
                    if ((allowedAny = ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_ALLOWED_ANY_CONNECTED_PROFILES)).contains(profileId)) {
                        aoResult.add(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED);
                    }
                    if ((deniedAny = ACLJCRAmetysObjectHelper._getProperty(aclNode, __PROPERTY_NAME_DENIED_ANY_CONNECTED_PROFILES)).contains(profileId)) {
                        aoResult.add(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED);
                    }
                    if (aoResult.isEmpty()) continue;
                    AmetysObject ao = ACLJCRAmetysObjectHelper._getAmetysObjectFromACLNode(aclNode);
                    result.put(ao, aoResult);
                }
                catch (RepositoryException e) {
                    _logger.error("Failed to retrieve object for acl node " + aclNode.toString() + ". The node will be ignored.");
                }
            }
        }
        return result;
    }

    public static Map<Object, Map<GroupIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>> getProfilePermissionsForGroups(Set<? extends Object> rootNodes, String profileId) {
        OrExpression expr = new OrExpression(new AllowedProfileExpression(profileId), new DeniedProfileExpression(profileId));
        HashMap<Object, Map<GroupIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>> result = new HashMap<Object, Map<GroupIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>>();
        for (String rootPath : ACLJCRAmetysObjectHelper._convertNodeToPath(rootNodes)) {
            NodeIterator nodes = ACLJCRAmetysObjectHelper.getACLGroups(rootPath, expr);
            while (nodes.hasNext()) {
                Node groupNode = nodes.nextNode();
                try {
                    String groupId = Text.unescapeIllegalJcrChars((String)groupNode.getName());
                    String directoryId = groupNode.getParent().getName();
                    GroupIdentity currentGroup = new GroupIdentity(groupId, directoryId);
                    HashSet<ProfileAssignmentStorage.UserOrGroup> permission = new HashSet<ProfileAssignmentStorage.UserOrGroup>();
                    if (ACLJCRAmetysObjectHelper._getProperty(groupNode, __PROPERTY_NAME_DENIED_PROFILES).contains(profileId)) {
                        permission.add(ProfileAssignmentStorage.UserOrGroup.DENIED);
                    } else if (ACLJCRAmetysObjectHelper._getProperty(groupNode, __PROPERTY_NAME_ALLOWED_PROFILES).contains(profileId)) {
                        permission.add(ProfileAssignmentStorage.UserOrGroup.ALLOWED);
                    }
                    if (permission.isEmpty()) continue;
                    AmetysObject ao = ACLJCRAmetysObjectHelper._getAmetysObjectFromACLNode(groupNode);
                    Map objectPermissions = result.computeIfAbsent(ao, k -> new HashMap());
                    objectPermissions.put(currentGroup, permission);
                }
                catch (RepositoryException e) {
                    _logger.error("Failed to retrieve object for group acl node " + groupNode.toString() + ". The node will be ignored.");
                }
            }
        }
        return result;
    }

    public static Map<Object, Map<UserIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>> getProfilePermissionsForUsers(Set<? extends Object> rootNodes, String profileId) {
        OrExpression expr = new OrExpression(new AllowedProfileExpression(profileId), new DeniedProfileExpression(profileId));
        HashMap<Object, Map<UserIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>> result = new HashMap<Object, Map<UserIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>>();
        for (String rootPath : ACLJCRAmetysObjectHelper._convertNodeToPath(rootNodes)) {
            NodeIterator nodes = ACLJCRAmetysObjectHelper.getACLUsers(rootPath, expr);
            while (nodes.hasNext()) {
                Node userNode = nodes.nextNode();
                try {
                    String login = ISO9075.decode((String)userNode.getName());
                    String populationId = userNode.getParent().getName();
                    UserIdentity user = new UserIdentity(login, populationId);
                    HashSet<ProfileAssignmentStorage.UserOrGroup> permission = new HashSet<ProfileAssignmentStorage.UserOrGroup>();
                    if (ACLJCRAmetysObjectHelper._getProperty(userNode, __PROPERTY_NAME_DENIED_PROFILES).contains(profileId)) {
                        permission.add(ProfileAssignmentStorage.UserOrGroup.DENIED);
                    } else if (ACLJCRAmetysObjectHelper._getProperty(userNode, __PROPERTY_NAME_ALLOWED_PROFILES).contains(profileId)) {
                        permission.add(ProfileAssignmentStorage.UserOrGroup.ALLOWED);
                    }
                    if (permission.isEmpty()) continue;
                    AmetysObject ao = ACLJCRAmetysObjectHelper._getAmetysObjectFromACLNode(userNode);
                    Map objectPermissions = result.computeIfAbsent(ao, k -> new HashMap());
                    objectPermissions.put(user, permission);
                }
                catch (RepositoryException e) {
                    _logger.error("Failed to retrieve object for group acl node " + userNode.toString() + ". The node will be ignored.");
                }
            }
        }
        return result;
    }

    static {
        __ANONYMOUS_OR_ANYCONNECTEDUSER_NORIGHT = Map.of(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED, Set.of(), ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED, Set.of(), ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED, Set.of(), ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED, Set.of());
        __USER_OR_GROUP_NORIGHT = Map.of(ProfileAssignmentStorage.UserOrGroup.ALLOWED, Set.of(), ProfileAssignmentStorage.UserOrGroup.DENIED, Set.of());
    }

    static class AllowedProfileExpression
    extends ACLProfileExpression {
        public AllowedProfileExpression(String ... profileIds) {
            super(ACLJCRAmetysObjectHelper.__PROPERTY_NAME_ALLOWED_PROFILES, profileIds);
        }
    }

    static class AnyConnectedAllowedProfileExpression
    extends ACLProfileExpression {
        public AnyConnectedAllowedProfileExpression(String ... profileIds) {
            super(ACLJCRAmetysObjectHelper.__PROPERTY_NAME_ALLOWED_ANY_CONNECTED_PROFILES, profileIds);
        }
    }

    static class AnonymousAllowedProfileExpression
    extends ACLProfileExpression {
        public AnonymousAllowedProfileExpression(String ... profileIds) {
            super(ACLJCRAmetysObjectHelper.__PROPERTY_NAME_ALLOWED_ANONYMOUS_PROFILES, profileIds);
        }
    }

    static class DeniedProfileExpression
    extends ACLProfileExpression {
        public DeniedProfileExpression(String ... profileIds) {
            super(ACLJCRAmetysObjectHelper.__PROPERTY_NAME_DENIED_PROFILES, profileIds);
        }
    }

    static class AnonymousDeniedProfileExpression
    extends ACLProfileExpression {
        public AnonymousDeniedProfileExpression(String ... profileIds) {
            super(ACLJCRAmetysObjectHelper.__PROPERTY_NAME_DENIED_ANONYMOUS_PROFILES, profileIds);
        }
    }

    static class AnyConnectedDeniedProfileExpression
    extends ACLProfileExpression {
        public AnyConnectedDeniedProfileExpression(String ... profileIds) {
            super(ACLJCRAmetysObjectHelper.__PROPERTY_NAME_DENIED_ANY_CONNECTED_PROFILES, profileIds);
        }
    }

    static class ACLProfileExpression
    implements Expression {
        private String[] _profileIds;
        private String _propertyName;

        public ACLProfileExpression(String propertyName, String ... profileIds) {
            this._propertyName = propertyName;
            this._profileIds = profileIds;
        }

        @Override
        public String build() {
            boolean isFirst = true;
            StringBuilder sb = new StringBuilder("(");
            for (String profileId : this._profileIds) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(Expression.LogicalOperator.OR.toString());
                }
                sb.append("@").append(this._propertyName).append((Object)Expression.Operator.EQ).append("'").append(profileId).append("'");
            }
            if (isFirst) {
                return "";
            }
            return sb.append(")").toString();
        }
    }
}

