/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.jcr;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.ProfileAssignmentStorage;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableACLAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.ACLJCRAmetysObjectHelper;
import org.ametys.plugins.repository.jcr.DefaultAmetysObjectFactory;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.ametys.plugins.repository.version.ModifiableDataAwareVersionableAmetysObject;
import org.apache.jackrabbit.core.NodeImpl;

public class DefaultAmetysObject<F extends DefaultAmetysObjectFactory>
extends SimpleAmetysObject<F>
implements ModifiableDataAwareVersionableAmetysObject,
ModifiableACLAmetysObject {
    protected static final List<String> PROTECTED_PROPERTIES = Arrays.asList("jcr:uuid", "jcr:primaryType", "jcr:predecessors", "jcr:versionHistory", "jcr:baseVersion");
    protected static final Comparator<Map.Entry<String, Calendar>> __VERSION_COMPARATOR = Comparator.comparing(Map.Entry::getValue).thenComparing(Map.Entry::getKey);
    private Node _baseNode;
    private Version _versionNode;
    private Node _currentNode;
    private VersionHistory _versionHistory;

    public DefaultAmetysObject(Node node, String parentPath, F factory) {
        super(node, parentPath, factory);
        this._baseNode = node;
        this._currentNode = node;
    }

    @Override
    public Node getNode() {
        return this._currentNode;
    }

    public Node getBaseNode() {
        return this._baseNode;
    }

    protected VersionHistory getVersionHistory() throws RepositoryException {
        if (this._versionHistory == null) {
            this._versionHistory = this._baseNode.getSession().getWorkspace().getVersionManager().getVersionHistory(this._baseNode.getPath());
        }
        return this._versionHistory;
    }

    protected Version getBaseVersion() throws RepositoryException {
        return this._baseNode.getSession().getWorkspace().getVersionManager().getBaseVersion(this._baseNode.getPath());
    }

    @Override
    public void checkpoint() throws AmetysRepositoryException {
        try {
            this.getNode().getSession().getWorkspace().getVersionManager().checkpoint(this.getNode().getPath());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to checkpoint", e);
        }
    }

    @Override
    public void switchToLabel(String label) throws UnknownAmetysObjectException, AmetysRepositoryException {
        if (label == null) {
            this._versionNode = null;
            this._currentNode = this._baseNode;
        } else {
            try {
                VersionHistory history = this.getVersionHistory();
                this._versionNode = history.getVersionByLabel(label);
                this._currentNode = this._versionNode.getFrozenNode();
            }
            catch (VersionException e) {
                throw new UnknownAmetysObjectException("There's no label : " + label, e);
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException("Unable to switch to label : " + label, e);
            }
        }
    }

    @Override
    public void switchToRevision(String revision) throws UnknownAmetysObjectException, AmetysRepositoryException {
        if (revision == null) {
            this._versionNode = null;
            this._currentNode = this._baseNode;
        } else {
            try {
                VersionHistory history = this.getVersionHistory();
                this._versionNode = history.getVersion(revision);
                this._currentNode = this._versionNode.getNode("jcr:frozenNode");
            }
            catch (VersionException e) {
                throw new UnknownAmetysObjectException("There's no revision : " + revision, e);
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException("Unable to switch to revision : " + revision, e);
            }
        }
    }

    @Override
    public void restoreFromLabel(String label) throws UnknownAmetysObjectException, AmetysRepositoryException {
        try {
            VersionHistory history = this.getVersionHistory();
            Version versionNode = history.getVersionByLabel(label);
            this.restoreFromNode(versionNode.getNode("jcr:frozenNode"));
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to restore from label: " + label, e);
        }
    }

    @Override
    public void restoreFromRevision(String revision) throws UnknownAmetysObjectException, AmetysRepositoryException {
        try {
            VersionHistory history = this.getVersionHistory();
            Version versionNode = history.getVersion(revision);
            this.restoreFromNode(versionNode.getNode("jcr:frozenNode"));
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to restore from revision: " + revision, e);
        }
    }

    protected void restoreFromNode(Node node) throws RepositoryException {
        PropertyIterator propIt = this._baseNode.getProperties();
        while (propIt.hasNext()) {
            Property prop = propIt.nextProperty();
            String propName = prop.getName();
            if (propName.startsWith("jcr:") || prop.getDefinition().getOnParentVersion() == 5) continue;
            prop.remove();
        }
        NodeIterator nodeIt = this._baseNode.getNodes();
        while (nodeIt.hasNext()) {
            Node childNode = nodeIt.nextNode();
            String nodeName = childNode.getName();
            if (nodeName.startsWith("jcr:") || childNode.getDefinition().getOnParentVersion() == 5) continue;
            childNode.remove();
        }
        PropertyIterator newPropIt = node.getProperties();
        while (newPropIt.hasNext()) {
            Property newProp = newPropIt.nextProperty();
            if (newProp.getName().startsWith("jcr:")) continue;
            if (newProp.getDefinition().isMultiple()) {
                this._baseNode.setProperty(newProp.getName(), newProp.getValues(), newProp.getType());
                continue;
            }
            this._baseNode.setProperty(newProp.getName(), newProp.getValue(), newProp.getType());
        }
        NodeIterator newNodeIt = node.getNodes();
        while (newNodeIt.hasNext()) {
            Node newNode = newNodeIt.nextNode();
            if (newNode.getName().startsWith("jcr:")) continue;
            this.copyNode(this._baseNode, newNode);
        }
    }

    protected void copyNode(Node parentDest, Node src) throws RepositoryException {
        Node dest;
        if (parentDest.hasNode(src.getName())) {
            dest = parentDest.getNode(src.getName());
        } else {
            String uuid = null;
            if (src.hasProperty("jcr:frozenUuid")) {
                uuid = src.getProperty("jcr:frozenUuid").getString();
            }
            dest = uuid == null ? parentDest.addNode(src.getName(), src.getProperty("jcr:frozenPrimaryType").getString()) : ((NodeImpl)parentDest).addNodeWithUuid(src.getName(), src.getProperty("jcr:frozenPrimaryType").getString(), uuid);
        }
        PropertyIterator pit = src.getProperties();
        while (pit.hasNext()) {
            Property p = pit.nextProperty();
            String name = p.getName();
            if (PROTECTED_PROPERTIES.contains(name) || name.startsWith("jcr:frozen") || dest.hasProperty(name)) continue;
            if (p.getDefinition().isMultiple()) {
                dest.setProperty(name, p.getValues());
                continue;
            }
            dest.setProperty(name, p.getValue());
        }
        NodeIterator nit = src.getNodes();
        while (nit.hasNext()) {
            this.copyNode(dest, nit.nextNode());
        }
    }

    @Override
    public void addLabel(String label, boolean moveIfPresent) throws AmetysRepositoryException {
        try {
            VersionHistory history = this.getVersionHistory();
            String versionName = this._versionNode == null ? this.getBaseVersion().getName() : this._versionNode.getName();
            history.addVersionLabel(versionName, label, moveIfPresent);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to add label : " + label, e);
        }
    }

    @Override
    public void removeLabel(String label) throws AmetysRepositoryException {
        try {
            VersionHistory history = this.getVersionHistory();
            history.removeVersionLabel(label);
        }
        catch (RepositoryException ex) {
            throw new AmetysRepositoryException("Unable to remove label : " + label, ex);
        }
    }

    @Override
    public String[] getAllLabels() throws AmetysRepositoryException {
        try {
            return this.getVersionHistory().getVersionLabels();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to retrieve list of labels", e);
        }
    }

    @Override
    public String[] getLabels() throws AmetysRepositoryException {
        try {
            Version version = this._versionNode;
            if (version == null) {
                version = this.getBaseVersion();
            }
            return version.getContainingHistory().getVersionLabels(version);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to retrieve list of labels for current version", e);
        }
    }

    @Override
    public String[] getLabels(String revision) throws UnknownAmetysObjectException, AmetysRepositoryException {
        try {
            VersionHistory history = this.getVersionHistory();
            Version version = history.getVersion(revision);
            return history.getVersionLabels(version);
        }
        catch (VersionException e) {
            throw new UnknownAmetysObjectException("There's no revision " + revision, e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to retrieve list of labels for current version", e);
        }
    }

    @Override
    public String getRevision() throws AmetysRepositoryException {
        if (this._versionNode == null) {
            return null;
        }
        try {
            return this._versionNode.getName();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get revision", e);
        }
    }

    @Override
    public Date getRevisionTimestamp() throws AmetysRepositoryException {
        if (this._versionNode == null) {
            return null;
        }
        try {
            return this._versionNode.getCreated().getTime();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get revision date", e);
        }
    }

    @Override
    public Date getRevisionTimestamp(String revision) throws UnknownAmetysObjectException, AmetysRepositoryException {
        try {
            VersionHistory history = this.getVersionHistory();
            Version version = history.getVersion(revision);
            return version.getCreated().getTime();
        }
        catch (VersionException e) {
            throw new UnknownAmetysObjectException("There's no revision " + revision, e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get revision date", e);
        }
    }

    @Override
    public String[] getAllRevisions() throws AmetysRepositoryException {
        try {
            HashMap<String, Calendar> revisions = new HashMap<String, Calendar>();
            VersionIterator iterator = this.getVersionHistory().getAllVersions();
            while (iterator.hasNext()) {
                Version version = iterator.nextVersion();
                String name = version.getName();
                if ("jcr:rootVersion".equals(name)) continue;
                revisions.put(name, version.getCreated());
            }
            return (String[])revisions.entrySet().stream().sorted(__VERSION_COMPARATOR).map(Map.Entry::getKey).toArray(String[]::new);
        }
        catch (RepositoryException ex) {
            throw new AmetysRepositoryException("Unable to get revisions list", ex);
        }
    }

    @Override
    public ModifiableModelLessDataHolder getUnversionedDataHolder() {
        try {
            JCRRepositoryData repositoryData = new JCRRepositoryData(this._baseNode.getNode("ametys-internal:unversioned"));
            Optional<LockableAmetysObject> lockableAmetysObject = Optional.of(this).filter(LockableAmetysObject.class::isInstance).map(LockableAmetysObject.class::cast);
            return new DefaultModifiableModelLessDataHolder(((DefaultAmetysObjectFactory)this._getFactory()).getUnversionedDataTypeExtensionPoint(), repositoryData, lockableAmetysObject);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> getProfilesForAnonymousAndAnyConnectedUser() {
        return ACLJCRAmetysObjectHelper.getProfilesForAnonymousAndAnyConnectedUser(this.getNode());
    }

    @Override
    public Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getProfilesForGroups(Set<GroupIdentity> groups) {
        return ACLJCRAmetysObjectHelper.getProfilesForGroups(this.getNode(), groups);
    }

    @Override
    public Map<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getProfilesForUsers(UserIdentity user) {
        return ACLJCRAmetysObjectHelper.getProfilesForUsers(this.getNode(), user);
    }

    @Override
    public void addAllowedProfilesForAnyConnectedUser(Set<String> profileIds) {
        ACLJCRAmetysObjectHelper.addAllowedProfilesForAnyConnectedUser(this.getNode(), profileIds);
    }

    @Override
    public void removeAllowedProfilesForAnyConnectedUser(Set<String> profileIds) {
        ACLJCRAmetysObjectHelper.removeAllowedProfilesForAnyConnectedUser(this.getNode(), profileIds);
    }

    @Override
    public void addDeniedProfilesForAnyConnectedUser(Set<String> profileIds) {
        ACLJCRAmetysObjectHelper.addDeniedProfilesForAnyConnectedUser(this.getNode(), profileIds);
    }

    @Override
    public void removeDeniedProfilesForAnyConnectedUser(Set<String> profileIds) {
        ACLJCRAmetysObjectHelper.removeDeniedProfilesForAnyConnectedUser(this.getNode(), profileIds);
    }

    @Override
    public void addAllowedProfilesForAnonymous(Set<String> profileIds) {
        ACLJCRAmetysObjectHelper.addAllowedProfilesForAnonymous(this.getNode(), profileIds);
    }

    @Override
    public void removeAllowedProfilesForAnonymous(Set<String> profileIds) {
        ACLJCRAmetysObjectHelper.removeAllowedProfilesForAnonymous(this.getNode(), profileIds);
    }

    @Override
    public void addDeniedProfilesForAnonymous(Set<String> profileIds) {
        ACLJCRAmetysObjectHelper.addDeniedProfilesForAnonymous(this.getNode(), profileIds);
    }

    @Override
    public void removeDeniedProfilesForAnonymous(Set<String> profileIds) {
        ACLJCRAmetysObjectHelper.removeDeniedProfilesForAnonymous(this.getNode(), profileIds);
    }

    @Override
    public void addAllowedUsers(Set<UserIdentity> users, String profileId) {
        ACLJCRAmetysObjectHelper.addAllowedUsers(users, this.getNode(), profileId);
    }

    @Override
    public void removeAllowedUsers(Set<UserIdentity> users, String profileId) {
        ACLJCRAmetysObjectHelper.removeAllowedUsers(users, this.getNode(), profileId);
    }

    @Override
    public void removeAllowedUsers(Set<UserIdentity> users) {
        ACLJCRAmetysObjectHelper.removeAllowedUsers(users, this.getNode());
    }

    @Override
    public void addAllowedGroups(Set<GroupIdentity> groups, String profileId) {
        ACLJCRAmetysObjectHelper.addAllowedGroups(groups, this.getNode(), profileId);
    }

    @Override
    public void removeAllowedGroups(Set<GroupIdentity> groups, String profileId) {
        ACLJCRAmetysObjectHelper.removeAllowedGroups(groups, this.getNode(), profileId);
    }

    @Override
    public void removeAllowedGroups(Set<GroupIdentity> groups) {
        ACLJCRAmetysObjectHelper.removeAllowedGroups(groups, this.getNode());
    }

    @Override
    public void addDeniedUsers(Set<UserIdentity> users, String profileId) {
        ACLJCRAmetysObjectHelper.addDeniedUsers(users, this.getNode(), profileId);
    }

    @Override
    public void removeDeniedUsers(Set<UserIdentity> users, String profileId) {
        ACLJCRAmetysObjectHelper.removeDeniedUsers(users, this.getNode(), profileId);
    }

    @Override
    public void removeDeniedUsers(Set<UserIdentity> users) {
        ACLJCRAmetysObjectHelper.removeDeniedUsers(users, this.getNode());
    }

    @Override
    public void addDeniedGroups(Set<GroupIdentity> groups, String profileId) {
        ACLJCRAmetysObjectHelper.addDeniedGroups(groups, this.getNode(), profileId);
    }

    @Override
    public void removeDeniedGroups(Set<GroupIdentity> groups, String profileId) {
        ACLJCRAmetysObjectHelper.removeDeniedGroups(groups, this.getNode(), profileId);
    }

    @Override
    public void removeDeniedGroups(Set<GroupIdentity> groups) {
        ACLJCRAmetysObjectHelper.removeDeniedGroups(groups, this.getNode());
    }

    @Override
    public boolean isInheritanceDisallowed() {
        return ACLJCRAmetysObjectHelper.isInheritanceDisallowed(this.getNode());
    }

    @Override
    public void disallowInheritance(boolean disallow) {
        ACLJCRAmetysObjectHelper.disallowInheritance(this.getNode(), disallow);
    }
}

