/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.jcr;

import javax.management.MBeanAttributeInfo;
import org.ametys.core.mbean.AbstractAmetysDynamicMBean;
import org.ametys.plugins.repository.provider.JackrabbitRepository;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;

public class JackrabbitMBean
extends AbstractAmetysDynamicMBean
implements Serviceable {
    public static final String ROLE = JackrabbitMBean.class.getName();
    private JackrabbitRepository _jackRepo;

    public void service(ServiceManager manager) throws ServiceException {
        this._jackRepo = (JackrabbitRepository)manager.lookup("javax.jcr.Repository");
    }

    protected Object _getAttribute(String attributeName) {
        if (attributeName.equals("QueryCount")) {
            return this._jackRepo.getRepositoryStatistics().getTimeSeries(RepositoryStatistics.Type.QUERY_COUNT).getValuePerMinute()[0];
        }
        if (attributeName.equals("QueryAverageDuration")) {
            return this._jackRepo.getRepositoryStatistics().getTimeSeries(RepositoryStatistics.Type.QUERY_AVERAGE).getValuePerMinute()[0];
        }
        if (attributeName.equals("QueryTotalDuration")) {
            return this._jackRepo.getRepositoryStatistics().getTimeSeries(RepositoryStatistics.Type.QUERY_DURATION).getValuePerMinute()[0];
        }
        if (attributeName.equals("SessionCount")) {
            return this._jackRepo.getRepositoryStatistics().getTimeSeries(RepositoryStatistics.Type.SESSION_COUNT).getValuePerMinute()[0];
        }
        return null;
    }

    protected String getMBeanName() {
        return StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)ROLE, (String)"."), (String)"MBean");
    }

    protected String getMBeanDescription() {
        return "JackRabbit performance information";
    }

    protected MBeanAttributeInfo[] getMBeanAttributes() {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("QueryCount", "Long", "Number of queries executed the last minute", true, false, false), new MBeanAttributeInfo("QueryTotalDuration", "Long", "Total time spent evaluating queries in milli seconds the last minute", true, false, false), new MBeanAttributeInfo("QueryAverageDuration", "Long", "Average time spent evaluating queries in milli seconds the last minute", true, false, false), new MBeanAttributeInfo("SessionCount", "Long", "Number of currently logged in sessions the last minute", true, false, false)};
        return attributes;
    }
}

