/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.jcr;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.DefaultAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.lock.UnlockHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class LockComponent
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = LockComponent.class.getName();
    protected UnlockHelper _unlockHelper;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._unlockHelper = (UnlockHelper)((Object)manager.lookup(UnlockHelper.ROLE));
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public void addLockedContent(AmetysObject object) {
        this._unlockHelper.scheduleUnlocking(object);
    }

    public void removeLockedContent(AmetysObject object) {
        this._unlockHelper.cancelUnlocking(object);
    }

    public UserIdentity getCurrentUser() {
        return this._currentUserProvider.getUser();
    }

    public void lock(JCRAmetysObject object) throws AmetysRepositoryException {
        try {
            Node node = this.getNode(object);
            if (!node.isCheckedOut()) {
                throw new AmetysRepositoryException("Unable to lock a checked-in Node");
            }
            LockManager lockManager = node.getSession().getWorkspace().getLockManager();
            Lock lock = lockManager.lock(node.getPath(), false, false, Long.MAX_VALUE, null);
            node.setProperty("ametys-internal:lockToken", lock.getLockToken());
            UserIdentity currentUser = this.getCurrentUser();
            if (currentUser != null) {
                node.setProperty("ametys-internal:lockOwner", UserIdentity.userIdentityToString((UserIdentity)currentUser));
            }
            node.getSession().save();
            lockManager.removeLockToken(lock.getLockToken());
            this.addLockedContent(object);
        }
        catch (RepositoryException ex) {
            throw new AmetysRepositoryException("Unable to lock object " + String.valueOf(object), ex);
        }
    }

    public void unlock(JCRAmetysObject object) throws AmetysRepositoryException {
        try {
            Node node = this.getNode(object);
            LockManager lockManager = node.getSession().getWorkspace().getLockManager();
            Lock lock = lockManager.getLock(node.getPath());
            Node lockHolder = lock.getNode();
            String lockToken = lockHolder.getProperty("ametys-internal:lockToken").getString();
            lockManager.addLockToken(lockToken);
            lockManager.unlock(node.getPath());
            node.setProperty("ametys-internal:lockToken", (Value)null);
            node.setProperty("ametys-internal:lockOwner", (Value)null);
            node.getSession().save();
            this.removeLockedContent(object);
        }
        catch (RepositoryException ex) {
            throw new AmetysRepositoryException("Unable to unlock object " + String.valueOf(object), ex);
        }
    }

    public void setLockTokenOnCurrentSession(JCRAmetysObject object) throws AmetysRepositoryException {
        try {
            Node node = this.getNode(object);
            if (node.isLocked()) {
                LockManager lockManager = node.getSession().getWorkspace().getLockManager();
                Lock lock = lockManager.getLock(node.getPath());
                Node lockHolder = lock.getNode();
                String lockToken = lockHolder.getProperty("ametys-internal:lockToken").getString();
                lockManager.addLockToken(lockToken);
            }
        }
        catch (RepositoryException ex) {
            throw new AmetysRepositoryException("Unable to add the lock token on object " + String.valueOf(object), ex);
        }
    }

    public boolean isLocked(JCRAmetysObject object) throws AmetysRepositoryException {
        try {
            return this.getNode(object).isLocked();
        }
        catch (RepositoryException ex) {
            throw new AmetysRepositoryException("Unable to get lock status on object " + String.valueOf(object), ex);
        }
    }

    public UserIdentity getLockOwner(JCRAmetysObject object) throws AmetysRepositoryException {
        try {
            String userIdentity = this.getNode(object).getProperty("ametys-internal:lockOwner").getString();
            return UserIdentity.stringToUserIdentity((String)userIdentity);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException ex) {
            throw new AmetysRepositoryException("Unable to get lock owner on object " + String.valueOf(object), ex);
        }
    }

    protected Node getNode(JCRAmetysObject object) {
        Node node;
        if (object instanceof DefaultAmetysObject) {
            DefaultAmetysObject defaultAmetysObject = (DefaultAmetysObject)object;
            node = defaultAmetysObject.getBaseNode();
        } else {
            node = object.getNode();
        }
        return node;
    }
}

