/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.jcr;

import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;

public final class NameHelper {
    private static final Pattern __NODE_NAME_PATTERN = Pattern.compile("^([0-9-_]*)[a-z].*$");
    private static final Pattern __NAME_GENERATED_KEY_PATTERN = Pattern.compile("^(.+?)(?:-[0-9a-z]{8})?$");
    private static final Pattern __NAME_INCREMENTAL_PATTERN = Pattern.compile("^(.+?)(?:-[0-9]+)?$");
    private static final Pattern __NAME_USER_FRIENDLY_PATTERN = Pattern.compile("^(.+?)(?: \\([0-9]+\\))?$");

    private NameHelper() {
    }

    public static String filterName(String name) {
        String filteredName = Normalizer.normalize(name.toLowerCase(), Normalizer.Form.NFD).replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").trim();
        Matcher m = __NODE_NAME_PATTERN.matcher(filteredName = filteredName.replaceAll("\u0153", "oe").replaceAll("\u00e6", "ae").replaceAll(" +", "-").replaceAll("[^\\w-]", "-").replaceAll("-+", "-"));
        if (!m.matches()) {
            throw new IllegalArgumentException(filteredName + " doesn't match the expected regular expression : " + __NODE_NAME_PATTERN.pattern());
        }
        filteredName = filteredName.substring(m.end(1));
        return StringUtils.strip((String)filteredName, (String)"-_");
    }

    public static String getUniqueAmetysObjectName(TraversableAmetysObject parent, String baseName) {
        return NameHelper.getUniqueAmetysObjectName(parent, baseName, NameComputationMode.INCREMENTAL, false);
    }

    public static String getUniqueAmetysObjectName(TraversableAmetysObject parent, String baseName, NameComputationMode computationMode, boolean mayBeSuffixed) {
        switch (computationMode.ordinal()) {
            case 1: {
                return NameHelper._getUniqueAmetysObjectNameGeneratedKey(parent, baseName, mayBeSuffixed);
            }
            case 2: {
                return NameHelper._getUniqueAmetysObjectNameUserFriendly(parent, Text.escapeIllegalJcrChars((String)baseName), mayBeSuffixed);
            }
        }
        return NameHelper._getUniqueAmetysObjectNameIncremental(parent, baseName, mayBeSuffixed);
    }

    private static String _getUniqueAmetysObjectNameIncremental(TraversableAmetysObject parent, String baseName, boolean mayBeSuffixed) {
        String uniqueName;
        String filteredName = NameHelper.filterName(baseName);
        if (!parent.hasChild(filteredName)) {
            return filteredName;
        }
        String realBaseName = NameHelper._getRealBaseName(baseName, __NAME_INCREMENTAL_PATTERN, mayBeSuffixed);
        long index = 2L;
        while (parent.hasChild(uniqueName = realBaseName + index++)) {
        }
        return uniqueName;
    }

    private static String _getUniqueAmetysObjectNameGeneratedKey(TraversableAmetysObject parent, String baseName, boolean mayBeSuffixed) {
        String uniqueName;
        String filteredName = NameHelper.filterName(baseName);
        if (!parent.hasChild(filteredName)) {
            return filteredName;
        }
        String realBaseName = NameHelper._getRealBaseName(baseName, __NAME_GENERATED_KEY_PATTERN, mayBeSuffixed);
        while (parent.hasChild(uniqueName = realBaseName + org.ametys.core.util.StringUtils.generateKey().toLowerCase())) {
        }
        return uniqueName;
    }

    private static String _getUniqueAmetysObjectNameUserFriendly(TraversableAmetysObject parent, String baseName, boolean mayBeSuffixed) {
        String uniqueName;
        if (!parent.hasChild(baseName)) {
            return baseName;
        }
        Object realBaseName = baseName;
        if (mayBeSuffixed) {
            Matcher m = __NAME_USER_FRIENDLY_PATTERN.matcher(baseName);
            m.matches();
            realBaseName = m.group(1);
        }
        realBaseName = (String)realBaseName + " (${number})";
        Long index = 2L;
        do {
            uniqueName = ((String)realBaseName).replaceFirst("\\$\\{number\\}", index.toString());
            Long l = index;
            index = index + 1L;
        } while (parent.hasChild(uniqueName));
        return uniqueName;
    }

    private static String _getRealBaseName(String baseName, Pattern pattern, boolean mayBeSuffixed) {
        if (!mayBeSuffixed) {
            return NameHelper.filterName(baseName) + "-";
        }
        Matcher m = pattern.matcher(baseName);
        m.matches();
        return NameHelper.filterName(m.group(1)) + "-";
    }

    public static enum NameComputationMode {
        INCREMENTAL,
        GENERATED_KEY,
        USER_FRIENDLY;

    }
}

