/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.apache.cocoon.util.HashUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.core.NodeImpl;

public final class NodeHelper {
    private NodeHelper() {
    }

    public static void rename(Node node, String newName) throws AmetysRepositoryException {
        try {
            Node parentNode = node.getParent();
            boolean order = parentNode.getPrimaryNodeType().hasOrderableChildNodes();
            Node nextSibling = null;
            if (order) {
                Node sibling;
                NodeIterator siblings = parentNode.getNodes();
                boolean iterate = true;
                while (siblings.hasNext() && iterate) {
                    sibling = siblings.nextNode();
                    iterate = !sibling.getName().equals(node.getName());
                }
                while (siblings.hasNext() && nextSibling == null) {
                    sibling = siblings.nextNode();
                    String path = sibling.getPath();
                    if (!node.getSession().itemExists(path)) continue;
                    nextSibling = sibling;
                }
            }
            node.getSession().move(node.getPath(), node.getParent().getPath() + "/" + newName);
            if (order) {
                if (nextSibling != null) {
                    parentNode.orderBefore(newName, nextSibling.getName());
                } else {
                    parentNode.orderBefore(newName, null);
                }
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    public static Node cloneNode(Node nodeToCopy, Node parentNode) throws AmetysRepositoryException {
        try {
            return NodeHelper.cloneNode(nodeToCopy, parentNode, nodeToCopy.getName());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    public static Node cloneNode(Node nodeToCopy, Node parentNode, String nodeName) throws AmetysRepositoryException {
        try {
            Node destNode = nodeToCopy.isNodeType("mix:referenceable") ? ((NodeImpl)parentNode).addNodeWithUuid(nodeName, nodeToCopy.getPrimaryNodeType().getName(), nodeToCopy.getIdentifier()) : parentNode.addNode(nodeName, nodeToCopy.getPrimaryNodeType().getName());
            PropertyIterator properties = nodeToCopy.getProperties();
            while (properties.hasNext()) {
                Property property = properties.nextProperty();
                if (property.getDefinition().isProtected()) continue;
                if (property.isMultiple()) {
                    destNode.setProperty(property.getName(), property.getValues(), property.getType());
                    continue;
                }
                destNode.setProperty(property.getName(), property.getValue(), property.getType());
            }
            NodeIterator subNodes = nodeToCopy.getNodes();
            while (subNodes.hasNext()) {
                Node subNode = subNodes.nextNode();
                if (subNode.getDefinition().isAutoCreated()) {
                    destNode.getNode(subNode.getName()).remove();
                }
                NodeHelper.cloneNode(subNode, destNode);
            }
            return destNode;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    public static List<String> hashAsList(String name) {
        long hash = Math.abs(HashUtil.hash((String)name));
        String hashStr = Long.toString(hash, 16);
        hashStr = StringUtils.leftPad((String)hashStr, (int)4, (char)'0');
        return List.of(hashStr.substring(0, 2), hashStr.substring(2, 4));
    }

    public static String getFullHashPath(String name) {
        ArrayList<String> pathList = new ArrayList<String>(NodeHelper.hashAsList(name));
        pathList.add(name);
        return StringUtils.join(pathList, (String)"/");
    }

    public static Node getOrCreateFinalHashNode(Node parentNode, String name) throws AmetysRepositoryException {
        return NodeHelper.getOrCreateFinalHashNode(parentNode, name, "ametys:collectionElement");
    }

    public static Node getOrCreateFinalHashNode(Node parentNode, String name, String hashType) throws AmetysRepositoryException {
        try {
            Node finalNode = parentNode;
            for (String hashPart : NodeHelper.hashAsList(name)) {
                finalNode = finalNode.hasNode(hashPart) ? finalNode.getNode(hashPart) : finalNode.addNode(hashPart, hashType);
            }
            return finalNode;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }
}

