/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

public final class NodeTypeHelper {
    private NodeTypeHelper() {
    }

    public static String getNodeTypeName(Node node) throws RepositoryException {
        String nodeTypeName;
        String realNodeTypeName = nodeTypeName = node.getPrimaryNodeType().getName();
        if ("nt:frozenNode".equals(nodeTypeName)) {
            realNodeTypeName = node.getProperty("jcr:frozenPrimaryType").getString();
        }
        return realNodeTypeName;
    }

    public static boolean isNodeType(Node node, String nodeTypeName) throws RepositoryException {
        if (node.isNodeType(nodeTypeName)) {
            return true;
        }
        String theNodeTypeName = node.getPrimaryNodeType().getName();
        if ("nt:frozenNode".equals(theNodeTypeName)) {
            String realNodeTypeName = node.getProperty("jcr:frozenPrimaryType").getString();
            return nodeTypeName.equals(realNodeTypeName);
        }
        return false;
    }
}

