/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.ametys.plugins.repository.AbstractAmetysObject;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryIntegrityViolationException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.NodeHelper;
import org.ametys.plugins.repository.jcr.SimpleAmetysObjectFactory;
import org.ametys.plugins.repository.metadata.ModifiableCompositeMetadata;
import org.ametys.plugins.repository.metadata.jcr.JCRCompositeMetadata;
import org.apache.jackrabbit.util.Text;

public class SimpleAmetysObject<F extends SimpleAmetysObjectFactory>
extends AbstractAmetysObject
implements JCRAmetysObject {
    private F _factory;
    private Node _node;
    private String _name;
    private String _parentPath;

    public SimpleAmetysObject(Node node, String parentPath, F factory) {
        this._node = node;
        this._parentPath = parentPath;
        this._factory = factory;
        try {
            this._name = Text.unescapeIllegalJcrChars((String)this._node.getName());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get node name", e);
        }
    }

    protected F _getFactory() {
        return this._factory;
    }

    @Override
    public String getName() throws AmetysRepositoryException {
        return this._name;
    }

    @Override
    @Deprecated
    public ModifiableCompositeMetadata getMetadataHolder() {
        return new JCRCompositeMetadata(this.getNode(), ((SimpleAmetysObjectFactory)this._getFactory())._getResolver());
    }

    @Override
    public String getParentPath() throws AmetysRepositoryException {
        if (this._parentPath == null) {
            this._parentPath = this.getParent().getPath();
        }
        return this._parentPath;
    }

    protected void _invalidateParentPath() {
        this._parentPath = null;
    }

    protected void _invalidateName() {
        try {
            this._name = Text.unescapeIllegalJcrChars((String)this.getNode().getName());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public String getPath() throws AmetysRepositoryException {
        return this.getParentPath() + "/" + this.getName();
    }

    @Override
    public Node getNode() {
        return this._node;
    }

    @Override
    public String getId() {
        try {
            return ((SimpleAmetysObjectFactory)this._factory).getScheme() + "://" + this._node.getIdentifier();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get node UUID", e);
        }
    }

    @Override
    public void rename(String newName) throws AmetysRepositoryException {
        try {
            NodeHelper.rename(this.getNode(), newName);
            this._name = Text.unescapeIllegalJcrChars((String)this.getNode().getName());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public void remove() throws AmetysRepositoryException, RepositoryIntegrityViolationException {
        try {
            this.getNode().remove();
        }
        catch (ConstraintViolationException e) {
            throw new RepositoryIntegrityViolationException(e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public <A extends AmetysObject> A getParent() throws AmetysRepositoryException {
        return (A)((SimpleAmetysObjectFactory)this._factory).getParent(this);
    }

    @Override
    public boolean needsSave() throws AmetysRepositoryException {
        try {
            return this._node.getSession().hasPendingChanges();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public void saveChanges() throws AmetysRepositoryException {
        try {
            this.getNode().getSession().save();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to save changes", e);
        }
    }

    @Override
    public void revertChanges() throws AmetysRepositoryException {
        try {
            this.getNode().refresh(false);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to revert changes.", e);
        }
    }
}

