/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.jcr;

import java.util.Collection;
import java.util.Collections;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectFactoryExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObjectFactory;
import org.ametys.plugins.repository.jcr.NodeTypeHelper;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class SimpleAmetysObjectFactory
extends AbstractLogEnabled
implements JCRAmetysObjectFactory<SimpleAmetysObject>,
Configurable,
Serviceable {
    protected AmetysObjectResolver _resolver;
    protected AmetysObjectFactoryExtensionPoint _ametysFactoryExtensionPoint;
    protected String _scheme;
    protected String _nodetype;
    protected Repository _repository;
    protected ServiceManager _manager;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._resolver = (AmetysObjectResolver)((Object)manager.lookup(AmetysObjectResolver.ROLE));
        this._repository = (Repository)manager.lookup("javax.jcr.Repository");
        this._ametysFactoryExtensionPoint = (AmetysObjectFactoryExtensionPoint)((Object)manager.lookup(AmetysObjectFactoryExtensionPoint.ROLE));
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._scheme = configuration.getChild("scheme").getValue();
        Configuration[] nodetypesConf = configuration.getChildren("nodetype");
        if (nodetypesConf.length != 1) {
            throw new ConfigurationException("A SimpleAmetysObjectFactory must have one and only one associated nodetype. The '" + configuration.getAttribute("id") + "' component has " + nodetypesConf.length);
        }
        this._nodetype = nodetypesConf[0].getValue();
    }

    AmetysObjectResolver _getResolver() {
        return this._resolver;
    }

    @Override
    public String getScheme() {
        return this._scheme;
    }

    @Override
    public Collection<String> getNodetypes() {
        return Collections.singletonList(this._nodetype);
    }

    @Override
    public SimpleAmetysObject getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException, RepositoryException {
        return new SimpleAmetysObject<SimpleAmetysObjectFactory>(node, parentPath, this);
    }

    @Override
    public SimpleAmetysObject getAmetysObjectById(String id) throws AmetysRepositoryException {
        try {
            return this.getAmetysObjectById(id, null);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get AmetysObject for id: " + id, e);
        }
    }

    @Override
    public SimpleAmetysObject getAmetysObjectById(String id, Session session) throws AmetysRepositoryException, RepositoryException {
        Node node = this.getNode(id, session);
        if (!node.getPath().startsWith("/ametys:root")) {
            throw new AmetysRepositoryException("Cannot resolve a Node outside Ametys tree");
        }
        return this.getAmetysObject(node, null);
    }

    @Override
    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        try {
            this.getNode(id, null);
            return true;
        }
        catch (UnknownAmetysObjectException e) {
            return false;
        }
    }

    protected Node getNode(String id, Session session) {
        String uuid = id.substring(this.getScheme().length() + 3);
        Session jcrSession = null;
        try {
            jcrSession = session != null ? session : this._repository.login();
            Node node = jcrSession.getNodeByIdentifier(uuid);
            return node;
        }
        catch (ItemNotFoundException e) {
            if (session == null && jcrSession != null) {
                jcrSession.logout();
            }
            throw new UnknownAmetysObjectException("There's no node for id " + id, e);
        }
        catch (RepositoryException e) {
            if (session == null && jcrSession != null) {
                jcrSession.logout();
            }
            throw new AmetysRepositoryException("Unable to get AmetysObject for id: " + id, e);
        }
    }

    public AmetysObject getParent(SimpleAmetysObject object) throws AmetysRepositoryException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Entering DefaultTraversableAmetysObjectFactory.getParent with object of name: " + object.getName());
        }
        Node node = this.getWorkspaceNode(object);
        try {
            Node parentNode = node.getParent();
            String parentNodetype = NodeTypeHelper.getNodeTypeName(parentNode);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Parent nodetype is " + parentNodetype);
            }
            if (parentNodetype.equals(this._nodetype)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("The parent node has the same nodetype than this ObjectFactory: " + this._nodetype);
                }
                return this.getAmetysObject(parentNode, null);
            }
            return this._resolver.resolve(parentNode, false);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to retrieve parent object of object " + object.getName(), e);
        }
    }

    protected Node getWorkspaceNode(SimpleAmetysObject object) {
        return object.getNode();
    }
}

