/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.jcr;

import java.util.ArrayList;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.NodeType;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysObjectFactoryExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ChainedAmetysObjectIterable;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.RepositoryIntegrityViolationException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObjectFactory;
import org.ametys.plugins.repository.jcr.JCRTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.NodeTypeHelper;
import org.ametys.plugins.repository.virtual.VirtualAmetysObjectFactory;
import org.apache.avalon.framework.logger.Logger;
import org.apache.jackrabbit.util.Text;

public final class TraversableAmetysObjectHelper {
    private TraversableAmetysObjectHelper() {
    }

    public static <A extends AmetysObject> A getChild(JCRTraversableAmetysObject object, JCRAmetysObjectFactory factory, String path, AmetysObjectResolver resolver, Logger logger) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (logger.isDebugEnabled()) {
            logger.debug("Entering DefaultTraversableAmetysObjectFactory.getChild with path=" + path + ", object=" + String.valueOf(object));
        }
        if (path == null || "".equals(path) || path.charAt(0) == '/') {
            throw new AmetysRepositoryException("Child path cannot be null, empty or absolute");
        }
        Node node = object.getNode();
        try {
            String[] pathElements = path.split("/");
            Node contextNode = node;
            Object contextPath = object.getPath();
            String contextParentPath = null;
            for (int i = 0; i < pathElements.length; ++i) {
                if (logger.isDebugEnabled()) {
                    logger.debug("contextPath=" + (String)contextPath + ", pathElement=" + pathElements[i]);
                }
                if (".".equals(pathElements[i]) || "..".equals(pathElements[i])) {
                    throw new AmetysRepositoryException("Path cannot contain segment with . or ..");
                }
                String jcrName = TraversableAmetysObjectHelper._escape(pathElements[i]);
                if (contextNode.hasNode(jcrName)) {
                    Node subNode = contextNode.getNode(jcrName);
                    String type = NodeTypeHelper.getNodeTypeName(subNode);
                    if (factory.getNodetypes().contains(type)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("The nodetype is the same as the current factory, no need to go through resolver: " + type);
                        }
                        contextParentPath = contextPath;
                        contextPath = (String)contextPath + "/" + subNode.getName();
                        contextNode = subNode;
                        continue;
                    }
                    return resolver.resolve((String)contextPath, subNode, TraversableAmetysObjectHelper._computeSubPath(pathElements, i + 1), false);
                }
                if (contextNode.hasProperty("ametys-internal:virtual")) {
                    JCRAmetysObject contextObject = (JCRAmetysObject)resolver.resolve(contextParentPath, contextNode, null, true);
                    if (contextObject == null) {
                        throw new UnknownAmetysObjectException("There's no object at path " + jcrName + " from path " + (String)contextPath);
                    }
                    return (A)resolver.resolveVirtualChild(contextObject, TraversableAmetysObjectHelper._computeSubPath(pathElements, i));
                }
                throw new UnknownAmetysObjectException("There's no object at path " + jcrName + " from path " + (String)contextPath);
            }
            return factory.getAmetysObject(contextNode, contextParentPath);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to resolve AmetysObject at path " + path + " relative to AmetysObject at path " + object.getPath(), e);
        }
    }

    private static String _computeSubPath(String[] pathElements, int beginIndex) {
        String subPath = null;
        for (int j = beginIndex; j < pathElements.length; ++j) {
            subPath = subPath == null ? pathElements[j] : subPath + "/" + pathElements[j];
        }
        return subPath;
    }

    public static <A extends AmetysObject> AmetysObjectIterable<A> getChildren(JCRTraversableAmetysObject object, JCRAmetysObjectFactory factory, AmetysObjectResolver resolver, Logger logger) throws AmetysRepositoryException {
        if (logger.isDebugEnabled()) {
            logger.debug("Entering DefaultTraversableAmetysObjectFactory.getChildren with object=" + String.valueOf(object));
        }
        try {
            Node node = object.getNode();
            NodeIterator it = node.getNodes();
            ArrayList children = new ArrayList((int)it.getSize());
            while (it.hasNext()) {
                Node child = it.nextNode();
                String type = NodeTypeHelper.getNodeTypeName(child);
                if (factory.getNodetypes().contains(type)) {
                    children.add(factory.getAmetysObject(child, object.getPath()));
                    continue;
                }
                Object obj = resolver.resolve(object.getPath(), child, null, true);
                if (obj == null) continue;
                children.add(obj);
            }
            CollectionIterable childrenIt = new CollectionIterable(children);
            if (node.hasProperty("ametys-internal:virtual")) {
                AmetysObjectIterable virtualIt = resolver.resolveVirtualChildren(object);
                ArrayList chainedList = new ArrayList();
                chainedList.add(childrenIt);
                chainedList.add(virtualIt);
                return new ChainedAmetysObjectIterable(chainedList);
            }
            return childrenIt;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to retrieve children", e);
        }
    }

    public static boolean hasChild(JCRTraversableAmetysObject object, String name, AmetysObjectFactoryExtensionPoint ametysFactoryExtensionPoint, Logger logger) throws AmetysRepositoryException {
        if (logger.isDebugEnabled()) {
            logger.debug("Entering DefaultTraversableAmetysObjectFactory.hasChild with object=" + String.valueOf(object) + ", name=" + name);
        }
        if (name == null || "".equals(name) || name.charAt(0) == '/') {
            throw new AmetysRepositoryException("Child name cannot be null, empty or absolute");
        }
        if (".".equals(name) || "..".equals(name)) {
            throw new AmetysRepositoryException("Child name cannot be . or ..");
        }
        Node node = object.getNode();
        try {
            String jcrName = TraversableAmetysObjectHelper._escape(name);
            if (node.hasNode(jcrName)) {
                Node childNode;
                String nodetype;
                if (logger.isDebugEnabled()) {
                    logger.debug("Child node exists: " + jcrName);
                }
                return ametysFactoryExtensionPoint.getFactoryForNodetype(nodetype = NodeTypeHelper.getNodeTypeName(childNode = node.getNode(jcrName))) != null;
            }
            if (node.hasProperty("ametys-internal:virtual")) {
                Value[] values;
                if (logger.isDebugEnabled()) {
                    logger.debug("Looking for virtuals...");
                }
                for (Value value : values = node.getProperty("ametys-internal:virtual").getValues()) {
                    String virtual = value.getString();
                    VirtualAmetysObjectFactory virtualFactory = TraversableAmetysObjectHelper._getVirtualFactory(virtual, ametysFactoryExtensionPoint, logger);
                    if (!virtualFactory.hasChild(object, name)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to test if the underlying Node for object " + object.getId() + " has a child named " + name, e);
        }
    }

    private static VirtualAmetysObjectFactory _getVirtualFactory(String id, AmetysObjectFactoryExtensionPoint ametysFactoryExtensionPoint, Logger logger) {
        AmetysObjectFactory factory;
        if (logger.isDebugEnabled()) {
            logger.debug("Found virtual id: " + id);
        }
        if ((factory = (AmetysObjectFactory)ametysFactoryExtensionPoint.getExtension(id)) == null) {
            throw new AmetysRepositoryException("There's no virtual factory for id " + id);
        }
        if (!(factory instanceof VirtualAmetysObjectFactory)) {
            throw new AmetysRepositoryException("A factory handling virtual objects must implement VirtualAmetysObjectFactory: " + id);
        }
        VirtualAmetysObjectFactory virtualFactory = (VirtualAmetysObjectFactory)factory;
        return virtualFactory;
    }

    public static <A extends AmetysObject> A createChild(JCRTraversableAmetysObject object, JCRAmetysObjectFactory factory, String name, String type, AmetysObjectFactoryExtensionPoint ametysFactoryExtensionPoint, AmetysObjectResolver resolver, Logger logger) throws AmetysRepositoryException {
        if (logger.isDebugEnabled()) {
            logger.debug("Entering DefaultTraversableAmetysObjectFactory.createChild with object=" + String.valueOf(object) + ", name=" + name + ", type=" + type);
        }
        if (ametysFactoryExtensionPoint.getFactoryForNodetype(type) == null) {
            throw new AmetysRepositoryException("Cannot create a node '" + name + "' under '" + object.getPath() + " (" + object.getId() + ")': There's no factory for nodetype: " + type);
        }
        Node contextNode = object.getNode();
        try {
            TraversableAmetysObjectHelper._checkLock(contextNode);
            String legalName = TraversableAmetysObjectHelper._escape(name);
            Node node = contextNode.addNode(legalName, type);
            NodeType[] mixinNodeTypes = node.getMixinNodeTypes();
            boolean foundMixin = false;
            for (int i = 0; !foundMixin && i < mixinNodeTypes.length; ++i) {
                if (!"ametys:object".equals(mixinNodeTypes[i].getName())) continue;
                foundMixin = true;
            }
            if (!foundMixin) {
                node.addMixin("ametys:object");
            }
            if (factory.getNodetypes().contains(type)) {
                return factory.getAmetysObject(node, object.getPath());
            }
            return resolver.resolve(object.getPath(), node, null, false);
        }
        catch (ItemExistsException e) {
            throw new RepositoryIntegrityViolationException("The object " + name + " already exist at path " + object.getParentPath(), e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to add child node for the underlying node for object " + object.getId(), e);
        }
    }

    private static String _escape(String qName) {
        int index = qName.indexOf(58);
        if (index == -1) {
            return Text.escapeIllegalJcrChars((String)qName);
        }
        return qName.substring(0, index) + ":" + Text.escapeIllegalJcrChars((String)qName.substring(index + 1, qName.length()));
    }

    private static void _checkLock(Node node) throws RepositoryException {
        if (node.isLocked()) {
            LockManager lockManager = node.getSession().getWorkspace().getLockManager();
            Lock lock = lockManager.getLock(node.getPath());
            Node lockHolder = lock.getNode();
            lockManager.addLockToken(lockHolder.getProperty("ametys-internal:lockToken").getString());
        }
    }
}

