/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.lock;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.lock.LockAwareAmetysObject;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.ametys.plugins.repository.lock.UnlockRunnable;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class UnlockHelper
extends AbstractLogEnabled
implements Initializable,
ThreadSafe,
Component,
Serviceable,
Disposable {
    public static final String ROLE = UnlockHelper.class.getName();
    private static final String __ACTIVATE_PARAMETER = "content.unlocktimer.activate";
    private static final String __PERIOD_PARAMETER = "content.unlocktimer.period";
    protected Scheduler _scheduler;
    private boolean _activated;
    private long _period;
    private Map<String, LocalDateTime> _lockedObjects;
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)((Object)manager.lookup(AmetysObjectResolver.ROLE));
        this._scheduler = (Scheduler)manager.lookup(Scheduler.ROLE);
    }

    public void initialize() throws Exception {
        Config config = Config.getInstance();
        if (config == null || PluginsManager.getInstance().isSafeMode()) {
            this._activated = false;
        } else {
            this._activated = (Boolean)config.getValue(__ACTIVATE_PARAMETER);
            if (this._activated) {
                this._period = (Long)config.getValue(__PERIOD_PARAMETER);
                if (this._period <= 0L) {
                    throw new RuntimeException("Invalid period (in hours) : '" + this._period + "'");
                }
            } else {
                this._period = 0L;
            }
        }
        this._initializeLockedObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initializeLockedObjects() {
        this._lockedObjects = new HashMap<String, LocalDateTime>();
        try (AmetysObjectIterable it = this._resolver.query("//element(*, ametys:object)[@jcr:lockOwner]");){
            for (LockableAmetysObject object : it) {
                if (object.isLocked() && this._activated) {
                    this.scheduleUnlocking(object);
                    this.getLogger().info("Scheduled unlocking in " + this._period + " hour(s) for object '{}'", (Object)object.getName());
                    continue;
                }
                if (!object.isLocked() || this._activated) continue;
                Map<String, LocalDateTime> map = this._lockedObjects;
                synchronized (map) {
                    this._lockedObjects.put(object.getId(), LocalDateTime.now());
                }
                this._cancelUnlocking(object);
            }
        }
    }

    public boolean isUnlockingActivated() {
        return this._activated;
    }

    public long getTimeBeforeUnlock() {
        return this._period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleUnlocking(AmetysObject object) {
        Map<String, LocalDateTime> map = this._lockedObjects;
        synchronized (map) {
            this._lockedObjects.put(object.getId(), LocalDateTime.now());
        }
        if (this._activated) {
            try {
                ZonedDateTime unlockDate = ZonedDateTime.now().plusHours(this._period);
                UserIdentity lockUser = Optional.ofNullable(object).filter(LockableAmetysObject.class::isInstance).map(LockableAmetysObject.class::cast).map(LockAwareAmetysObject::getLockOwner).orElse(UserPopulationDAO.SYSTEM_USER_IDENTITY);
                UnlockRunnable unlockRunnable = new UnlockRunnable(object.getId(), object.getName(), unlockDate, lockUser);
                JobKey jobKey = new JobKey(unlockRunnable.getId(), "runtime.job");
                if (this._scheduler.getScheduler().checkExists(jobKey)) {
                    this._scheduler.getScheduler().deleteJob(jobKey);
                }
                this._scheduler.scheduleJob((Runnable)unlockRunnable);
                this.getLogger().info("Scheduled unlocking in " + this._period + " hour(s) for object '{}'", (Object)object.getName());
            }
            catch (SchedulerException e) {
                this.getLogger().error("An error occured when trying to schedule the unlocking of the object " + object.getId(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelUnlocking(AmetysObject object) {
        Map<String, LocalDateTime> map = this._lockedObjects;
        synchronized (map) {
            this._lockedObjects.remove(object.getId());
        }
        if (this._activated) {
            return this._cancelUnlocking(object);
        }
        return false;
    }

    private boolean _cancelUnlocking(AmetysObject object) {
        try {
            String jobName = UnlockRunnable.class.getName() + "." + object.getId();
            JobKey jobKey = new JobKey(jobName, "runtime.job");
            if (this._scheduler.getScheduler().checkExists(jobKey)) {
                this._scheduler.getScheduler().deleteJob(jobKey);
                return true;
            }
        }
        catch (SchedulerException e) {
            this.getLogger().error("An error occured when trying to schedule the unlocking of the object " + object.getId(), (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends LockableAmetysObject> Map<A, LocalDateTime> getLockedObjects() {
        HashMap<LockableAmetysObject, LocalDateTime> result = new HashMap<LockableAmetysObject, LocalDateTime>();
        Map<String, LocalDateTime> map = this._lockedObjects;
        synchronized (map) {
            for (Map.Entry<String, LocalDateTime> entry : this._lockedObjects.entrySet()) {
                try {
                    LockableAmetysObject object = (LockableAmetysObject)this._resolver.resolveById(entry.getKey());
                    if (!object.isLocked()) continue;
                    result.put(object, entry.getValue());
                }
                catch (UnknownAmetysObjectException e) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("The object of ID " + entry.getKey() + " is referenced as locked but it doesn't exist anymore.", (Throwable)e);
                    }
                    this._lockedObjects.remove(entry.getKey());
                }
            }
        }
        return result;
    }

    public void dispose() {
        this._activated = false;
        this.setLogger(null);
        this._resolver = null;
        this._lockedObjects = null;
    }
}

