/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.lock;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.i18n.I18nizableText;

public class UnlockRunnable
implements Runnable {
    protected String _objectId;
    protected String _objectName;
    protected ZonedDateTime _date;
    protected UserIdentity _userIdentity;

    public UnlockRunnable(String objectId, String objectName, ZonedDateTime date, UserIdentity userIdentity) {
        this._objectId = objectId;
        this._objectName = objectName;
        this._date = date.withZoneSameInstant(ZoneId.systemDefault());
        this._userIdentity = userIdentity;
    }

    public String getId() {
        return this.getClass().getName() + "." + this._objectId;
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.repository", "PLUGINS_REPOSITORY_UNLOCK_RUNNABLE_LABEL", Collections.singletonList(this._objectName));
    }

    public I18nizableText getDescription() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(this._objectId);
        parameters.add(this._objectName);
        return new I18nizableText("plugin.repository", "PLUGINS_REPOSITORY_UNLOCK_RUNNABLE_DESCRIPTION", parameters);
    }

    public Runnable.FireProcess getFireProcess() {
        return Runnable.FireProcess.CRON;
    }

    public String getCronExpression() {
        return this._date.getSecond() + " " + this._date.getMinute() + " " + this._date.getHour() + " " + this._date.getDayOfMonth() + " " + this._date.getMonthValue() + " ? " + this._date.getYear();
    }

    public String getSchedulableId() {
        return "org.ametys.plugins.repository.lock.UnlockSchedulable";
    }

    public boolean isRemovable() {
        return false;
    }

    public boolean isModifiable() {
        return false;
    }

    public boolean isDeactivatable() {
        return false;
    }

    public Runnable.MisfirePolicy getMisfirePolicy() {
        return Runnable.MisfirePolicy.FIRE_ONCE;
    }

    public boolean isVolatile() {
        return false;
    }

    public Map<String, Object> getParameterValues() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("objectId", this._objectId);
        return values;
    }

    public UserIdentity getUserIdentity() {
        return this._userIdentity;
    }
}

