/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.lock;

import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class UnlockSchedulable
extends AbstractStaticSchedulable {
    public static final String OBJECT_ID_KEY = "objectId";
    private static final String __JOBDATAMAP_OBJECT_ID_KEY = "parameterValues#objectId";
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)((Object)manager.lookup(AmetysObjectResolver.ROLE));
    }

    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        block4: {
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            String objectId = (String)jobDataMap.get((Object)__JOBDATAMAP_OBJECT_ID_KEY);
            this.getLogger().info("Trying to unlock the object '{}'", (Object)objectId);
            try {
                LockableAmetysObject object = (LockableAmetysObject)this._resolver.resolveById(objectId);
                if (object.isLocked()) {
                    object.unlock();
                    this.getLogger().info("Successfully unlocked the object '{}'", (Object)objectId);
                } else {
                    this.getLogger().warn("The object of ID '{}' was scheduled to be unlocked but it already is.", (Object)objectId);
                }
            }
            catch (UnknownAmetysObjectException e) {
                if (!this.getLogger().isWarnEnabled()) break block4;
                this.getLogger().warn("The object of ID '" + objectId + "' was scheduled to be unlocked but it doesn't exist anymore.", (Throwable)e);
            }
        }
    }
}

