/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.maintenance;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.ametys.workspaces.repository.maintenance.AbstractMaintenanceTask;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.slf4j.LoggerFactory;

public class CleanReferenceTask
extends AbstractMaintenanceTask {
    private static final int __BUNDLE_SIZE = 100000;
    long _handled;
    int _inconsistent;
    int _partiallyInconsistent;
    int _cleaned;
    private Session _session;
    private NodeId _last;

    public boolean requiresOffline() {
        return false;
    }

    protected void initialize() throws RepositoryException {
        this._session = this.getOrCreateRepository().login((Credentials)new SimpleCredentials("__MAINTENANCE_TASK__", "".toCharArray()));
    }

    protected void apply() throws RepositoryException {
        RepositoryContext repositoryContext = this.getOrCreateRepositoryContext();
        List pmList = CleanReferenceTask.getAllPersistenceManager((RepositoryContext)repositoryContext);
        for (IterablePersistenceManager pm : pmList) {
            if (pm instanceof BundleDbPersistenceManager) {
                BundleDbPersistenceManager bundleDbPersistenceManager = (BundleDbPersistenceManager)pm;
                this._logger.info("Cleaning nodes for persistence manager {}", (Object)pm);
                this._cleanReferences(bundleDbPersistenceManager);
                continue;
            }
            this._logger.info("The persistence manager {} doesn't support the operation. It will be skipped.", (Object)pm.getClass().getName());
        }
    }

    private void _cleanReferences(BundleDbPersistenceManager bundleDbPersistenceManager) throws RepositoryException {
        try {
            this._handled = 0L;
            this._inconsistent = 0;
            this._partiallyInconsistent = 0;
            this._cleaned = 0;
            this._last = null;
            List allNodeIds = bundleDbPersistenceManager.getAllNodeIds(this._last, 100000);
            long total = 0L;
            while (!allNodeIds.isEmpty()) {
                total += (long)allNodeIds.size();
                Iterator iterator = allNodeIds.iterator();
                while (iterator.hasNext()) {
                    NodeId id;
                    this._last = id = (NodeId)iterator.next();
                    try {
                        if (!bundleDbPersistenceManager.existsReferencesTo(id)) continue;
                        this._cleanReferences(id, bundleDbPersistenceManager);
                    }
                    catch (ItemStateException e) {
                        this._logger.warn("Failed to retrieve references to node " + id.toString() + ". The node will be skipped.", (Throwable)e);
                    }
                }
                this._logger.info(String.format("%,d nodes processed...", total));
                allNodeIds = bundleDbPersistenceManager.getAllNodeIds(this._last, 100000);
            }
            this._logger.info(String.format("The operation is over. Out of %,d nodes found, %,d had references.%n%,d inconsistent nodes and %,d partially inconsistent nodes were found.%n%,d have been removed.", total, this._handled, this._inconsistent, this._partiallyInconsistent, this._cleaned));
        }
        catch (ItemStateException e) {
            this._logger.error("Failed to retrieve the node ids. Can't clean the reference", (Throwable)e);
            throw new RepositoryException("Failed to retrieve the node ids. Can't clean the reference", (Throwable)e);
        }
    }

    private void _cleanReferences(NodeId nodeId, BundleDbPersistenceManager persistenceManager) {
        try {
            NodeReferences nodeRefs = persistenceManager.loadReferencesTo(nodeId);
            List refs = nodeRefs.getReferences();
            int totalRefs = refs.size();
            int localInconsistent = 0;
            for (PropertyId ref : refs) {
                String uuid = ref.getParentId().toString();
                try {
                    this._session.getNodeByIdentifier(uuid);
                }
                catch (RepositoryException e) {
                    this._logger.debug("Inconsistent reference: " + nodeId.toString() + " <- " + uuid);
                    ++localInconsistent;
                }
            }
            if (localInconsistent > 0) {
                if (localInconsistent == totalRefs) {
                    ++this._inconsistent;
                    try {
                        Node node = this._session.getNodeByIdentifier(nodeId.toString());
                        this._logger.debug("Inconsistent references to " + node.getPath() + " (" + nodeId.toString() + ") will be deleted");
                        persistenceManager.destroy(nodeRefs);
                        ++this._cleaned;
                    }
                    catch (RepositoryException e) {
                        this._logger.warn("Failed to retrieve node " + nodeId.toString() + ". This node had inconsistencies. The node will be skipped and the process will continue.", (Throwable)e);
                    }
                    catch (ItemStateException e) {
                        this._logger.warn("Failed to destroy node references to inconsistent node " + nodeId.toString() + ". The node will be skipped and the process will continue.", (Throwable)e);
                    }
                } else {
                    ++this._partiallyInconsistent;
                    this._logger.info("Node " + nodeId.toString() + " is partially inconsistent. Nothing has been implemented to handle those case. It will be ignored by the cleaning operation.");
                }
            }
            ++this._handled;
        }
        catch (ItemStateException e) {
            this._logger.warn("Failed to retrieve references to node " + nodeId.toString() + ". The node will be skipped and the process will continue.", (Throwable)e);
        }
    }

    protected void close() {
        this._session.logout();
        super.close();
    }

    protected void setLogger() {
        this.setLogger(LoggerFactory.getLogger(CleanReferenceTask.class));
    }
}

