/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.maintenance;

import javax.jcr.Repository;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.ametys.plugins.repository.maintenance.CleanReferenceTask;
import org.ametys.plugins.repository.maintenance.ReclaimUnusedSpaceTask;
import org.ametys.plugins.repository.provider.AmetysRepository;
import org.ametys.workspaces.repository.maintenance.AbstractMaintenanceTask;
import org.ametys.workspaces.repository.maintenance.MaintenanceTaskManager;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;

public class MaintenanceTaskManager
extends org.ametys.workspaces.repository.maintenance.MaintenanceTaskManager {
    protected AbstractMaintenanceTask _createTask(MaintenanceTaskManager.MaintenanceTaskType type) {
        switch (type) {
            case REMOVE_INCOHERENT_REFERENCES: {
                return new CleanReferenceTask();
            }
            case RECLAIM_UNUSED_SPACE: {
                return new ReclaimUnusedSpaceTask();
            }
        }
        return super._createTask(type);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Pair<RepositoryConfig, RepositoryContext> _getRepositoryInfo() throws ConfigurationException, UnsupportedRepositoryOperationException {
        RepositoryContext repositoryContext;
        RepositoryConfig repositoryConfig;
        if (this._repositoryProvider == null) {
            repositoryConfig = this._createRepositoryConfig();
            repositoryContext = null;
            return Pair.of((Object)repositoryConfig, repositoryContext);
        }
        Repository repository = this._repositoryProvider.getRepository();
        if (!(repository instanceof AmetysRepository)) {
            this._runningTaskType = null;
            throw new UnsupportedRepositoryOperationException("A maintenance task can not be run on an online repository instance of " + this._repositoryProvider.getRepository().getClass().getName());
        }
        AmetysRepository ametysRepository = (AmetysRepository)repository;
        if (!_runningTask.requiresOffline()) {
            repositoryConfig = null;
            repositoryContext = ametysRepository.getContext();
            return Pair.of((Object)repositoryConfig, repositoryContext);
        }
        MaintenanceTaskManager.MaintenanceTaskType type = this._runningTaskType;
        this._runningTaskType = null;
        throw new UnsupportedRepositoryOperationException("A maintenance task of type " + String.valueOf(type) + " can not be run on an online repository");
    }
}

