/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.maintenance;

import java.io.File;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.plugins.repository.provider.AmetysPersistenceManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.workspaces.repository.maintenance.AbstractMaintenanceTask;
import org.ametys.workspaces.repository.maintenance.DataStoreGarbageCollectorTask;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.DerbyPersistenceManager;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReclaimUnusedSpaceTask
extends AbstractMaintenanceTask {
    protected void initialize() throws RepositoryException {
        this._progress = ProgressionTrackerFactory.createContainerProgressionTracker((I18nizableText)new I18nizableText("plugin.repository", "PLUGINS_REPOSITORY_BUTTON_MAINTENANCE_RECLAIMUNUSEDSPACE"), (Logger)this._logger);
    }

    protected void apply() throws RepositoryException {
        this._logger.info("Reclaiming unused space, this may take several minutes depending on the size of the data store.\nPlease be patient.");
        RepositoryContext repositoryContext = this.getOrCreateRepositoryContext();
        String[] workspaceNames = repositoryContext.getWorkspaceManager().getWorkspaceNames();
        this._progress.setSize((long)(workspaceNames.length + 1));
        for (String workspaceName : workspaceNames) {
            try {
                this._logger.info("Handling workspace " + workspaceName + "...");
                PersistenceManager persistenceManager = repositoryContext.getWorkspaceInfo(workspaceName).getPersistenceManager();
                this._reclaimUnusedSpace(persistenceManager);
            }
            catch (Exception e) {
                this._logger.warn("An error occurred while handling workspace " + workspaceName + ". The workspace will be skipped.", (Throwable)e);
            }
            this._progress.increment();
        }
        try {
            this._logger.info("Handling version history...");
            PersistenceManager versionPersistenceManager = repositoryContext.getInternalVersionManager().getPersistenceManager();
            this._reclaimUnusedSpace(versionPersistenceManager);
        }
        catch (Exception e) {
            this._logger.warn("An error occurred while handling version data source. The datasource will be skipped.", (Throwable)e);
        }
        this._progress.increment();
    }

    private void _reclaimUnusedSpace(PersistenceManager persistenceManager) throws RepositoryException {
        if (persistenceManager instanceof AmetysPersistenceManager) {
            AmetysPersistenceManager ametysPersistenceManager = (AmetysPersistenceManager)persistenceManager;
            this._reclaimUnusedSpace((PersistenceManager)ametysPersistenceManager.getWrappedPM());
        } else if (persistenceManager instanceof DerbyPersistenceManager) {
            DerbyPersistenceManager derbyPersistenceManager = (DerbyPersistenceManager)persistenceManager;
            this._reclaimUnusedSpace(derbyPersistenceManager);
        }
    }

    private void _reclaimUnusedSpace(DerbyPersistenceManager derbyPersistenceManager) throws RepositoryException {
        String url = derbyPersistenceManager.getUrl();
        String path = StringUtils.substringAfter((String)url, (String)"jdbc:derby:");
        path = StringUtils.substringBefore((String)path, (String)";");
        File dbDirectory = new File(path);
        DataSource dataSource = this._getDataSource((BundleDbPersistenceManager)derbyPersistenceManager);
        String schemaObjectPrefix = derbyPersistenceManager.getSchemaObjectPrefix();
        long startSize = FileUtils.sizeOfDirectory((File)dbDirectory);
        DataStoreGarbageCollectorTask.derbyCompressTable((DataSource)dataSource, (String)(schemaObjectPrefix + "REFS"), (Logger)this._logger);
        DataStoreGarbageCollectorTask.derbyCompressTable((DataSource)dataSource, (String)(schemaObjectPrefix + "BUNDLE"), (Logger)this._logger);
        long endSize = FileUtils.sizeOfDirectory((File)dbDirectory);
        if (startSize > endSize) {
            this._logger.info(String.format("%s freed. (%s -> %s)", FileUtils.byteCountToDisplaySize((long)(startSize - endSize)), FileUtils.byteCountToDisplaySize((long)startSize), FileUtils.byteCountToDisplaySize((long)endSize)));
        } else {
            this._logger.info("No space freed");
        }
    }

    private DataSource _getDataSource(BundleDbPersistenceManager pm) throws RepositoryException {
        try {
            ConnectionFactory cf = this.getRepositoryConfig().getConnectionFactory();
            if (pm.getDataSourceName() == null || "".equals(pm.getDataSourceName())) {
                return cf.getDataSource(pm.getDriver(), pm.getUrl(), pm.getUser(), pm.getPassword());
            }
            return cf.getDataSource(pm.getDataSourceName());
        }
        catch (SQLException e) {
            this._logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (RepositoryException e) {
            this._logger.warn("Failed to retrieve the datasource from persistence manager.", (Throwable)e);
            throw e;
        }
    }

    protected void setLogger() {
        this.setLogger(LoggerFactory.getLogger(ReclaimUnusedSpaceTask.class));
    }
}

