/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.metadata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MultilingualString {
    private Map<Locale, String> _values;

    public MultilingualString() {
        this._values = new HashMap<Locale, String>();
    }

    public MultilingualString(Map<Locale, String> values) {
        this._values = values;
    }

    public void add(Locale locale, String value) {
        this._values.put(locale, value);
    }

    public String getValue(Locale locale) {
        return this._values.get(locale);
    }

    public Set<Locale> getLocales() {
        return this._values.keySet();
    }

    public List<String> getValues() {
        return this._values.values().stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v)).collect(Collectors.toList());
    }

    public boolean hasLocale(Locale locale) {
        return this._values.containsKey(locale);
    }

    public boolean equals(Object obj) {
        Object[] otherLocales;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultilingualString)) {
            return false;
        }
        MultilingualString other = (MultilingualString)obj;
        Object[] locales = (Locale[])this.getLocales().stream().toArray(Locale[]::new);
        if (!Arrays.deepEquals(locales, otherLocales = (Locale[])other.getLocales().stream().toArray(Locale[]::new))) {
            return false;
        }
        for (Object locale : locales) {
            if (this.getValue((Locale)locale).equals(other.getValue((Locale)locale))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this._values.hashCode();
    }
}

