/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.metadata;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.ametys.core.util.dom.DOMUtils;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.metadata.CompositeMetadata;
import org.ametys.plugins.repository.metadata.MultilingualString;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class MultilingualStringHelper {
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final String __LOCALE_AND_VALUE_SEPARATOR = ":";
    private static final String __ENTRIES_SEPARATOR = "#";

    private MultilingualStringHelper() {
    }

    @Deprecated
    public static String getValue(CompositeMetadata parentMetadata, String metadataName, Locale locale) throws AmetysRepositoryException {
        if (parentMetadata.hasMetadata(metadataName)) {
            MultilingualString multilingualString = parentMetadata.getMultilingualString(metadataName);
            return MultilingualStringHelper.getValue(multilingualString, locale);
        }
        return null;
    }

    public static String getValue(ModelLessDataHolder dataHolder, String dataName, Locale locale) throws AmetysRepositoryException {
        if (dataHolder.hasValue(dataName)) {
            MultilingualString multilingualString = (MultilingualString)dataHolder.getValue(dataName);
            return MultilingualStringHelper.getValue(multilingualString, locale);
        }
        return null;
    }

    public static String getValue(ModelAwareDataHolder dataHolder, String dataName, Locale locale) throws AmetysRepositoryException {
        if (dataHolder.hasValue(dataName)) {
            MultilingualString multilingualString = (MultilingualString)dataHolder.getValue(dataName);
            return MultilingualStringHelper.getValue(multilingualString, locale);
        }
        return null;
    }

    public static String getValue(MultilingualString multilingualString, Locale locale) throws AmetysRepositoryException {
        Locale closestLocale = MultilingualStringHelper.getClosestNonEmptyLocale(multilingualString, locale);
        if (closestLocale != null) {
            return multilingualString.getValue(closestLocale);
        }
        return null;
    }

    public static Locale getClosestNonEmptyLocale(MultilingualString multilingualString, Locale locale) throws AmetysRepositoryException {
        if (locale != null && multilingualString.hasLocale(locale)) {
            return locale;
        }
        List<Locale> closedLocales = MultilingualStringHelper.localeLookupList(locale);
        for (Locale closedLocale : closedLocales) {
            if (!multilingualString.hasLocale(closedLocale)) continue;
            return closedLocale;
        }
        Set<Locale> allLocales = multilingualString.getLocales();
        if (!allLocales.isEmpty()) {
            return allLocales.iterator().next();
        }
        return null;
    }

    public static List<Locale> localeLookupList(Locale locale) {
        if (locale != null) {
            return LocaleUtils.localeLookupList((Locale)locale, (Locale)DEFAULT_LOCALE);
        }
        return Collections.singletonList(DEFAULT_LOCALE);
    }

    @Deprecated
    public static void sax(ContentHandler contentHandler, String tagName, MultilingualString multilingualString, Locale locale) throws SAXException {
        MultilingualStringHelper.sax(contentHandler, tagName, multilingualString, new AttributesImpl(), locale);
    }

    public static void sax(ContentHandler contentHandler, String tagName, MultilingualString multilingualString, AttributesImpl attributes, Locale locale) throws SAXException {
        AttributesImpl localAttributes = new AttributesImpl((Attributes)attributes);
        if (locale == null) {
            XMLUtils.startElement((ContentHandler)contentHandler, (String)tagName, (Attributes)localAttributes);
            for (Locale valueLocale : multilingualString.getLocales()) {
                XMLUtils.createElement((ContentHandler)contentHandler, (String)valueLocale.toString(), (String)multilingualString.getValue(valueLocale));
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)tagName);
        } else {
            Locale closestLocale = MultilingualStringHelper.getClosestNonEmptyLocale(multilingualString, locale);
            if (closestLocale != null) {
                localAttributes.addCDATAAttribute("lang", closestLocale.toString());
                XMLUtils.createElement((ContentHandler)contentHandler, (String)tagName, (Attributes)localAttributes, (String)multilingualString.getValue(closestLocale));
            }
        }
    }

    public static MultilingualString fromXML(Element element) {
        if (element != null) {
            String lang = element.getAttribute("lang");
            if (StringUtils.isNotEmpty((CharSequence)lang)) {
                MultilingualString multilingualString = new MultilingualString();
                String value = element.getTextContent();
                multilingualString.add(LocaleUtils.toLocale((String)lang), value);
                return multilingualString;
            }
            MultilingualString multilingualString = new MultilingualString();
            for (Element entry : DOMUtils.getChildElements((Element)element)) {
                String languageTag = entry.getNodeName();
                String value = entry.getTextContent();
                multilingualString.add(LocaleUtils.toLocale((String)languageTag), value);
            }
            return multilingualString;
        }
        return null;
    }

    public static Map<String, Object> toJson(MultilingualString multilingualString) throws AmetysRepositoryException {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        for (Locale locale : multilingualString.getLocales()) {
            json.put(locale.toString(), multilingualString.getValue(locale));
        }
        return json;
    }

    public static MultilingualString fromJSON(Map<String, ? extends Object> json) {
        if (json == null) {
            return null;
        }
        MultilingualString multilingualString = new MultilingualString();
        for (Map.Entry<String, ? extends Object> entry : json.entrySet()) {
            Locale locale = LocaleUtils.toLocale((String)entry.getKey());
            String value = entry.getValue().toString();
            multilingualString.add(locale, value);
        }
        return multilingualString;
    }

    public static String toString(MultilingualString multilingualString) {
        if (multilingualString != null) {
            StringBuilder asString = new StringBuilder();
            Iterator<Locale> localesIterator = multilingualString.getLocales().iterator();
            while (localesIterator.hasNext()) {
                Locale locale = localesIterator.next();
                asString.append(locale.toString()).append(__LOCALE_AND_VALUE_SEPARATOR).append(multilingualString.getValue(locale));
                if (!localesIterator.hasNext()) continue;
                asString.append(__ENTRIES_SEPARATOR);
            }
            return asString.toString();
        }
        return null;
    }

    public static MultilingualString fromString(String string) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (string.contains(__LOCALE_AND_VALUE_SEPARATOR)) {
            String[] entries;
            MultilingualString multilingualString = new MultilingualString();
            for (String entry : entries = string.split(__ENTRIES_SEPARATOR)) {
                String localeAsString = StringUtils.substringBeforeLast((String)entry, (String)__LOCALE_AND_VALUE_SEPARATOR);
                String value = StringUtils.substringAfterLast((String)entry, (String)__LOCALE_AND_VALUE_SEPARATOR);
                multilingualString.add(LocaleUtils.toLocale((String)localeAsString), value);
            }
            return multilingualString;
        }
        throw new IllegalArgumentException("Unable to cast '" + string + "' to a multilingual string");
    }

    public static boolean matchesMultilingualStringPattern(String string) {
        if (string.contains(__LOCALE_AND_VALUE_SEPARATOR)) {
            String[] entries;
            boolean localeExists = true;
            for (String entry : entries = string.split(__ENTRIES_SEPARATOR)) {
                String localeAsString = StringUtils.substringBeforeLast((String)entry, (String)__LOCALE_AND_VALUE_SEPARATOR);
                try {
                    LocaleUtils.toLocale((String)localeAsString);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            return localeExists;
        }
        return false;
    }
}

